/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_809;
import vazkii.botania.api.item.ICosmeticBauble;
import vazkii.botania.client.core.helper.RenderHelper;

import java.util.List;

public class ItemBaubleCosmetic extends ItemBauble implements ICosmeticBauble {

	public enum Variant {
		BLACK_BOWTIE, BLACK_TIE, RED_GLASSES(true), PUFFY_SCARF,
		ENGINEER_GOGGLES(true), EYEPATCH(true), WICKED_EYEPATCH(true), RED_RIBBONS(true),
		PINK_FLOWER_BUD(true), POLKA_DOTTED_BOWS(true), BLUE_BUTTERFLY(true), CAT_EARS(true),
		WITCH_PIN, DEVIL_TAIL, KAMUI_EYE, GOOGLY_EYES(true),
		FOUR_LEAF_CLOVER, CLOCK_EYE(true), UNICORN_HORN(true), DEVIL_HORNS(true),
		HYPER_PLUS(true), BOTANIST_EMBLEM, ANCIENT_MASK(true), EERIE_MASK(true),
		ALIEN_ANTENNA(true), ANAGLYPH_GLASSES(true), ORANGE_SHADES(true), GROUCHO_GLASSES(true),
		THICK_EYEBROWS(true), LUSITANIC_SHIELD, TINY_POTATO_MASK(true), QUESTGIVER_MARK(true),
		THINKING_HAND(true);

		private final boolean isHead;

		Variant(boolean isHead) {
			this.isHead = isHead;
		}

		Variant() {
			this(false);
		}
	}

	private final Variant variant;
	public static final int SUBTYPES = Variant.values().length;

	public ItemBaubleCosmetic(Variant variant, class_1793 props) {
		super(props);
		this.variant = variant;
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void addHiddenTooltip(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flags) {
		if (variant == Variant.THINKING_HAND) {
			tooltip.add(new class_2588("botaniamisc.cosmeticThinking").method_27695(class_124.field_1056, class_124.field_1080));
		} else {
			tooltip.add(new class_2588("botaniamisc.cosmeticBauble").method_27695(class_124.field_1056, class_124.field_1080));
		}
		super.addHiddenTooltip(stack, world, tooltip, flags);
	}

	@Override
	@Environment(EnvType.CLIENT)
	public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 player, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
		Variant variant = ((ItemBaubleCosmetic) stack.method_7909()).variant;
		if (variant.isHead) {
			bipedModel.field_3398.method_22703(ms);
			switch (variant) {
			case RED_GLASSES:
			case ENGINEER_GOGGLES:
			case ANAGLYPH_GLASSES:
				ms.method_22904(0, -0.225, -0.3);
				ms.method_22905(0.7F, -0.7F, -0.7F);
				renderItem(stack, ms, buffers, light);
				break;
			case EYEPATCH:
				ms.method_22904(0.125, -0.225, -0.3);
				ms.method_22907(class_1160.field_20705.method_23214(180F));
				ms.method_22905(0.3F, -0.3F, -0.3F);
				renderItem(stack, ms, buffers, light);
				break;
			case WICKED_EYEPATCH:
				ms.method_22904(-0.125, -0.225, -0.3);
				ms.method_22905(0.3F, -0.3F, -0.3F);
				renderItem(stack, ms, buffers, light);
				break;
			case RED_RIBBONS:
				ms.method_22904(0, -0.65, 0.2);
				ms.method_22907(class_1160.field_20705.method_23214(180F));
				ms.method_22905(0.5F, -0.5F, -0.5F);
				renderItem(stack, ms, buffers, light);
				break;
			case PINK_FLOWER_BUD:
				ms.method_22904(0.275, -0.6, 0);
				ms.method_22907(class_1160.field_20705.method_23214(-90F));
				ms.method_22905(0.5F, -0.5F, -0.5F);
				renderItem(stack, ms, buffers, light);
				break;
			case POLKA_DOTTED_BOWS:
				ms.method_22903();
				ms.method_22904(0.275, -0.4, 0);
				ms.method_22907(class_1160.field_20705.method_23214(-90F));
				ms.method_22905(0.5F, -0.5F, -0.5F);
				renderItem(stack, ms, buffers, light);
				ms.method_22909();

				ms.method_22904(-0.275, -0.4, 0);
				ms.method_22907(class_1160.field_20705.method_23214(90F));
				ms.method_22905(0.5F, -0.5F, -0.5F);
				renderItem(stack, ms, buffers, light);
				break;
			case BLUE_BUTTERFLY:
				ms.method_22903();
				ms.method_22904(0.275, -0.4, 0);
				ms.method_22907(class_1160.field_20705.method_23214(45F));
				ms.method_22905(0.5F, -0.5F, -0.5F);
				renderItem(stack, ms, buffers, light);
				ms.method_22909();

				ms.method_22904(0.275, -0.4, 0);
				ms.method_22907(class_1160.field_20705.method_23214(-45F));
				ms.method_22905(0.5F, -0.5F, -0.5F);
				renderItem(stack, ms, buffers, light);
				break;
			case CAT_EARS:
				ms.method_22904(0F, -0.5F, -0.175F);
				ms.method_22905(0.5F, -0.5F, -0.5F);
				renderItem(stack, ms, buffers, light);
				break;
			case GOOGLY_EYES:
				ms.method_22904(0, -0.225, -0.3);
				ms.method_22905(0.9F, -0.9F, -0.9F);
				renderItem(stack, ms, buffers, light);
				break;
			case CLOCK_EYE:
				ms.method_22904(0.1, -0.225, -0.3F);
				ms.method_22905(0.4F, -0.4F, -0.4F);
				renderItem(stack, ms, buffers, light);
				break;
			case UNICORN_HORN:
				ms.method_22904(0, -0.7, -0.3);
				ms.method_22907(class_1160.field_20705.method_23214(-90F));
				ms.method_22905(0.6F, -0.6F, -0.6F);
				renderItem(stack, ms, buffers, light);
				break;
			case DEVIL_HORNS:
				ms.method_22904(0F, -0.4F, -0.175F);
				ms.method_22905(0.5F, -0.5F, -0.5F);
				renderItem(stack, ms, buffers, light);
				break;
			case HYPER_PLUS:
				ms.method_22904(-0.15F, -0.45F, -0.3F);
				ms.method_22905(0.2F, -0.2F, -0.2F);
				renderItem(stack, ms, buffers, light);
				ms.method_22904(1.45F, 0F, 0F);
				renderItem(stack, ms, buffers, light);
				break;
			case ANCIENT_MASK:
				ms.method_22904(0, -0.3, -0.3);
				ms.method_22905(0.7F, -0.7F, -0.7F);
				renderItem(stack, ms, buffers, light);
				break;
			case EERIE_MASK:
				ms.method_22904(0, -0.25, -0.3);
				ms.method_22905(0.5F, -0.5F, -0.5F);
				renderItem(stack, ms, buffers, light);
				break;
			case ALIEN_ANTENNA:
				ms.method_22904(0, -0.65, 0.2);
				ms.method_22905(0.5F, -0.5F, -0.5F);
				renderItem(stack, ms, buffers, light);
				break;
			case ORANGE_SHADES:
				ms.method_22904(0, -0.3, -0.3);
				ms.method_22905(0.7F, -0.7F, -0.7F);
				int color = 0xFFFFFF | (178 << 24);
				RenderHelper.renderItemCustomColor(player, stack, color, ms, buffers, light, class_4608.field_21444);
				break;
			case GROUCHO_GLASSES:
				ms.method_22904(0, -0.1, -0.3);
				ms.method_22905(0.75F, -0.75F, -0.75F);
				renderItem(stack, ms, buffers, light);
				break;
			case THICK_EYEBROWS:
				ms.method_22903();
				ms.method_22904(-0.1, -0.3, -0.3);
				ms.method_22905(0.3F, -0.3F, -0.3F);
				renderItem(stack, ms, buffers, light);
				ms.method_22909();

				ms.method_22904(0.1, -0.3, -0.3);
				ms.method_22907(class_1160.field_20705.method_23214(180F));
				ms.method_22905(0.3F, -0.3F, -0.3F);
				renderItem(stack, ms, buffers, light);
				break;
			case TINY_POTATO_MASK:
				ms.method_22904(0, -0.3, -0.3);
				ms.method_22905(0.6F, -0.6F, -0.6F);
				renderItem(stack, ms, buffers, light);
				break;
			case QUESTGIVER_MARK:
				ms.method_22904(0, -0.8, -0.2);
				ms.method_22905(0.5F, -0.5F, -0.5F);
				renderItem(stack, ms, buffers, light);
				break;
			case THINKING_HAND:
				ms.method_22904(-0.1, 0, -0.3);
				ms.method_22907(class_1160.field_20707.method_23214(-15F));
				ms.method_22905(0.5F, -0.5F, -0.5F);
				renderItem(stack, ms, buffers, light);
				break;
			default:
				break;
			}
		} else { // body cosmetics
			bipedModel.field_3391.method_22703(ms);
			switch (variant) {
			case BLACK_BOWTIE:
				ms.method_22904(0, 0.1, -0.13);
				ms.method_22905(0.6F, -0.6F, -0.6F);
				renderItem(stack, ms, buffers, light);
				break;
			case BLACK_TIE:
			case PUFFY_SCARF:
				ms.method_22904(0, 0.25, -0.15);
				ms.method_22905(0.5F, -0.5F, -0.5F);
				renderItem(stack, ms, buffers, light);
				break;
			case WITCH_PIN:
				ms.method_22904(-0.1, 0.15, -0.15);
				ms.method_22905(0.2F, -0.2F, -0.2F);
				renderItem(stack, ms, buffers, light);
				break;
			case DEVIL_TAIL:
				ms.method_22904(0, 0.55, 0.2);
				ms.method_22907(class_1160.field_20705.method_23214(-90F));
				ms.method_22905(0.6F, -0.6F, -0.6F);
				renderItem(stack, ms, buffers, light);
				break;
			case KAMUI_EYE: // DON'T LOSE YOUR WAAAAAAAAY
				ms.method_22903();
				ms.method_22904(0.4, 0.1, -0.2);
				ms.method_22905(0.5F, -0.5F, -0.5F);
				renderItem(stack, ms, buffers, light);
				ms.method_22909();

				ms.method_22904(-0.4, 0.1, -0.2);
				ms.method_22907(class_1160.field_20705.method_23214(180F));
				ms.method_22905(0.5F, -0.5F, -0.5F);
				RenderHelper.renderItemCustomColor(player, stack, 0xFF00004C, ms, buffers, light, class_4608.field_21444);
				break;
			case FOUR_LEAF_CLOVER:
				ms.method_22904(0.1, 0.1, -0.13);
				ms.method_22905(0.3F, -0.3F, -0.3F);
				renderItem(stack, ms, buffers, light);
				break;
			case BOTANIST_EMBLEM:
				ms.method_22904(0F, 0.375, -0.13);
				ms.method_22905(0.3F, -0.3F, -0.3F);
				renderItem(stack, ms, buffers, light);
				break;
			case LUSITANIC_SHIELD:
				ms.method_22904(0F, 0.35, 0.13);
				ms.method_22907(class_1160.field_20707.method_23214(8F));
				ms.method_22907(class_1160.field_20705.method_23214(180F));
				ms.method_22905(0.6F, -0.6F, -0.6F);
				renderItem(stack, ms, buffers, light);
				break;
			default:
				break;
			}
		}
	}

	public static void renderItem(class_1799 stack, class_4587 ms, class_4597 buffers, int light) {
		class_310.method_1551().method_1480().method_23178(stack, class_809.class_811.field_4315, light, class_4608.field_21444, ms, buffers);
	}

}
