/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import org.apache.commons.lang3.mutable.MutableFloat;

import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.lib.LibResources;
import vazkii.botania.common.core.handler.ModSounds;

public class ItemBalanceCloak extends ItemHolyCloak {

	private static final class_2960 texture = new class_2960(LibResources.MODEL_BALANCE_CLOAK);
	private static final class_2960 textureGlow = new class_2960(LibResources.MODEL_BALANCE_CLOAK_GLOW);

	public ItemBalanceCloak(class_1793 props) {
		super(props);
	}

	@Override
	public boolean effectOnDamage(class_1282 src, MutableFloat amount, class_1657 player, class_1799 stack) {
		if (!src.method_5527()) {
			amount.setValue(amount.getValue() / 2);

			if (src.method_5529() != null) {
				src.method_5529().method_5643(class_1282.method_5536(player, player), amount.getValue());
			}

			if (amount.getValue() > player.method_6032()) {
				amount.setValue(player.method_6032() - 1);
			}

			player.field_6002.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), ModSounds.holyCloak, class_3419.field_15248, 1F, 1F);
			for (int i = 0; i < 30; i++) {
				double x = player.method_23317() + Math.random() * player.method_17681() * 2 - player.method_17681();
				double y = player.method_23318() + Math.random() * player.method_17682();
				double z = player.method_23321() + Math.random() * player.method_17681() * 2 - player.method_17681();
				boolean green = Math.random() > 0.5;
				float g = green ? 1F : 0.3F;
				float b = green ? 0.3F : 1F;
				SparkleParticleData data = SparkleParticleData.sparkle(0.8F + (float) Math.random() * 0.4F, 0.3F, g, b, 3);
				player.field_6002.method_8406(data, x, y, z, 0, 0, 0);
			}
			return true;
		}

		return false;
	}

	@Override
	@Environment(EnvType.CLIENT)
	class_2960 getCloakTexture() {
		return texture;
	}

	@Override
	@Environment(EnvType.CLIENT)
	class_2960 getCloakGlowTexture() {
		return textureGlow;
	}

}
