/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.armor.terrasteel;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import vazkii.botania.api.item.IAncientWillContainer;
import vazkii.botania.api.mana.IManaDiscountArmor;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.mixin.AccessorDamageSource;

import javax.annotation.Nullable;

import java.util.List;
import java.util.Locale;

public class ItemTerrasteelHelm extends ItemTerrasteelArmor implements IManaDiscountArmor, IAncientWillContainer {

	public static final String TAG_ANCIENT_WILL = "AncientWill";

	public ItemTerrasteelHelm(class_1793 props) {
		super(class_1304.field_6169, props);
	}

	@Override
	public void onArmorTick(class_1799 stack, class_1937 world, class_1657 player) {
		super.onArmorTick(stack, world, player);
		if (!world.field_9236 && hasArmorSet(player)) {
			int food = player.method_7344().method_7586();
			if (food > 0 && food < 18 && player.method_7317() && player.field_6012 % 80 == 0) {
				player.method_6025(1F);
			}
			ManaItemHandler.instance().dispatchManaExact(stack, player, 1, true);
		}
	}

	@Override
	public float getDiscount(class_1799 stack, int slot, class_1657 player, @Nullable class_1799 tool) {
		return hasArmorSet(player) ? 0.2F : 0F;
	}

	@Override
	public void addAncientWill(class_1799 stack, AncientWillType will) {
		ItemNBTHelper.setBoolean(stack, TAG_ANCIENT_WILL + "_" + will.name().toLowerCase(Locale.ROOT), true);
	}

	@Override
	public boolean hasAncientWill(class_1799 stack, AncientWillType will) {
		return hasAncientWill_(stack, will);
	}

	private static boolean hasAncientWill_(class_1799 stack, AncientWillType will) {
		return ItemNBTHelper.getBoolean(stack, TAG_ANCIENT_WILL + "_" + will.name().toLowerCase(Locale.ROOT), false);
	}

	@Override
	@Environment(EnvType.CLIENT)
	public void addArmorSetDescription(class_1799 stack, List<class_2561> list) {
		super.addArmorSetDescription(stack, list);
		for (AncientWillType type : AncientWillType.values()) {
			if (hasAncientWill(stack, type)) {
				list.add(new class_2588("botania.armorset.will_" + type.name().toLowerCase(Locale.ROOT) + ".desc").method_27692(class_124.field_1080));
			}
		}
	}

	public static boolean hasAnyWill(class_1799 stack) {
		for (AncientWillType type : AncientWillType.values()) {
			if (hasAncientWill_(stack, type)) {
				return true;
			}
		}

		return false;
	}

	private float onEntityAttacked(class_1282 source, float amount, class_1657 player, class_1297 entity) {
		if (entity instanceof class_1309) {
			class_1309 living = (class_1309) entity;
			if (hasArmorSet(player)) {
				// TODO 1.16 Move to mixin, this does not actually work as it's triggered after the attack strength changes
				// [VanillaCopy] crit logic from PlayerEntity.attackTargetEntityWithCurrentItem
				boolean strong = player.method_7261(0.5F) > 0.9F;
				boolean crit = strong && player.field_6017 > 0.0F && !player.method_24828() && !player.method_6101() && !player.method_5799() && !player.method_6059(class_1294.field_5919) && !player.method_5765();
				crit = crit && !player.method_5624();

				class_1799 stack = player.method_6118(class_1304.field_6169);
				if (crit && !stack.method_7960() && stack.method_7909() instanceof ItemTerrasteelHelm) {
					if (hasAncientWill(stack, AncientWillType.AHRIM)) {
						living.method_6092(new class_1293(class_1294.field_5911, 20, 1));
					}
					if (hasAncientWill(stack, AncientWillType.GUTHAN)) {
						player.method_6025(amount * 0.25F);
					}
					if (hasAncientWill(stack, AncientWillType.TORAG)) {
						living.method_6092(new class_1293(class_1294.field_5909, 60, 1));
					}
					if (hasAncientWill(stack, AncientWillType.VERAC)) {
						((AccessorDamageSource) source).botania_setBypassArmor();
					}
					if (hasAncientWill(stack, AncientWillType.KARIL)) {
						living.method_6092(new class_1293(class_1294.field_5920, 60, 1));
					}
					if (hasAncientWill(stack, AncientWillType.DHAROK)) {
						return amount * (1F + (1F - player.method_6032() / player.method_6063()) * 0.5F);
					}
				}
			}
		}
		return amount;
	}

}
