/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.armor.terrasteel;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3528;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_572;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.lib.LibResources;
import vazkii.botania.client.model.armor.ModelArmorTerrasteel;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelArmor;

import javax.annotation.Nonnull;

import java.util.List;
import java.util.UUID;

public class ItemTerrasteelArmor extends ItemManasteelArmor {

	public ItemTerrasteelArmor(class_1304 type, class_1793 props) {
		super(type, BotaniaAPI.instance().getTerrasteelArmorMaterial(), props);
	}

	@Override
	@Environment(EnvType.CLIENT)
	protected class_572<class_1309> provideArmorModelForSlot(class_1304 slot) {
		return new ModelArmorTerrasteel(slot);
	}

	@Override
	public String getArmorTextureAfterInk(class_1799 stack, class_1304 slot) {
		return LibResources.MODEL_TERRASTEEL_NEW;
	}

	@Nonnull
	@Override
	public Multimap<class_1320, class_1322> method_7844(@Nonnull class_1304 slot) {
		Multimap<class_1320, class_1322> ret = super.method_7844(slot);
		UUID uuid = new UUID(class_2378.field_11142.method_10221(this).hashCode() + slot.toString().hashCode(), 0);
		if (slot == method_7685()) {
			ret = HashMultimap.create(ret);
			int reduction = method_7686().method_7697(slot);
			ret.put(class_5134.field_23718,
					new class_1322(uuid, "Terrasteel modifier " + type, (double) reduction / 20, class_1322.class_1323.field_6328));
		}
		return ret;
	}

	private static final class_3528<class_1799[]> armorSet = new class_3528<>(() -> new class_1799[] {
			new class_1799(ModItems.terrasteelHelm),
			new class_1799(ModItems.terrasteelChest),
			new class_1799(ModItems.terrasteelLegs),
			new class_1799(ModItems.terrasteelBoots)
	});

	@Override
	public class_1799[] getArmorSetStacks() {
		return armorSet.method_15332();
	}

	@Override
	public boolean hasArmorSetItem(class_1657 player, class_1304 slot) {
		if (player == null) {
			return false;
		}

		class_1799 stack = player.method_6118(slot);
		if (stack.method_7960()) {
			return false;
		}

		switch (slot) {
		case field_6169:
			return stack.method_7909() == ModItems.terrasteelHelm;
		case field_6174:
			return stack.method_7909() == ModItems.terrasteelChest;
		case field_6172:
			return stack.method_7909() == ModItems.terrasteelLegs;
		case field_6166:
			return stack.method_7909() == ModItems.terrasteelBoots;
		}

		return false;
	}

	@Override
	public class_5250 getArmorSetName() {
		return new class_2588("botania.armorset.terrasteel.name");
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void addArmorSetDescription(class_1799 stack, List<class_2561> list) {
		list.add(new class_2588("botania.armorset.terrasteel.desc0").method_27692(class_124.field_1080));
		list.add(new class_2588("botania.armorset.terrasteel.desc1").method_27692(class_124.field_1080));
		list.add(new class_2588("botania.armorset.terrasteel.desc2").method_27692(class_124.field_1080));
	}
}
