/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.armor.manaweave;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3528;
import net.minecraft.class_5250;
import net.minecraft.class_572;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.client.lib.LibResources;
import vazkii.botania.client.model.armor.ModelArmorManaweave;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelArmor;

import javax.annotation.Nonnull;

import java.util.List;

public class ItemManaweaveArmor extends ItemManasteelArmor {

	public ItemManaweaveArmor(class_1304 type, class_1793 props) {
		super(type, BotaniaAPI.instance().getManaweaveArmorMaterial(), props);
	}

	@Override
	@Environment(EnvType.CLIENT)
	protected class_572<class_1309> provideArmorModelForSlot(class_1304 slot) {
		return new ModelArmorManaweave(slot);
	}

	@Override
	public String getArmorTextureAfterInk(class_1799 stack, class_1304 slot) {
		return ClientProxy.jingleTheBells ? LibResources.MODEL_MANAWEAVE_NEW_HOLIDAY : LibResources.MODEL_MANAWEAVE_NEW;
	}

	@Nonnull
	@Override
	@Environment(EnvType.CLIENT)
	public String method_7866(class_1799 stack) {
		String name = super.method_7866(stack);
		if (ClientProxy.jingleTheBells) {
			name = name.replaceAll("manaweave", "santaweave");
		}
		return name;
	}

	private static final class_3528<class_1799[]> armorSet = new class_3528<>(() -> new class_1799[] {
			new class_1799(ModItems.manaweaveHelm),
			new class_1799(ModItems.manaweaveChest),
			new class_1799(ModItems.manaweaveLegs),
			new class_1799(ModItems.manaweaveBoots)
	});

	@Override
	public class_1799[] getArmorSetStacks() {
		return armorSet.method_15332();
	}

	@Override
	public boolean hasArmorSetItem(class_1657 player, class_1304 slot) {
		if (player == null) {
			return false;
		}

		class_1799 stack = player.method_6118(slot);
		if (stack.method_7960()) {
			return false;
		}

		switch (slot) {
		case field_6169:
			return stack.method_7909() == ModItems.manaweaveHelm;
		case field_6174:
			return stack.method_7909() == ModItems.manaweaveChest;
		case field_6172:
			return stack.method_7909() == ModItems.manaweaveLegs;
		case field_6166:
			return stack.method_7909() == ModItems.manaweaveBoots;
		}

		return false;
	}

	@Override
	public class_5250 getArmorSetName() {
		return new class_2588("botania.armorset.manaweave.name");
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void addInformationAfterShift(class_1799 stack, class_1937 world, List<class_2561> list, class_1836 flags) {
		if (ClientProxy.jingleTheBells) {
			list.add(new class_2588("botaniamisc.santaweaveInfo"));
			list.add(new class_2585(""));
		}

		super.addInformationAfterShift(stack, world, list, flags);
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void addArmorSetDescription(class_1799 stack, List<class_2561> list) {
		list.add(new class_2588("botania.armorset.manaweave.desc0").method_27692(class_124.field_1080));
		list.add(new class_2588("botania.armorset.manaweave.desc1").method_27692(class_124.field_1080));
	}
}
