/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.armor.manasteel;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3528;
import net.minecraft.class_5250;
import net.minecraft.class_572;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IPhantomInkable;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.TooltipHandler;
import vazkii.botania.client.lib.LibResources;
import vazkii.botania.client.model.armor.ModelArmorManasteel;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

import javax.annotation.Nonnull;

import java.util.List;
import java.util.function.Consumer;

public class ItemManasteelArmor extends class_1738 implements IManaUsingItem, IPhantomInkable {

	private static final int MANA_PER_DAMAGE = 70;

	private static final String TAG_PHANTOM_INK = "phantomInk";

	@Environment(EnvType.CLIENT)
	private class_572<class_1309> model;
	public final class_1304 type;

	public ItemManasteelArmor(class_1304 type, class_1793 props) {
		this(type, BotaniaAPI.instance().getManasteelArmorMaterial(), props);
	}

	public ItemManasteelArmor(class_1304 type, class_1741 mat, class_1793 props) {
		super(mat, type, props);
		this.type = type;
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 player, int slot, boolean selected) {
		if (player instanceof class_1657) {
			onArmorTick(stack, world, (class_1657) player);
		}
	}

	public void onArmorTick(class_1799 stack, class_1937 world, class_1657 player) {
		if (!world.field_9236 && stack.method_7919() > 0 && ManaItemHandler.instance().requestManaExact(stack, player, MANA_PER_DAMAGE * 2, true)) {
			stack.method_7974(stack.method_7919() - 1);
		}
	}

	public static <T extends class_1309> int damageItem(class_1799 stack, int amount, T entity, Consumer<T> onBroken) {
		return ToolCommons.damageItemIfPossible(stack, amount, entity, MANA_PER_DAMAGE);
	}

	@Nonnull
	public final String getArmorTexture(class_1799 stack, class_1304 slot) {
		return hasPhantomInk(stack) ? LibResources.MODEL_INVISIBLE_ARMOR : getArmorTextureAfterInk(stack, slot);
	}

	public String getArmorTextureAfterInk(class_1799 stack, class_1304 slot) {
		return LibResources.MODEL_MANASTEEL_NEW;
	}

	@Environment(EnvType.CLIENT)
	public class_572<class_1309> getArmorModel(class_1309 entityLiving, class_1799 itemStack, class_1304 armorSlot, class_572<class_1309> original) {
		if (model == null) {
			model = provideArmorModelForSlot(field_7880);
		}
		return model;
	}

	@Environment(EnvType.CLIENT)
	protected class_572<class_1309> provideArmorModelForSlot(class_1304 slot) {
		return new ModelArmorManasteel(slot);
	}

	@Override
	public boolean usesMana(class_1799 stack) {
		return true;
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> list, class_1836 flags) {
		TooltipHandler.addOnShift(list, () -> addInformationAfterShift(stack, world, list, flags));
	}

	@Environment(EnvType.CLIENT)
	public void addInformationAfterShift(class_1799 stack, class_1937 world, List<class_2561> list, class_1836 flags) {
		class_1657 player = class_310.method_1551().field_1724;
		list.add(getArmorSetTitle(player));
		addArmorSetDescription(stack, list);
		class_1799[] stacks = getArmorSetStacks();
		for (class_1799 armor : stacks) {
			class_5250 cmp = new class_2585(" - ").method_10852(armor.method_7964());
			class_1304 slot = ((class_1738) armor.method_7909()).method_7685();
			cmp.method_27692(hasArmorSetItem(player, slot) ? class_124.field_1060 : class_124.field_1080);
			list.add(cmp);
		}
		if (hasPhantomInk(stack)) {
			list.add(new class_2588("botaniamisc.hasPhantomInk").method_27692(class_124.field_1080));
		}
	}

	private static final class_3528<class_1799[]> armorSet = new class_3528<>(() -> new class_1799[] {
			new class_1799(ModItems.manasteelHelm),
			new class_1799(ModItems.manasteelChest),
			new class_1799(ModItems.manasteelLegs),
			new class_1799(ModItems.manasteelBoots)
	});

	public class_1799[] getArmorSetStacks() {
		return armorSet.method_15332();
	}

	public boolean hasArmorSet(class_1657 player) {
		return hasArmorSetItem(player, class_1304.field_6169) && hasArmorSetItem(player, class_1304.field_6174) && hasArmorSetItem(player, class_1304.field_6172) && hasArmorSetItem(player, class_1304.field_6166);
	}

	public boolean hasArmorSetItem(class_1657 player, class_1304 slot) {
		if (player == null || player.field_7514 == null || player.field_7514.field_7548 == null) {
			return false;
		}

		class_1799 stack = player.method_6118(slot);
		if (stack.method_7960()) {
			return false;
		}

		switch (slot) {
		case field_6169:
			return stack.method_7909() == ModItems.manasteelHelm;
		case field_6174:
			return stack.method_7909() == ModItems.manasteelChest;
		case field_6172:
			return stack.method_7909() == ModItems.manasteelLegs;
		case field_6166:
			return stack.method_7909() == ModItems.manasteelBoots;
		}

		return false;
	}

	private int getSetPiecesEquipped(class_1657 player) {
		int pieces = 0;
		for (class_1304 slot : class_1304.values()) {
			if (slot.method_5925() == class_1304.class_1305.field_6178 && hasArmorSetItem(player, slot)) {
				pieces++;
			}
		}

		return pieces;
	}

	public class_5250 getArmorSetName() {
		return new class_2588("botania.armorset.manasteel.name");
	}

	private class_2561 getArmorSetTitle(class_1657 player) {
		class_2561 end = getArmorSetName()
				.method_27693(" (" + getSetPiecesEquipped(player) + "/" + getArmorSetStacks().length + ")")
				.method_27692(class_124.field_1080);
		return new class_2588("botaniamisc.armorset")
				.method_27693(" ")
				.method_10852(end);
	}

	@Environment(EnvType.CLIENT)
	public void addArmorSetDescription(class_1799 stack, List<class_2561> list) {
		list.add(new class_2588("botania.armorset.manasteel.desc").method_27692(class_124.field_1080));
	}

	@Override
	public boolean hasPhantomInk(class_1799 stack) {
		return ItemNBTHelper.getBoolean(stack, TAG_PHANTOM_INK, false);
	}

	@Override
	public void setPhantomInk(class_1799 stack, boolean ink) {
		ItemNBTHelper.setBoolean(stack, TAG_PHANTOM_INK, ink);
	}
}
