/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.armor.elementium;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3528;
import net.minecraft.class_5250;
import net.minecraft.class_572;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.lib.LibResources;
import vazkii.botania.client.model.armor.ModelArmorElementium;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelArmor;

import java.util.List;

public abstract class ItemElementiumArmor extends ItemManasteelArmor {

	public ItemElementiumArmor(class_1304 type, class_1793 props) {
		super(type, BotaniaAPI.instance().getElementiumArmorMaterial(), props);
	}

	@Override
	@Environment(EnvType.CLIENT)
	protected class_572<class_1309> provideArmorModelForSlot(class_1304 slot) {
		return new ModelArmorElementium(slot);
	}

	@Override
	public String getArmorTextureAfterInk(class_1799 stack, class_1304 slot) {
		return LibResources.MODEL_ELEMENTIUM_NEW;
	}

	private static final class_3528<class_1799[]> armorSet = new class_3528<>(() -> new class_1799[] {
			new class_1799(ModItems.elementiumHelm),
			new class_1799(ModItems.elementiumChest),
			new class_1799(ModItems.elementiumLegs),
			new class_1799(ModItems.elementiumBoots)
	});

	@Override
	public class_1799[] getArmorSetStacks() {
		return armorSet.method_15332();
	}

	@Override
	public boolean hasArmorSetItem(class_1657 player, class_1304 slot) {
		if (player == null) {
			return false;
		}

		class_1799 stack = player.method_6118(slot);
		if (stack.method_7960()) {
			return false;
		}

		switch (slot) {
		case field_6169:
			return stack.method_7909() == ModItems.elementiumHelm;
		case field_6174:
			return stack.method_7909() == ModItems.elementiumChest;
		case field_6172:
			return stack.method_7909() == ModItems.elementiumLegs;
		case field_6166:
			return stack.method_7909() == ModItems.elementiumBoots;
		}

		return false;
	}

	@Override
	public class_5250 getArmorSetName() {
		return new class_2588("botania.armorset.elementium.name");
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void addArmorSetDescription(class_1799 stack, List<class_2561> list) {
		super.addArmorSetDescription(stack, list);
		list.add(new class_2588("botania.armorset.elementium.desc").method_27692(class_124.field_1080));
	}

}
