/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.brew;

import net.minecraft.class_1792;
import net.minecraft.class_1799;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.IBrewContainer;
import vazkii.botania.common.item.ModItems;

public class ItemVial extends class_1792 implements IBrewContainer {

	public ItemVial(class_1793 builder) {
		super(builder);
	}

	@Override
	public class_1799 getItemForBrew(Brew brew, class_1799 stack) {
		class_1799 brewStack = new class_1799(this == ModItems.flask ? ModItems.brewFlask : ModItems.brewVial);
		ItemBrewBase.setBrew(brewStack, brew);
		return brewStack;
	}

	@Override
	public int getManaCost(Brew brew, class_1799 stack) {
		if (this == ModItems.flask) {
			return brew.getManaCost() * 2;
		} else {
			return brew.getManaCost();
		}
	}
}
