/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.block;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3494;
import net.minecraft.class_5250;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.lib.ModTags;

import javax.annotation.Nonnull;

import java.util.List;

public class ItemBlockSpecialFlower extends class_1747 {
	private static final class_3494.class_5123<class_1792> GENERATING = ModTags.Items.GENERATING_SPECIAL_FLOWERS;
	private static final class_3494.class_5123<class_1792> FUNCTIONAL = ModTags.Items.FUNCTIONAL_SPECIAL_FLOWERS;
	private static final class_3494.class_5123<class_1792> MISC = ModTags.Items.MISC_SPECIAL_FLOWERS;

	public ItemBlockSpecialFlower(class_2248 block1, class_1793 props) {
		super(block1, props);
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void method_7851(@Nonnull class_1799 stack, class_1937 world, @Nonnull List<class_2561> tooltip, @Nonnull class_1836 flag) {
		// Prevent crash when tooltips queried before configs load
		if (Botania.configLoaded) {
			if (world != null) {
				if (GENERATING.method_15141(this)) {
					tooltip.add(new class_2588("botania.flowerType.generating").method_27695(class_124.field_1056, class_124.field_1078));
				} else if (FUNCTIONAL.method_15141(this)) {
					tooltip.add(new class_2588("botania.flowerType.functional").method_27695(class_124.field_1056, class_124.field_1078));
				} else if (MISC.method_15141(this)) {
					tooltip.add(new class_2588("botania.flowerType.misc").method_27695(class_124.field_1056, class_124.field_1078));
				}
			}

			if (ConfigHandler.CLIENT.referencesEnabled.getValue()) {
				String key = method_7876() + ".reference";
				class_5250 lore = new class_2588(key);
				if (!lore.getString().equals(key)) {
					tooltip.add(lore.method_27695(class_124.field_1056, class_124.field_1080));
				}
			}
		}
	}

	/* todo 1.16-fabric
	@Override
	public boolean showDurabilityBar(ItemStack stack) {
		CompoundTag tag = stack.getSubTag("BlockEntityTag");
		return tag != null && tag.contains(TileEntityGeneratingFlower.TAG_PASSIVE_DECAY_TICKS);
	}
	
	@Override
	public double getDurabilityForDisplay(ItemStack stack) {
		CompoundTag tag = stack.getSubTag("BlockEntityTag");
		if (tag != null) {
			return tag.getInt(TileEntityGeneratingFlower.TAG_PASSIVE_DECAY_TICKS) / (double) BotaniaAPI.instance().getPassiveFlowerDecay();
		}
		return 0;
	}
	*/
}
