/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.screenhandler.v1.ScreenRegistry;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.screenhandler.v1.ScreenHandlerRegistry;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_1865;
import net.minecraft.class_2378;
import net.minecraft.class_3917;
import net.minecraft.class_4174;
import net.minecraft.item.*;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IAncientWillContainer;
import vazkii.botania.api.item.IFloatingFlower;
import vazkii.botania.api.mana.spark.SparkUpgradeType;
import vazkii.botania.api.state.enums.CratePattern;
import vazkii.botania.client.gui.bag.ContainerFlowerBag;
import vazkii.botania.client.gui.bag.GuiFlowerBag;
import vazkii.botania.client.gui.box.ContainerBaubleBox;
import vazkii.botania.client.gui.box.GuiBaubleBox;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.BotaniaCreativeTab;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.crafting.recipe.*;
import vazkii.botania.common.item.brew.ItemBrewBase;
import vazkii.botania.common.item.brew.ItemIncenseStick;
import vazkii.botania.common.item.brew.ItemVial;
import vazkii.botania.common.item.equipment.armor.elementium.ItemElementiumBoots;
import vazkii.botania.common.item.equipment.armor.elementium.ItemElementiumChest;
import vazkii.botania.common.item.equipment.armor.elementium.ItemElementiumHelm;
import vazkii.botania.common.item.equipment.armor.elementium.ItemElementiumLegs;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelArmor;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelHelm;
import vazkii.botania.common.item.equipment.armor.manaweave.ItemManaweaveArmor;
import vazkii.botania.common.item.equipment.armor.manaweave.ItemManaweaveHelm;
import vazkii.botania.common.item.equipment.armor.terrasteel.ItemTerrasteelArmor;
import vazkii.botania.common.item.equipment.armor.terrasteel.ItemTerrasteelHelm;
import vazkii.botania.common.item.equipment.bauble.*;
import vazkii.botania.common.item.equipment.tool.ItemEnderDagger;
import vazkii.botania.common.item.equipment.tool.ItemGlassPick;
import vazkii.botania.common.item.equipment.tool.ItemStarSword;
import vazkii.botania.common.item.equipment.tool.ItemThunderSword;
import vazkii.botania.common.item.equipment.tool.bow.ItemCrystalBow;
import vazkii.botania.common.item.equipment.tool.bow.ItemLivingwoodBow;
import vazkii.botania.common.item.equipment.tool.elementium.*;
import vazkii.botania.common.item.equipment.tool.manasteel.*;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraAxe;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraSword;
import vazkii.botania.common.item.lens.*;
import vazkii.botania.common.item.material.*;
import vazkii.botania.common.item.record.ItemModRecord;
import vazkii.botania.common.item.relic.*;
import vazkii.botania.common.item.rod.*;
import vazkii.botania.common.lib.LibItemNames;

import java.util.Locale;

import static vazkii.botania.common.block.ModBlocks.register;
import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public final class ModItems {
	public static final ItemLexicon lexicon = new ItemLexicon(unstackable().method_7894(class_1814.field_8907));
	public static final class_1792 twigWand = new ItemTwigWand(unstackable().method_7894(class_1814.field_8903));
	public static final class_1792 obedienceStick = new ItemObedienceStick(unstackable());
	public static final class_1792 pestleAndMortar = new ItemSelfReturning(unstackable());
	public static final class_1792 fertilizer = new ItemFertilizer(defaultBuilder());

	public static final class_1792 whitePetal = new ItemPetal(ModBlocks.getBuriedPetal(class_1767.field_7952), class_1767.field_7952, defaultBuilder());
	public static final class_1792 orangePetal = new ItemPetal(ModBlocks.getBuriedPetal(class_1767.field_7946), class_1767.field_7946, defaultBuilder());
	public static final class_1792 magentaPetal = new ItemPetal(ModBlocks.getBuriedPetal(class_1767.field_7958), class_1767.field_7958, defaultBuilder());
	public static final class_1792 lightBluePetal = new ItemPetal(ModBlocks.getBuriedPetal(class_1767.field_7951), class_1767.field_7951, defaultBuilder());
	public static final class_1792 yellowPetal = new ItemPetal(ModBlocks.getBuriedPetal(class_1767.field_7947), class_1767.field_7947, defaultBuilder());
	public static final class_1792 limePetal = new ItemPetal(ModBlocks.getBuriedPetal(class_1767.field_7961), class_1767.field_7961, defaultBuilder());
	public static final class_1792 pinkPetal = new ItemPetal(ModBlocks.getBuriedPetal(class_1767.field_7954), class_1767.field_7954, defaultBuilder());
	public static final class_1792 grayPetal = new ItemPetal(ModBlocks.getBuriedPetal(class_1767.field_7944), class_1767.field_7944, defaultBuilder());
	public static final class_1792 lightGrayPetal = new ItemPetal(ModBlocks.getBuriedPetal(class_1767.field_7967), class_1767.field_7967, defaultBuilder());
	public static final class_1792 cyanPetal = new ItemPetal(ModBlocks.getBuriedPetal(class_1767.field_7955), class_1767.field_7955, defaultBuilder());
	public static final class_1792 purplePetal = new ItemPetal(ModBlocks.getBuriedPetal(class_1767.field_7945), class_1767.field_7945, defaultBuilder());
	public static final class_1792 bluePetal = new ItemPetal(ModBlocks.getBuriedPetal(class_1767.field_7966), class_1767.field_7966, defaultBuilder());
	public static final class_1792 brownPetal = new ItemPetal(ModBlocks.getBuriedPetal(class_1767.field_7957), class_1767.field_7957, defaultBuilder());
	public static final class_1792 greenPetal = new ItemPetal(ModBlocks.getBuriedPetal(class_1767.field_7942), class_1767.field_7942, defaultBuilder());
	public static final class_1792 redPetal = new ItemPetal(ModBlocks.getBuriedPetal(class_1767.field_7964), class_1767.field_7964, defaultBuilder());
	public static final class_1792 blackPetal = new ItemPetal(ModBlocks.getBuriedPetal(class_1767.field_7963), class_1767.field_7963, defaultBuilder());

	public static final class_1792 manaSteel = new class_1792(defaultBuilder());
	public static final class_1792 manaPearl = new class_1792(defaultBuilder());
	public static final class_1792 manaDiamond = new class_1792(defaultBuilder());
	public static final class_1792 livingwoodTwig = new class_1792(defaultBuilder());
	public static final class_1792 terrasteel = new ItemManaResource(defaultBuilder().method_7894(class_1814.field_8907));
	public static final class_1792 lifeEssence = new class_1792(defaultBuilder().method_7894(class_1814.field_8907));
	public static final class_1792 redstoneRoot = new class_1792(defaultBuilder());
	public static final class_1792 elementium = new ItemElven(defaultBuilder());
	public static final class_1792 pixieDust = new ItemElven(defaultBuilder());
	public static final class_1792 dragonstone = new ItemElven(defaultBuilder());
	public static final class_1792 redString = new class_1792(defaultBuilder());
	public static final class_1792 dreamwoodTwig = new class_1792(defaultBuilder());
	public static final class_1792 gaiaIngot = new ItemManaResource(defaultBuilder().method_7894(class_1814.field_8903));
	public static final class_1792 enderAirBottle = new ItemEnderAir(defaultBuilder());
	public static final class_1792 manaString = new class_1792(defaultBuilder());
	public static final class_1792 manasteelNugget = new class_1792(defaultBuilder());
	public static final class_1792 terrasteelNugget = new class_1792(defaultBuilder().method_7894(class_1814.field_8907));
	public static final class_1792 elementiumNugget = new class_1792(defaultBuilder());
	public static final class_1792 livingroot = new ItemManaResource(defaultBuilder());
	public static final class_1792 pebble = new class_1792(defaultBuilder());
	public static final class_1792 manaweaveCloth = new class_1792(defaultBuilder());
	public static final class_1792 manaPowder = new class_1792(defaultBuilder());

	public static final class_1792 darkQuartz = new class_1792(defaultBuilder());
	public static final class_1792 manaQuartz = new class_1792(defaultBuilder());
	public static final class_1792 blazeQuartz = new class_1792(defaultBuilder());
	public static final class_1792 lavenderQuartz = new class_1792(defaultBuilder());
	public static final class_1792 redQuartz = new class_1792(defaultBuilder());
	public static final class_1792 elfQuartz = new class_1792(defaultBuilder());
	public static final class_1792 sunnyQuartz = new class_1792(defaultBuilder());

	public static final class_1792 lensNormal = new ItemLens(unstackable(), new Lens(), ItemLens.PROP_NONE);
	public static final class_1792 lensSpeed = new ItemLens(unstackable(), new LensSpeed(), ItemLens.PROP_NONE);
	public static final class_1792 lensPower = new ItemLens(unstackable(), new LensPower(), ItemLens.PROP_POWER);
	public static final class_1792 lensTime = new ItemLens(unstackable(), new LensTime(), ItemLens.PROP_NONE);
	public static final class_1792 lensEfficiency = new ItemLens(unstackable(), new LensEfficiency(), ItemLens.PROP_NONE);
	public static final class_1792 lensBounce = new ItemLens(unstackable(), new LensBounce(), ItemLens.PROP_TOUCH);
	public static final class_1792 lensGravity = new ItemLens(unstackable(), new LensGravity(), ItemLens.PROP_ORIENTATION);
	public static final class_1792 lensMine = new ItemLens(unstackable(), new LensMine(), ItemLens.PROP_TOUCH | ItemLens.PROP_INTERACTION);
	public static final class_1792 lensDamage = new ItemLens(unstackable(), new LensDamage(), ItemLens.PROP_DAMAGE);
	public static final class_1792 lensPhantom = new ItemLens(unstackable(), new LensPhantom(), ItemLens.PROP_TOUCH);
	public static final class_1792 lensMagnet = new ItemLens(unstackable(), new LensMagnet(), ItemLens.PROP_ORIENTATION);
	public static final class_1792 lensExplosive = new ItemLens(unstackable(), new LensExplosive(), ItemLens.PROP_DAMAGE | ItemLens.PROP_TOUCH | ItemLens.PROP_INTERACTION);
	public static final class_1792 lensInfluence = new ItemLens(unstackable(), new LensInfluence(), ItemLens.PROP_NONE);
	public static final class_1792 lensWeight = new ItemLens(unstackable(), new LensWeight(), ItemLens.PROP_TOUCH | ItemLens.PROP_INTERACTION);
	public static final class_1792 lensPaint = new ItemLens(unstackable(), new LensPaint(), ItemLens.PROP_TOUCH | ItemLens.PROP_INTERACTION);
	public static final class_1792 lensFire = new ItemLens(unstackable(), new LensFire(), ItemLens.PROP_DAMAGE | ItemLens.PROP_TOUCH | ItemLens.PROP_INTERACTION);
	public static final class_1792 lensPiston = new ItemLens(unstackable(), new LensPiston(), ItemLens.PROP_TOUCH | ItemLens.PROP_INTERACTION);
	public static final class_1792 lensLight = new ItemLens(unstackable(), new LensLight(), ItemLens.PROP_TOUCH | ItemLens.PROP_INTERACTION);
	public static final class_1792 lensWarp = new ItemLens(unstackable(), new LensWarp(), ItemLens.PROP_NONE);
	public static final class_1792 lensRedirect = new ItemLens(unstackable(), new LensRedirect(), ItemLens.PROP_TOUCH | ItemLens.PROP_INTERACTION);
	public static final class_1792 lensFirework = new ItemLens(unstackable(), new LensFirework(), ItemLens.PROP_TOUCH);
	public static final class_1792 lensFlare = new ItemLens(unstackable(), new LensFlare(), ItemLens.PROP_CONTROL);
	public static final class_1792 lensMessenger = new ItemLens(unstackable(), new LensMessenger(), ItemLens.PROP_POWER);
	public static final class_1792 lensTripwire = new ItemLens(unstackable(), new LensTripwire(), ItemLens.PROP_CONTROL);
	public static final class_1792 lensStorm = new ItemLens(unstackable().method_7894(class_1814.field_8904), new LensStorm(), ItemLens.PROP_NONE);

	public static final class_1792 runeWater = new ItemRune(defaultBuilder());
	public static final class_1792 runeFire = new ItemRune(defaultBuilder());
	public static final class_1792 runeEarth = new ItemRune(defaultBuilder());
	public static final class_1792 runeAir = new ItemRune(defaultBuilder());
	public static final class_1792 runeSpring = new ItemRune(defaultBuilder());
	public static final class_1792 runeSummer = new ItemRune(defaultBuilder());
	public static final class_1792 runeAutumn = new ItemRune(defaultBuilder());
	public static final class_1792 runeWinter = new ItemRune(defaultBuilder());
	public static final class_1792 runeMana = new ItemRune(defaultBuilder());
	public static final class_1792 runeLust = new ItemRune(defaultBuilder());
	public static final class_1792 runeGluttony = new ItemRune(defaultBuilder());
	public static final class_1792 runeGreed = new ItemRune(defaultBuilder());
	public static final class_1792 runeSloth = new ItemRune(defaultBuilder());
	public static final class_1792 runeWrath = new ItemRune(defaultBuilder());
	public static final class_1792 runeEnvy = new ItemRune(defaultBuilder());
	public static final class_1792 runePride = new ItemRune(defaultBuilder());

	public static final class_1792 grassSeeds = new ItemGrassSeeds(IFloatingFlower.IslandType.GRASS, defaultBuilder());
	public static final class_1792 podzolSeeds = new ItemGrassSeeds(IFloatingFlower.IslandType.PODZOL, defaultBuilder());
	public static final class_1792 mycelSeeds = new ItemGrassSeeds(IFloatingFlower.IslandType.MYCEL, defaultBuilder());
	public static final class_1792 drySeeds = new ItemGrassSeeds(IFloatingFlower.IslandType.DRY, defaultBuilder());
	public static final class_1792 goldenSeeds = new ItemGrassSeeds(IFloatingFlower.IslandType.GOLDEN, defaultBuilder());
	public static final class_1792 vividSeeds = new ItemGrassSeeds(IFloatingFlower.IslandType.VIVID, defaultBuilder());
	public static final class_1792 scorchedSeeds = new ItemGrassSeeds(IFloatingFlower.IslandType.SCORCHED, defaultBuilder());
	public static final class_1792 infusedSeeds = new ItemGrassSeeds(IFloatingFlower.IslandType.INFUSED, defaultBuilder());
	public static final class_1792 mutatedSeeds = new ItemGrassSeeds(IFloatingFlower.IslandType.MUTATED, defaultBuilder());

	public static final class_1792 dirtRod = new ItemDirtRod(unstackable());
	public static final class_1792 skyDirtRod = new ItemSkyDirtRod(unstackable());
	public static final class_1792 terraformRod = new ItemTerraformRod(unstackable().method_7894(class_1814.field_8907));
	public static final class_1792 cobbleRod = new ItemCobbleRod(unstackable());
	public static final class_1792 waterRod = new ItemWaterRod(unstackable());
	public static final class_1792 tornadoRod = new ItemTornadoRod(unstackable());
	public static final class_1792 fireRod = new ItemFireRod(unstackable());
	public static final class_1792 diviningRod = new ItemDiviningRod(unstackable());
	public static final class_1792 smeltRod = new ItemSmeltRod(unstackable());
	public static final class_1792 exchangeRod = new ItemExchangeRod(unstackable());
	public static final class_1792 rainbowRod = new ItemRainbowRod(unstackable());
	public static final class_1792 gravityRod = new ItemGravityRod(unstackable());
	public static final class_1792 missileRod = new ItemMissileRod(unstackable().method_7894(class_1814.field_8907));

	// Equipment
	public static final class_1792 manasteelHelm = new ItemManasteelHelm(unstackable().customDamage(ItemManasteelArmor::damageItem));
	public static final class_1792 manasteelChest = new ItemManasteelArmor(class_1304.field_6174, unstackable().customDamage(ItemManasteelArmor::damageItem));
	public static final class_1792 manasteelLegs = new ItemManasteelArmor(class_1304.field_6172, unstackable().customDamage(ItemManasteelArmor::damageItem));
	public static final class_1792 manasteelBoots = new ItemManasteelArmor(class_1304.field_6166, unstackable().customDamage(ItemManasteelArmor::damageItem));
	public static final class_1792 manasteelPick = new ItemManasteelPick(unstackable().customDamage(ItemManasteelPick::damageItem));
	public static final class_1792 manasteelShovel = new ItemManasteelShovel(unstackable().customDamage(ItemManasteelShovel::damageItem));
	public static final class_1792 manasteelAxe = new ItemManasteelAxe(unstackable().customDamage(ItemManasteelAxe::damageItem));
	public static final class_1792 manasteelSword = new ItemManasteelSword(unstackable().customDamage(ItemManasteelSword::damageItem));
	public static final class_1792 manasteelShears = new ItemManasteelShears(unstackable().customDamage(ItemManasteelShears::damageItem));
	public static final class_1792 elementiumHelm = new ItemElementiumHelm(unstackable().customDamage(ItemManasteelArmor::damageItem));
	public static final class_1792 elementiumChest = new ItemElementiumChest(unstackable().customDamage(ItemManasteelArmor::damageItem));
	public static final class_1792 elementiumLegs = new ItemElementiumLegs(unstackable().customDamage(ItemManasteelArmor::damageItem));
	public static final class_1792 elementiumBoots = new ItemElementiumBoots(unstackable().customDamage(ItemManasteelArmor::damageItem));
	public static final class_1792 elementiumPick = new ItemElementiumPick(unstackable().customDamage(ItemManasteelPick::damageItem));
	public static final class_1792 elementiumShovel = new ItemElementiumShovel(unstackable().customDamage(ItemManasteelShovel::damageItem));
	public static final class_1792 elementiumAxe = new ItemElementiumAxe(unstackable().customDamage(ItemManasteelAxe::damageItem));
	public static final class_1792 elementiumSword = new ItemElementiumSword(unstackable().customDamage(ItemManasteelSword::damageItem));
	public static final class_1792 elementiumShears = new ItemElementiumShears(unstackable().customDamage(ItemManasteelShears::damageItem));
	public static final class_1792 terrasteelHelm = new ItemTerrasteelHelm(unstackable().method_24359().method_7894(class_1814.field_8907).customDamage(ItemManasteelArmor::damageItem));
	public static final class_1792 terrasteelChest = new ItemTerrasteelArmor(class_1304.field_6174, unstackable().method_24359().method_7894(class_1814.field_8907).customDamage(ItemManasteelArmor::damageItem));
	public static final class_1792 terrasteelLegs = new ItemTerrasteelArmor(class_1304.field_6172, unstackable().method_24359().method_7894(class_1814.field_8907).customDamage(ItemManasteelArmor::damageItem));
	public static final class_1792 terrasteelBoots = new ItemTerrasteelArmor(class_1304.field_6166, unstackable().method_24359().method_7894(class_1814.field_8907).customDamage(ItemManasteelArmor::damageItem));
	public static final class_1792 terraPick = new ItemTerraPick(unstackable().method_24359().method_7894(class_1814.field_8907).customDamage(ItemManasteelPick::damageItem));
	public static final class_1792 terraAxe = new ItemTerraAxe(unstackable().method_24359().method_7894(class_1814.field_8907).customDamage(ItemManasteelAxe::damageItem));
	public static final class_1792 terraSword = new ItemTerraSword(unstackable().method_24359().method_7894(class_1814.field_8907).customDamage(ItemManasteelSword::damageItem));
	public static final class_1792 starSword = new ItemStarSword(unstackable().method_7894(class_1814.field_8907).customDamage(ItemManasteelSword::damageItem));
	public static final class_1792 thunderSword = new ItemThunderSword(unstackable().method_7894(class_1814.field_8907).customDamage(ItemManasteelSword::damageItem));
	public static final class_1792 manaweaveHelm = new ItemManaweaveHelm(unstackable().customDamage(ItemManaweaveHelm::damageItem));
	public static final class_1792 manaweaveChest = new ItemManaweaveArmor(class_1304.field_6174, unstackable().customDamage(ItemManasteelArmor::damageItem));
	public static final class_1792 manaweaveLegs = new ItemManaweaveArmor(class_1304.field_6172, unstackable().customDamage(ItemManasteelArmor::damageItem));
	public static final class_1792 manaweaveBoots = new ItemManaweaveArmor(class_1304.field_6166, unstackable().customDamage(ItemManasteelArmor::damageItem));
	public static final class_1792 enderDagger = new ItemEnderDagger(unstackable().method_7898(69) /* todo 1.16-fabric .setNoRepair()*/); // What you looking at?
	public static final class_1792 glassPick = new ItemGlassPick(unstackable().customDamage(ItemManasteelPick::damageItem));
	public static final class_1792 livingwoodBow = new ItemLivingwoodBow(defaultBuilder().method_7898(500).customDamage(ItemLivingwoodBow::damageItem));
	public static final class_1792 crystalBow = new ItemCrystalBow(defaultBuilder().method_7898(500).customDamage(ItemCrystalBow::damageItem));
	public static final class_1792 thornChakram = new ItemThornChakram(defaultBuilder().method_7889(6));
	public static final class_1792 flareChakram = new ItemThornChakram(defaultBuilder().method_7889(6));

	// Misc tools
	public static final class_1792 manaTablet = new ItemManaTablet(unstackable());
	public static final class_1792 manaMirror = new ItemManaMirror(unstackable());
	public static final class_1792 manaGun = new ItemManaGun(unstackable());
	public static final class_1792 clip = new class_1792(unstackable());
	public static final class_1792 grassHorn = new ItemHorn(unstackable());
	public static final class_1792 leavesHorn = new ItemHorn(unstackable());
	public static final class_1792 snowHorn = new ItemHorn(unstackable());
	public static final class_1792 vineBall = new ItemVineBall(defaultBuilder());
	public static final class_1792 slingshot = new ItemSlingshot(unstackable());
	public static final class_1792 openBucket = new ItemOpenBucket(unstackable());
	public static final class_1792 spawnerMover = new ItemSpawnerMover(unstackable().method_7894(class_1814.field_8907));
	public static final class_1792 enderHand = new ItemEnderHand(unstackable());
	public static final class_1792 craftingHalo = new ItemCraftingHalo(unstackable());
	public static final class_1792 autocraftingHalo = new ItemAutocraftingHalo(unstackable());
	public static final class_1792 spellCloth = new ItemSpellCloth(unstackable().method_7898(35)/* todo 1.16-fabric.setNoRepair()*/);
	public static final class_1792 flowerBag = new ItemFlowerBag(unstackable());
	public static final class_1792 blackHoleTalisman = new ItemBlackHoleTalisman(unstackable());
	public static final class_1792 temperanceStone = new ItemTemperanceStone(unstackable());
	public static final class_1792 waterBowl = new ItemWaterBowl(unstackable());
	public static final class_1792 cacophonium = new ItemCacophonium(unstackable());
	public static final class_1792 slimeBottle = new ItemSlimeBottle(unstackable());
	public static final class_1792 sextant = new ItemSextant(unstackable());
	public static final class_1792 astrolabe = new ItemAstrolabe(unstackable().method_7894(class_1814.field_8907));
	public static final class_1792 baubleBox = new ItemBaubleBox(unstackable());

	// Baubles / trinkets / curios / etc.
	public static final class_1792 manaRing = new ItemManaRing(unstackable());
	public static final class_1792 manaRingGreater = new ItemGreaterManaRing(unstackable());
	public static final class_1792 auraRing = new ItemAuraRing(unstackable(), 10);
	public static final class_1792 auraRingGreater = new ItemAuraRing(unstackable(), 2);
	public static final class_1792 magnetRing = new ItemMagnetRing(unstackable());
	public static final class_1792 magnetRingGreater = new ItemMagnetRing(unstackable(), 16);
	public static final class_1792 waterRing = new ItemWaterRing(unstackable().method_7894(class_1814.field_8903));
	public static final class_1792 swapRing = new ItemSwapRing(unstackable());
	public static final class_1792 dodgeRing = new ItemDodgeRing(unstackable());
	public static final class_1792 miningRing = new ItemMiningRing(unstackable());
	public static final class_1792 pixieRing = new ItemPixieRing(unstackable());
	public static final class_1792 reachRing = new ItemReachRing(unstackable());
	public static final class_1792 travelBelt = new ItemTravelBelt(unstackable());
	public static final class_1792 superTravelBelt = new ItemSuperTravelBelt(unstackable());
	public static final class_1792 speedUpBelt = new ItemSpeedUpBelt(unstackable());
	public static final class_1792 knockbackBelt = new ItemKnockbackBelt(unstackable());
	public static final class_1792 icePendant = new ItemIcePendant(unstackable());
	public static final class_1792 lavaPendant = new ItemLavaPendant(unstackable());
	public static final class_1792 superLavaPendant = new ItemSuperLavaPendant(unstackable());
	public static final class_1792 cloudPendant = new ItemCloudPendant(unstackable());
	public static final class_1792 superCloudPendant = new ItemSuperCloudPendant(unstackable());
	public static final class_1792 holyCloak = new ItemHolyCloak(unstackable());
	public static final class_1792 unholyCloak = new ItemUnholyCloak(unstackable());
	public static final class_1792 balanceCloak = new ItemBalanceCloak(unstackable());
	public static final class_1792 invisibilityCloak = new ItemInvisibilityCloak(unstackable());
	public static final class_1792 thirdEye = new ItemThirdEye(unstackable());
	public static final class_1792 monocle = new ItemMonocle(unstackable());
	public static final class_1792 tinyPlanet = new ItemTinyPlanet(unstackable());
	public static final class_1792 goddessCharm = new ItemGoddessCharm(unstackable());
	public static final class_1792 divaCharm = new ItemDivaCharm(unstackable().method_7894(class_1814.field_8907));
	public static final class_1792 itemFinder = new ItemItemFinder(unstackable());
	public static final class_1792 flightTiara = new ItemFlightTiara(unstackable().method_7894(class_1814.field_8907));

	// Misc
	public static final class_1792 manaCookie = new class_1792(defaultBuilder().method_19265(new class_4174.class_4175().method_19238(0).method_19237(0.1F).method_19239(new class_1293(class_1294.field_5922, 20, 0), 1).method_19242()));
	public static final class_1792 manaBottle = new ItemBottledMana(unstackable());
	public static final class_1792 laputaShard = new ItemLaputaShard(unstackable().method_7894(class_1814.field_8907));
	public static final class_1792 necroVirus = new ItemVirus(defaultBuilder());
	public static final class_1792 nullVirus = new ItemVirus(defaultBuilder());
	public static final class_1792 spark = new ItemSpark(defaultBuilder());
	public static final class_1792 sparkUpgradeDispersive = new ItemSparkUpgrade(defaultBuilder(), SparkUpgradeType.DISPERSIVE);
	public static final class_1792 sparkUpgradeDominant = new ItemSparkUpgrade(defaultBuilder(), SparkUpgradeType.DOMINANT);
	public static final class_1792 sparkUpgradeRecessive = new ItemSparkUpgrade(defaultBuilder(), SparkUpgradeType.RECESSIVE);
	public static final class_1792 sparkUpgradeIsolated = new ItemSparkUpgrade(defaultBuilder(), SparkUpgradeType.ISOLATED);
	public static final class_1792 corporeaSpark = new ItemCorporeaSpark(defaultBuilder());
	public static final class_1792 corporeaSparkMaster = new ItemCorporeaSpark(defaultBuilder());
	public static final class_1792 blackLotus = new ItemBlackLotus(defaultBuilder().method_7894(class_1814.field_8903));
	public static final class_1792 blackerLotus = new ItemBlackLotus(defaultBuilder().method_7894(class_1814.field_8904));
	public static final class_1792 worldSeed = new ItemWorldSeed(defaultBuilder());
	public static final class_1792 overgrowthSeed = new ItemOvergrowthSeed(defaultBuilder().method_7894(class_1814.field_8903));
	public static final class_1792 phantomInk = new class_1792(defaultBuilder());
	public static final class_1792 poolMinecart = new ItemPoolMinecart(unstackable());
	public static final class_1792 keepIvy = new ItemKeepIvy(defaultBuilder());
	public static final class_1792 placeholder = new ItemSelfReturning(defaultBuilder());
	public static final class_1792 craftPattern1_1 = new ItemCraftPattern(CratePattern.CRAFTY_1_1, unstackable());
	public static final class_1792 craftPattern2_2 = new ItemCraftPattern(CratePattern.CRAFTY_2_2, unstackable());
	public static final class_1792 craftPattern1_2 = new ItemCraftPattern(CratePattern.CRAFTY_1_2, unstackable());
	public static final class_1792 craftPattern2_1 = new ItemCraftPattern(CratePattern.CRAFTY_2_1, unstackable());
	public static final class_1792 craftPattern1_3 = new ItemCraftPattern(CratePattern.CRAFTY_1_3, unstackable());
	public static final class_1792 craftPattern3_1 = new ItemCraftPattern(CratePattern.CRAFTY_3_1, unstackable());
	public static final class_1792 craftPattern2_3 = new ItemCraftPattern(CratePattern.CRAFTY_2_3, unstackable());
	public static final class_1792 craftPattern3_2 = new ItemCraftPattern(CratePattern.CRAFTY_3_2, unstackable());
	public static final class_1792 craftPatternDonut = new ItemCraftPattern(CratePattern.CRAFTY_DONUT, unstackable());

	// Guardian of Gaia drops
	public static final class_1792 dice = new ItemDice(unstackable().method_24359().method_7894(BotaniaAPI.instance().getRelicRarity()));
	public static final class_1792 infiniteFruit = new ItemInfiniteFruit(unstackable().method_24359().method_7894(BotaniaAPI.instance().getRelicRarity()));
	public static final class_1792 kingKey = new ItemKingKey(unstackable().method_24359().method_7894(BotaniaAPI.instance().getRelicRarity()));
	public static final class_1792 flugelEye = new ItemFlugelEye(unstackable().method_24359().method_7894(BotaniaAPI.instance().getRelicRarity()));
	public static final class_1792 thorRing = new ItemThorRing(unstackable().method_24359().method_7894(BotaniaAPI.instance().getRelicRarity()));
	public static final class_1792 odinRing = new ItemOdinRing(unstackable().method_24359().method_7894(BotaniaAPI.instance().getRelicRarity()));
	public static final class_1792 lokiRing = new ItemLokiRing(unstackable().method_24359().method_7894(BotaniaAPI.instance().getRelicRarity()));
	public static final class_1792 recordGaia1 = new ItemModRecord(1, ModSounds.gaiaMusic1, unstackable().method_7894(class_1814.field_8903));
	public static final class_1792 recordGaia2 = new ItemModRecord(1, ModSounds.gaiaMusic2, unstackable().method_7894(class_1814.field_8903));
	public static final class_1792 ancientWillAhrim = new ItemAncientWill(IAncientWillContainer.AncientWillType.AHRIM, unstackable().method_7894(class_1814.field_8907));
	public static final class_1792 ancientWillDharok = new ItemAncientWill(IAncientWillContainer.AncientWillType.DHAROK, unstackable().method_7894(class_1814.field_8907));
	public static final class_1792 ancientWillGuthan = new ItemAncientWill(IAncientWillContainer.AncientWillType.GUTHAN, unstackable().method_7894(class_1814.field_8907));
	public static final class_1792 ancientWillTorag = new ItemAncientWill(IAncientWillContainer.AncientWillType.TORAG, unstackable().method_7894(class_1814.field_8907));
	public static final class_1792 ancientWillVerac = new ItemAncientWill(IAncientWillContainer.AncientWillType.VERAC, unstackable().method_7894(class_1814.field_8907));
	public static final class_1792 ancientWillKaril = new ItemAncientWill(IAncientWillContainer.AncientWillType.KARIL, unstackable().method_7894(class_1814.field_8907));
	public static final class_1792 pinkinator = new ItemPinkinator(unstackable().method_7894(class_1814.field_8907));

	// Brewing
	public static final class_1792 vial = new ItemVial(defaultBuilder());
	public static final class_1792 flask = new ItemVial(defaultBuilder());
	public static final class_1792 brewVial = new ItemBrewBase(unstackable(), 4, 32, () -> vial);
	public static final class_1792 brewFlask = new ItemBrewBase(unstackable(), 6, 24, () -> flask);
	public static final class_1792 bloodPendant = new ItemBloodPendant(unstackable());
	public static final class_1792 incenseStick = new ItemIncenseStick(unstackable());

	// Cosmetics
	public static final class_1792 blackBowtie = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.BLACK_BOWTIE, unstackable());
	public static final class_1792 blackTie = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.BLACK_TIE, unstackable());
	public static final class_1792 redGlasses = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.RED_GLASSES, unstackable());
	public static final class_1792 puffyScarf = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.PUFFY_SCARF, unstackable());
	public static final class_1792 engineerGoggles = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.ENGINEER_GOGGLES, unstackable());
	public static final class_1792 eyepatch = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.EYEPATCH, unstackable());
	public static final class_1792 wickedEyepatch = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.WICKED_EYEPATCH, unstackable());
	public static final class_1792 redRibbons = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.RED_RIBBONS, unstackable());
	public static final class_1792 pinkFlowerBud = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.PINK_FLOWER_BUD, unstackable());
	public static final class_1792 polkaDottedBows = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.POLKA_DOTTED_BOWS, unstackable());
	public static final class_1792 blueButterfly = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.BLUE_BUTTERFLY, unstackable());
	public static final class_1792 catEars = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.CAT_EARS, unstackable());
	public static final class_1792 witchPin = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.WITCH_PIN, unstackable());
	public static final class_1792 devilTail = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.DEVIL_TAIL, unstackable());
	public static final class_1792 kamuiEye = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.KAMUI_EYE, unstackable());
	public static final class_1792 googlyEyes = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.GOOGLY_EYES, unstackable());
	public static final class_1792 fourLeafClover = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.FOUR_LEAF_CLOVER, unstackable());
	public static final class_1792 clockEye = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.CLOCK_EYE, unstackable());
	public static final class_1792 unicornHorn = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.UNICORN_HORN, unstackable());
	public static final class_1792 devilHorns = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.DEVIL_HORNS, unstackable());
	public static final class_1792 hyperPlus = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.HYPER_PLUS, unstackable());
	public static final class_1792 botanistEmblem = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.BOTANIST_EMBLEM, unstackable());
	public static final class_1792 ancientMask = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.ANCIENT_MASK, unstackable());
	public static final class_1792 eerieMask = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.EERIE_MASK, unstackable());
	public static final class_1792 alienAntenna = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.ALIEN_ANTENNA, unstackable());
	public static final class_1792 anaglyphGlasses = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.ANAGLYPH_GLASSES, unstackable());
	public static final class_1792 orangeShades = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.ORANGE_SHADES, unstackable());
	public static final class_1792 grouchoGlasses = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.GROUCHO_GLASSES, unstackable());
	public static final class_1792 thickEyebrows = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.THICK_EYEBROWS, unstackable());
	public static final class_1792 lusitanicShield = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.LUSITANIC_SHIELD, unstackable());
	public static final class_1792 tinyPotatoMask = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.TINY_POTATO_MASK, unstackable());
	public static final class_1792 questgiverMark = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.QUESTGIVER_MARK, unstackable());
	public static final class_1792 thinkingHand = new ItemBaubleCosmetic(ItemBaubleCosmetic.Variant.THINKING_HAND, unstackable());

	public static final class_3917<ContainerFlowerBag> FLOWER_BAG_CONTAINER = ScreenHandlerRegistry.registerExtended(prefix(LibItemNames.FLOWER_BAG), ContainerFlowerBag::fromNetwork);
	public static final class_3917<ContainerBaubleBox> BAUBLE_BOX_CONTAINER = ScreenHandlerRegistry.registerExtended(prefix(LibItemNames.BAUBLE_BOX), ContainerBaubleBox::fromNetwork);

	public static FabricItemSettings defaultBuilder() {
		return new FabricItemSettings().method_7892(BotaniaCreativeTab.INSTANCE);
	}

	private static FabricItemSettings unstackable() {
		return defaultBuilder().method_7889(1);
	}

	public static void registerItems() {
		class_2378<class_1792> r = class_2378.field_11142;
		register(r, LibItemNames.LEXICON, lexicon);
		register(r, LibItemNames.TWIG_WAND, twigWand);
		register(r, LibItemNames.OBEDIENCE_STICK, obedienceStick);
		register(r, LibItemNames.PESTLE_AND_MORTAR, pestleAndMortar);
		register(r, LibItemNames.FERTILIZER, fertilizer);
		register(r, "white" + LibItemNames.PETAL_SUFFIX, whitePetal);
		register(r, "orange" + LibItemNames.PETAL_SUFFIX, orangePetal);
		register(r, "magenta" + LibItemNames.PETAL_SUFFIX, magentaPetal);
		register(r, "light_blue" + LibItemNames.PETAL_SUFFIX, lightBluePetal);
		register(r, "yellow" + LibItemNames.PETAL_SUFFIX, yellowPetal);
		register(r, "lime" + LibItemNames.PETAL_SUFFIX, limePetal);
		register(r, "pink" + LibItemNames.PETAL_SUFFIX, pinkPetal);
		register(r, "gray" + LibItemNames.PETAL_SUFFIX, grayPetal);
		register(r, "light_gray" + LibItemNames.PETAL_SUFFIX, lightGrayPetal);
		register(r, "cyan" + LibItemNames.PETAL_SUFFIX, cyanPetal);
		register(r, "purple" + LibItemNames.PETAL_SUFFIX, purplePetal);
		register(r, "blue" + LibItemNames.PETAL_SUFFIX, bluePetal);
		register(r, "brown" + LibItemNames.PETAL_SUFFIX, brownPetal);
		register(r, "green" + LibItemNames.PETAL_SUFFIX, greenPetal);
		register(r, "red" + LibItemNames.PETAL_SUFFIX, redPetal);
		register(r, "black" + LibItemNames.PETAL_SUFFIX, blackPetal);
		register(r, LibItemNames.MANASTEEL_INGOT, manaSteel);
		register(r, LibItemNames.MANA_PEARL, manaPearl);
		register(r, LibItemNames.MANA_DIAMOND, manaDiamond);
		register(r, LibItemNames.LIVINGWOOD_TWIG, livingwoodTwig);
		register(r, LibItemNames.TERRASTEEL_INGOT, terrasteel);
		register(r, LibItemNames.LIFE_ESSENCE, lifeEssence);
		register(r, LibItemNames.REDSTONE_ROOT, redstoneRoot);
		register(r, LibItemNames.ELEMENTIUM_INGOT, elementium);
		register(r, LibItemNames.PIXIE_DUST, pixieDust);
		register(r, LibItemNames.DRAGONSTONE, dragonstone);
		register(r, LibItemNames.RED_STRING, redString);
		register(r, LibItemNames.DREAMWOOD_TWIG, dreamwoodTwig);
		register(r, LibItemNames.GAIA_INGOT, gaiaIngot);
		register(r, LibItemNames.ENDER_AIR_BOTTLE, enderAirBottle);
		register(r, LibItemNames.MANA_STRING, manaString);
		register(r, LibItemNames.MANASTEEL_NUGGET, manasteelNugget);
		register(r, LibItemNames.TERRASTEEL_NUGGET, terrasteelNugget);
		register(r, LibItemNames.ELEMENTIUM_NUGGET, elementiumNugget);
		register(r, LibItemNames.LIVING_ROOT, livingroot);
		register(r, LibItemNames.PEBBLE, pebble);
		register(r, LibItemNames.MANAWEAVE_CLOTH, manaweaveCloth);
		register(r, LibItemNames.MANA_POWDER, manaPowder);
		register(r, LibItemNames.QUARTZ_DARK, darkQuartz);
		register(r, LibItemNames.QUARTZ_MANA, manaQuartz);
		register(r, LibItemNames.QUARTZ_BLAZE, blazeQuartz);
		register(r, LibItemNames.QUARTZ_LAVENDER, lavenderQuartz);
		register(r, LibItemNames.QUARTZ_RED, redQuartz);
		register(r, LibItemNames.QUARTZ_ELVEN, elfQuartz);
		register(r, LibItemNames.QUARTZ_SUNNY, sunnyQuartz);
		register(r, LibItemNames.LENS_NORMAL, lensNormal);
		register(r, LibItemNames.LENS_SPEED, lensSpeed);
		register(r, LibItemNames.LENS_POWER, lensPower);
		register(r, LibItemNames.LENS_TIME, lensTime);
		register(r, LibItemNames.LENS_EFFICIENCY, lensEfficiency);
		register(r, LibItemNames.LENS_BOUNCE, lensBounce);
		register(r, LibItemNames.LENS_GRAVITY, lensGravity);
		register(r, LibItemNames.LENS_MINE, lensMine);
		register(r, LibItemNames.LENS_DAMAGE, lensDamage);
		register(r, LibItemNames.LENS_PHANTOM, lensPhantom);
		register(r, LibItemNames.LENS_MAGNET, lensMagnet);
		register(r, LibItemNames.LENS_EXPLOSIVE, lensExplosive);
		register(r, LibItemNames.LENS_INFLUENCE, lensInfluence);
		register(r, LibItemNames.LENS_WEIGHT, lensWeight);
		register(r, LibItemNames.LENS_PAINT, lensPaint);
		register(r, LibItemNames.LENS_FIRE, lensFire);
		register(r, LibItemNames.LENS_PISTON, lensPiston);
		register(r, LibItemNames.LENS_LIGHT, lensLight);
		register(r, LibItemNames.LENS_WARP, lensWarp);
		register(r, LibItemNames.LENS_REDIRECT, lensRedirect);
		register(r, LibItemNames.LENS_FIREWORK, lensFirework);
		register(r, LibItemNames.LENS_FLARE, lensFlare);
		register(r, LibItemNames.LENS_MESSENGER, lensMessenger);
		register(r, LibItemNames.LENS_TRIPWIRE, lensTripwire);
		register(r, LibItemNames.LENS_STORM, lensStorm);
		register(r, LibItemNames.RUNE_WATER, runeWater);
		register(r, LibItemNames.RUNE_FIRE, runeFire);
		register(r, LibItemNames.RUNE_EARTH, runeEarth);
		register(r, LibItemNames.RUNE_AIR, runeAir);
		register(r, LibItemNames.RUNE_SPRING, runeSpring);
		register(r, LibItemNames.RUNE_SUMMER, runeSummer);
		register(r, LibItemNames.RUNE_AUTUMN, runeAutumn);
		register(r, LibItemNames.RUNE_WINTER, runeWinter);
		register(r, LibItemNames.RUNE_MANA, runeMana);
		register(r, LibItemNames.RUNE_LUST, runeLust);
		register(r, LibItemNames.RUNE_GLUTTONY, runeGluttony);
		register(r, LibItemNames.RUNE_GREED, runeGreed);
		register(r, LibItemNames.RUNE_SLOTH, runeSloth);
		register(r, LibItemNames.RUNE_WRATH, runeWrath);
		register(r, LibItemNames.RUNE_ENVY, runeEnvy);
		register(r, LibItemNames.RUNE_PRIDE, runePride);
		register(r, LibItemNames.GRASS_SEEDS, grassSeeds);
		register(r, LibItemNames.PODZOL_SEEDS, podzolSeeds);
		register(r, LibItemNames.MYCEL_SEEDS, mycelSeeds);
		register(r, LibItemNames.DRY_SEEDS, drySeeds);
		register(r, LibItemNames.GOLDEN_SEEDS, goldenSeeds);
		register(r, LibItemNames.VIVID_SEEDS, vividSeeds);
		register(r, LibItemNames.SCORCHED_SEEDS, scorchedSeeds);
		register(r, LibItemNames.INFUSED_SEEDS, infusedSeeds);
		register(r, LibItemNames.MUTATED_SEEDS, mutatedSeeds);
		register(r, LibItemNames.DIRT_ROD, dirtRod);
		register(r, LibItemNames.SKY_DIRT_ROD, skyDirtRod);
		register(r, LibItemNames.TERRAFORM_ROD, terraformRod);
		register(r, LibItemNames.COBBLE_ROD, cobbleRod);
		register(r, LibItemNames.WATER_ROD, waterRod);
		register(r, LibItemNames.TORNADO_ROD, tornadoRod);
		register(r, LibItemNames.FIRE_ROD, fireRod);
		register(r, LibItemNames.DIVINING_ROD, diviningRod);
		register(r, LibItemNames.SMELT_ROD, smeltRod);
		register(r, LibItemNames.EXCHANGE_ROD, exchangeRod);
		register(r, LibItemNames.RAINBOW_ROD, rainbowRod);
		register(r, LibItemNames.GRAVITY_ROD, gravityRod);
		register(r, LibItemNames.MISSILE_ROD, missileRod);
		register(r, LibItemNames.MANASTEEL_HELM, manasteelHelm);
		register(r, LibItemNames.MANASTEEL_CHEST, manasteelChest);
		register(r, LibItemNames.MANASTEEL_LEGS, manasteelLegs);
		register(r, LibItemNames.MANASTEEL_BOOTS, manasteelBoots);
		register(r, LibItemNames.MANASTEEL_PICK, manasteelPick);
		register(r, LibItemNames.MANASTEEL_SHOVEL, manasteelShovel);
		register(r, LibItemNames.MANASTEEL_AXE, manasteelAxe);
		register(r, LibItemNames.MANASTEEL_SWORD, manasteelSword);
		register(r, LibItemNames.MANASTEEL_SHEARS, manasteelShears);
		register(r, LibItemNames.ELEMENTIUM_HELM, elementiumHelm);
		register(r, LibItemNames.ELEMENTIUM_CHEST, elementiumChest);
		register(r, LibItemNames.ELEMENTIUM_LEGS, elementiumLegs);
		register(r, LibItemNames.ELEMENTIUM_BOOTS, elementiumBoots);
		register(r, LibItemNames.ELEMENTIUM_PICK, elementiumPick);
		register(r, LibItemNames.ELEMENTIUM_SHOVEL, elementiumShovel);
		register(r, LibItemNames.ELEMENTIUM_AXE, elementiumAxe);
		register(r, LibItemNames.ELEMENTIUM_SWORD, elementiumSword);
		register(r, LibItemNames.ELEMENTIUM_SHEARS, elementiumShears);
		register(r, LibItemNames.TERRASTEEL_HELM, terrasteelHelm);
		register(r, LibItemNames.TERRASTEEL_CHEST, terrasteelChest);
		register(r, LibItemNames.TERRASTEEL_LEGS, terrasteelLegs);
		register(r, LibItemNames.TERRASTEEL_BOOTS, terrasteelBoots);
		register(r, LibItemNames.TERRA_PICK, terraPick);
		register(r, LibItemNames.TERRA_AXE, terraAxe);
		register(r, LibItemNames.TERRA_SWORD, terraSword);
		register(r, LibItemNames.STAR_SWORD, starSword);
		register(r, LibItemNames.THUNDER_SWORD, thunderSword);
		register(r, LibItemNames.MANAWEAVE_HELM, manaweaveHelm);
		register(r, LibItemNames.MANAWEAVE_CHEST, manaweaveChest);
		register(r, LibItemNames.MANAWEAVE_LEGS, manaweaveLegs);
		register(r, LibItemNames.MANAWEAVE_BOOTS, manaweaveBoots);
		register(r, LibItemNames.ENDER_DAGGER, enderDagger);
		register(r, LibItemNames.GLASS_PICK, glassPick);
		register(r, LibItemNames.LIVINGWOOD_BOW, livingwoodBow);
		register(r, LibItemNames.CRYSTAL_BOW, crystalBow);
		register(r, LibItemNames.THORN_CHAKRAM, thornChakram);
		register(r, LibItemNames.FLARE_CHAKRAM, flareChakram);
		register(r, LibItemNames.MANA_TABLET, manaTablet);
		register(r, LibItemNames.MANA_MIRROR, manaMirror);
		register(r, LibItemNames.MANA_GUN, manaGun);
		register(r, LibItemNames.CLIP, clip);
		register(r, LibItemNames.GRASS_HORN, grassHorn);
		register(r, LibItemNames.LEAVES_HORN, leavesHorn);
		register(r, LibItemNames.SNOW_HORN, snowHorn);
		register(r, LibItemNames.VINE_BALL, vineBall);
		register(r, LibItemNames.SLINGSHOT, slingshot);
		register(r, LibItemNames.OPEN_BUCKET, openBucket);
		register(r, LibItemNames.SPAWNER_MOVER, spawnerMover);
		register(r, LibItemNames.ENDER_HAND, enderHand);
		register(r, LibItemNames.CRAFTING_HALO, craftingHalo);
		register(r, LibItemNames.AUTOCRAFTING_HALO, autocraftingHalo);
		register(r, LibItemNames.SPELL_CLOTH, spellCloth);
		register(r, LibItemNames.FLOWER_BAG, flowerBag);
		register(r, LibItemNames.BLACK_HOLE_TALISMAN, blackHoleTalisman);
		register(r, LibItemNames.TEMPERANCE_STONE, temperanceStone);
		register(r, LibItemNames.WATER_BOWL, waterBowl);
		register(r, LibItemNames.CACOPHONIUM, cacophonium);
		register(r, LibItemNames.SLIME_BOTTLE, slimeBottle);
		register(r, LibItemNames.SEXTANT, sextant);
		register(r, LibItemNames.ASTROLABE, astrolabe);
		register(r, LibItemNames.BAUBLE_BOX, baubleBox);
		register(r, LibItemNames.MANA_RING, manaRing);
		register(r, LibItemNames.MANA_RING_GREATER, manaRingGreater);
		register(r, LibItemNames.AURA_RING, auraRing);
		register(r, LibItemNames.AURA_RING_GREATER, auraRingGreater);
		register(r, LibItemNames.MAGNET_RING, magnetRing);
		register(r, LibItemNames.MAGNET_RING_GREATER, magnetRingGreater);
		register(r, LibItemNames.WATER_RING, waterRing);
		register(r, LibItemNames.SWAP_RING, swapRing);
		register(r, LibItemNames.DODGE_RING, dodgeRing);
		register(r, LibItemNames.MINING_RING, miningRing);
		register(r, LibItemNames.PIXIE_RING, pixieRing);
		register(r, LibItemNames.REACH_RING, reachRing);
		register(r, LibItemNames.TRAVEL_BELT, travelBelt);
		register(r, LibItemNames.SUPER_TRAVEL_BELT, superTravelBelt);
		register(r, LibItemNames.SPEED_UP_BELT, speedUpBelt);
		register(r, LibItemNames.KNOCKBACK_BELT, knockbackBelt);
		register(r, LibItemNames.ICE_PENDANT, icePendant);
		register(r, LibItemNames.LAVA_PENDANT, lavaPendant);
		register(r, LibItemNames.SUPER_LAVA_PENDANT, superLavaPendant);
		register(r, LibItemNames.CLOUD_PENDANT, cloudPendant);
		register(r, LibItemNames.SUPER_CLOUD_PENDANT, superCloudPendant);
		register(r, LibItemNames.HOLY_CLOAK, holyCloak);
		register(r, LibItemNames.UNHOLY_CLOAK, unholyCloak);
		register(r, LibItemNames.BALANCE_CLOAK, balanceCloak);
		register(r, LibItemNames.INVISIBILITY_CLOAK, invisibilityCloak);
		register(r, LibItemNames.THIRD_EYE, thirdEye);
		register(r, LibItemNames.MONOCLE, monocle);
		register(r, LibItemNames.TINY_PLANET, tinyPlanet);
		register(r, LibItemNames.GODDESS_CHARM, goddessCharm);
		register(r, LibItemNames.DIVA_CHARM, divaCharm);
		register(r, LibItemNames.ITEM_FINDER, itemFinder);
		register(r, LibItemNames.FLIGHT_TIARA, flightTiara);
		register(r, LibItemNames.MANA_COOKIE, manaCookie);
		register(r, LibItemNames.MANA_BOTTLE, manaBottle);
		register(r, LibItemNames.LAPUTA_SHARD, laputaShard);
		register(r, LibItemNames.NECRO_VIRUS, necroVirus);
		register(r, LibItemNames.NULL_VIRUS, nullVirus);
		register(r, LibItemNames.SPARK, spark);
		register(r, LibItemNames.SPARK_UPGRADE + "_" + SparkUpgradeType.DISPERSIVE.name().toLowerCase(Locale.ROOT), sparkUpgradeDispersive);
		register(r, LibItemNames.SPARK_UPGRADE + "_" + SparkUpgradeType.DOMINANT.name().toLowerCase(Locale.ROOT), sparkUpgradeDominant);
		register(r, LibItemNames.SPARK_UPGRADE + "_" + SparkUpgradeType.RECESSIVE.name().toLowerCase(Locale.ROOT), sparkUpgradeRecessive);
		register(r, LibItemNames.SPARK_UPGRADE + "_" + SparkUpgradeType.ISOLATED.name().toLowerCase(Locale.ROOT), sparkUpgradeIsolated);
		register(r, LibItemNames.CORPOREA_SPARK, corporeaSpark);
		register(r, LibItemNames.CORPOREA_SPARK_MASTER, corporeaSparkMaster);
		register(r, LibItemNames.BLACK_LOTUS, blackLotus);
		register(r, LibItemNames.BLACKER_LOTUS, blackerLotus);
		register(r, LibItemNames.WORLD_SEED, worldSeed);
		register(r, LibItemNames.OVERGROWTH_SEED, overgrowthSeed);
		register(r, LibItemNames.PHANTOM_INK, phantomInk);
		register(r, LibItemNames.POOL_MINECART, poolMinecart);
		register(r, LibItemNames.KEEP_IVY, keepIvy);
		register(r, LibItemNames.PLACEHOLDER, placeholder);
		register(r, LibItemNames.CRAFT_PATTERN_PREFIX + "1_1", craftPattern1_1);
		register(r, LibItemNames.CRAFT_PATTERN_PREFIX + "2_2", craftPattern2_2);
		register(r, LibItemNames.CRAFT_PATTERN_PREFIX + "1_2", craftPattern1_2);
		register(r, LibItemNames.CRAFT_PATTERN_PREFIX + "2_1", craftPattern2_1);
		register(r, LibItemNames.CRAFT_PATTERN_PREFIX + "1_3", craftPattern1_3);
		register(r, LibItemNames.CRAFT_PATTERN_PREFIX + "3_1", craftPattern3_1);
		register(r, LibItemNames.CRAFT_PATTERN_PREFIX + "2_3", craftPattern2_3);
		register(r, LibItemNames.CRAFT_PATTERN_PREFIX + "3_2", craftPattern3_2);
		register(r, LibItemNames.CRAFT_PATTERN_PREFIX + "donut", craftPatternDonut);
		register(r, LibItemNames.DICE, dice);
		register(r, LibItemNames.INFINITE_FRUIT, infiniteFruit);
		register(r, LibItemNames.KING_KEY, kingKey);
		register(r, LibItemNames.FLUGEL_EYE, flugelEye);
		register(r, LibItemNames.THOR_RING, thorRing);
		register(r, LibItemNames.ODIN_RING, odinRing);
		register(r, LibItemNames.LOKI_RING, lokiRing);
		register(r, LibItemNames.RECORD_GAIA1, recordGaia1);
		register(r, LibItemNames.RECORD_GAIA2, recordGaia2);
		register(r, LibItemNames.ANCIENT_WILL_PREFIX + "ahrim", ancientWillAhrim);
		register(r, LibItemNames.ANCIENT_WILL_PREFIX + "dharok", ancientWillDharok);
		register(r, LibItemNames.ANCIENT_WILL_PREFIX + "guthan", ancientWillGuthan);
		register(r, LibItemNames.ANCIENT_WILL_PREFIX + "torag", ancientWillTorag);
		register(r, LibItemNames.ANCIENT_WILL_PREFIX + "verac", ancientWillVerac);
		register(r, LibItemNames.ANCIENT_WILL_PREFIX + "karil", ancientWillKaril);
		register(r, LibItemNames.PINKINATOR, pinkinator);
		register(r, LibItemNames.VIAL, vial);
		register(r, LibItemNames.FLASK, flask);
		register(r, LibItemNames.BREW_VIAL, brewVial);
		register(r, LibItemNames.BREW_FLASK, brewFlask);
		register(r, LibItemNames.BLOOD_PENDANT, bloodPendant);
		register(r, LibItemNames.INCENSE_STICK, incenseStick);
		register(r, LibItemNames.COSMETIC_PREFIX + "black_bowtie", blackBowtie);
		register(r, LibItemNames.COSMETIC_PREFIX + "black_tie", blackTie);
		register(r, LibItemNames.COSMETIC_PREFIX + "red_glasses", redGlasses);
		register(r, LibItemNames.COSMETIC_PREFIX + "puffy_scarf", puffyScarf);
		register(r, LibItemNames.COSMETIC_PREFIX + "engineer_goggles", engineerGoggles);
		register(r, LibItemNames.COSMETIC_PREFIX + "eyepatch", eyepatch);
		register(r, LibItemNames.COSMETIC_PREFIX + "wicked_eyepatch", wickedEyepatch);
		register(r, LibItemNames.COSMETIC_PREFIX + "red_ribbons", redRibbons);
		register(r, LibItemNames.COSMETIC_PREFIX + "pink_flower_bud", pinkFlowerBud);
		register(r, LibItemNames.COSMETIC_PREFIX + "polka_dotted_bows", polkaDottedBows);
		register(r, LibItemNames.COSMETIC_PREFIX + "blue_butterfly", blueButterfly);
		register(r, LibItemNames.COSMETIC_PREFIX + "cat_ears", catEars);
		register(r, LibItemNames.COSMETIC_PREFIX + "witch_pin", witchPin);
		register(r, LibItemNames.COSMETIC_PREFIX + "devil_tail", devilTail);
		register(r, LibItemNames.COSMETIC_PREFIX + "kamui_eye", kamuiEye);
		register(r, LibItemNames.COSMETIC_PREFIX + "googly_eyes", googlyEyes);
		register(r, LibItemNames.COSMETIC_PREFIX + "four_leaf_clover", fourLeafClover);
		register(r, LibItemNames.COSMETIC_PREFIX + "clock_eye", clockEye);
		register(r, LibItemNames.COSMETIC_PREFIX + "unicorn_horn", unicornHorn);
		register(r, LibItemNames.COSMETIC_PREFIX + "devil_horns", devilHorns);
		register(r, LibItemNames.COSMETIC_PREFIX + "hyper_plus", hyperPlus);
		register(r, LibItemNames.COSMETIC_PREFIX + "botanist_emblem", botanistEmblem);
		register(r, LibItemNames.COSMETIC_PREFIX + "ancient_mask", ancientMask);
		register(r, LibItemNames.COSMETIC_PREFIX + "eerie_mask", eerieMask);
		register(r, LibItemNames.COSMETIC_PREFIX + "alien_antenna", alienAntenna);
		register(r, LibItemNames.COSMETIC_PREFIX + "anaglyph_glasses", anaglyphGlasses);
		register(r, LibItemNames.COSMETIC_PREFIX + "orange_shades", orangeShades);
		register(r, LibItemNames.COSMETIC_PREFIX + "groucho_glasses", grouchoGlasses);
		register(r, LibItemNames.COSMETIC_PREFIX + "thick_eyebrows", thickEyebrows);
		register(r, LibItemNames.COSMETIC_PREFIX + "lusitanic_shield", lusitanicShield);
		register(r, LibItemNames.COSMETIC_PREFIX + "tiny_potato_mask", tinyPotatoMask);
		register(r, LibItemNames.COSMETIC_PREFIX + "questgiver_mark", questgiverMark);
		register(r, LibItemNames.COSMETIC_PREFIX + "thinking_hand", thinkingHand);
	}

	public static void registerRecipeSerializers() {
		class_2378<class_1865<?>> r = class_2378.field_17598;
		register(r, "ancient_will_attach", AncientWillRecipe.SERIALIZER);
		register(r, "armor_upgrade", ArmorUpgradeRecipe.SERIALIZER);
		register(r, "banner_pattern_apply", BannerRecipe.SERIALIZER);
		register(r, "black_hole_talisman_extract", BlackHoleTalismanExtractRecipe.SERIALIZER);
		register(r, "composite_lens", CompositeLensRecipe.SERIALIZER);
		register(r, "cosmetic_attach", CosmeticAttachRecipe.SERIALIZER);
		register(r, "cosmetic_remove", CosmeticRemoveRecipe.SERIALIZER);
		register(r, "keep_ivy", KeepIvyRecipe.SERIALIZER);
		register(r, "laputa_shard_upgrade", LaputaShardUpgradeRecipe.SERIALIZER);
		register(r, "lens_dye", LensDyeingRecipe.SERIALIZER);
		register(r, "mana_gun_add_clip", ManaGunClipRecipe.SERIALIZER);
		register(r, "mana_gun_add_lens", ManaGunLensRecipe.SERIALIZER);
		register(r, "mana_gun_remove_lens", ManaGunRemoveLensRecipe.SERIALIZER);
		register(r, "mana_upgrade", ManaUpgradeRecipe.SERIALIZER);
		register(r, "mana_upgrade_shapeless", ShapelessManaUpgradeRecipe.SERIALIZER);
		register(r, "phantom_ink_apply", PhantomInkRecipe.SERIALIZER);
		register(r, "spell_cloth_apply", SpellClothRecipe.SERIALIZER);
		register(r, "terra_pick_tipping", TerraPickTippingRecipe.SERIALIZER);
		register(r, "twig_wand", TwigWandRecipe.SERIALIZER);

		// todo 1.16-fabric replace with nbtcrafting CraftingHelper.register(prefix("fuzzy_nbt"), FuzzyNBTIngredient.SERIALIZER);
	}

	@Environment(EnvType.CLIENT)
	public static void registerGuis() {
		ScreenRegistry.register(FLOWER_BAG_CONTAINER, GuiFlowerBag::new);
		ScreenRegistry.register(BAUBLE_BOX_CONTAINER, GuiBaubleBox::new);
	}

	public static class_1792 getPetal(class_1767 color) {
		switch (color) {
		default:
		case field_7952:
			return whitePetal;
		case field_7946:
			return orangePetal;
		case field_7958:
			return magentaPetal;
		case field_7951:
			return lightBluePetal;
		case field_7947:
			return yellowPetal;
		case field_7961:
			return limePetal;
		case field_7954:
			return pinkPetal;
		case field_7944:
			return grayPetal;
		case field_7967:
			return lightGrayPetal;
		case field_7955:
			return cyanPetal;
		case field_7945:
			return purplePetal;
		case field_7966:
			return bluePetal;
		case field_7957:
			return brownPetal;
		case field_7942:
			return greenPetal;
		case field_7964:
			return redPetal;
		case field_7963:
			return blackPetal;
		}
	}

}
