/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.util.*;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.core.helper.MathHelper;

import javax.annotation.Nonnull;

public class ItemWorldSeed extends class_1792 {

	public ItemWorldSeed(class_1793 builder) {
		super(builder);
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		if (world.field_9236) {
			return new class_1271<>(class_1269.field_5812, stack);
		}

		class_2338 coords = ((class_3218) world).method_27911();
		if (world.method_27983() == class_1937.field_25179 && MathHelper.pointDistanceSpace(coords.method_10263() + 0.5, coords.method_10264() + 0.5, coords.method_10260() + 0.5, player.method_23317(), player.method_23318(), player.method_23321()) > 24) {
			player.field_5965 = 0F;
			player.field_6031 = 0F;
			player.method_5859(coords.method_10263() + 0.5, coords.method_10264() + 0.5, coords.method_10260() + 0.5);

			while (!world.method_8587(player, player.method_5829())) {
				player.method_5859(player.method_23317(), player.method_23318() + 1, player.method_23321());
			}

			world.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1F, 1F);
			SparkleParticleData data = SparkleParticleData.sparkle(1F, 0.25F, 1F, 0.25F, 10);
			((class_3218) world).method_14199(data, player.method_23317(), player.method_23318() + player.method_17682() / 2, player.method_23321(), 50, player.method_17681() / 8, player.method_17682() / 4, player.method_17681() / 8, 0);

			stack.method_7934(1);
			return new class_1271<>(class_1269.field_5812, stack);
		}

		return new class_1271<>(class_1269.field_5811, stack);
	}

}
