/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import alexiil.mc.lib.attributes.AttributeProviderItem;
import alexiil.mc.lib.attributes.ItemAttributeList;
import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidExtractable;
import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidKeys;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.attributes.misc.AbstractItemBasedAttribute;
import alexiil.mc.lib.attributes.misc.LimitedConsumer;
import alexiil.mc.lib.attributes.misc.Reference;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

public class ItemWaterBowl extends class_1792 implements AttributeProviderItem {

	public ItemWaterBowl(class_1793 builder) {
		super(builder);
	}

	@Override
	public void addAllAttributes(Reference<class_1799> stack, LimitedConsumer<class_1799> excess, ItemAttributeList<?> to) {
		to.offer(new Handler(stack, excess));
	}

	private static class Handler extends AbstractItemBasedAttribute implements FluidExtractable {

		private Handler(Reference<class_1799> stack, LimitedConsumer<class_1799> excess) {
			super(stack, excess);
		}

		@Override
		public FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation) {
			if (!filter.matches(FluidKeys.WATER) || !maxAmount.equals(FluidAmount.BUCKET)) {
				return FluidVolumeUtil.EMPTY;
			}

			class_1799 oldStack = stackRef.get().method_7972();
			oldStack.method_7934(1);

			if (setStacks(simulation, oldStack, new class_1799(class_1802.field_8428))) {
				return FluidKeys.WATER.withAmount(FluidAmount.BUCKET);
			} else {
				return FluidVolumeUtil.EMPTY;
			}
		}
	}

}
