/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2288;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4208;
import net.minecraft.util.*;
import net.minecraft.util.math.*;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.wand.ICoordBoundItem;
import vazkii.botania.api.wand.ITileBound;
import vazkii.botania.api.wand.IWandBindable;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.BlockPistonRelay;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileEnchanter;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.network.PacketBotaniaEffect;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import java.util.List;
import java.util.Optional;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class ItemTwigWand extends class_1792 implements ICoordBoundItem {

	private static final String TAG_COLOR1 = "color1";
	private static final String TAG_COLOR2 = "color2";
	private static final String TAG_BOUND_TILE_X = "boundTileX";
	private static final String TAG_BOUND_TILE_Y = "boundTileY";
	private static final String TAG_BOUND_TILE_Z = "boundTileZ";
	private static final String TAG_BIND_MODE = "bindMode";
	private static final class_2338 UNBOUND_POS = new class_2338(0, -1, 0);

	public ItemTwigWand(class_1792.class_1793 builder) {
		super(builder);
	}

	private static boolean tryCompleteBinding(class_2338 src, class_1799 stack, class_1838 ctx) {
		class_2338 dest = ctx.method_8037();
		if (!dest.equals(src)) {
			setBindingAttempt(stack, UNBOUND_POS);

			class_2586 srcTile = ctx.method_8045().method_8321(src);
			if (srcTile instanceof IWandBindable) {
				if (((IWandBindable) srcTile).bindTo(ctx.method_8036(), stack, dest, ctx.method_8038())) {
					doParticleBeamWithOffset(ctx.method_8045(), src, dest);
					setBindingAttempt(stack, UNBOUND_POS);
				}
				return true;
			}
		}
		return false;
	}

	private static boolean tryFormEnchanter(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_2338 pos = ctx.method_8037();
		class_2350.class_2351 axis = TileEnchanter.canEnchanterExist(world, pos);

		if (axis != null) {
			if (!world.field_9236) {
				world.method_8501(pos, ModBlocks.enchanter.method_9564().method_11657(BotaniaStateProps.ENCHANTER_DIRECTION, axis));
				world.method_8396(null, pos, ModSounds.enchanterForm, class_3419.field_15245, 0.5F, 0.6F);
				PlayerHelper.grantCriterion((class_3222) ctx.method_8036(), prefix("main/enchanter_make"), "code_triggered");
			} else {
				for (int i = 0; i < 50; i++) {
					float red = (float) Math.random();
					float green = (float) Math.random();
					float blue = (float) Math.random();

					double x = (Math.random() - 0.5) * 6;
					double y = (Math.random() - 0.5) * 6;
					double z = (Math.random() - 0.5) * 6;

					float velMul = 0.07F;

					float motionx = (float) -x * velMul;
					float motiony = (float) -y * velMul;
					float motionz = (float) -z * velMul;
					WispParticleData data = WispParticleData.wisp((float) Math.random() * 0.15F + 0.15F, red, green, blue);
					world.method_8406(data, pos.method_10263() + 0.5 + x, pos.method_10264() + 0.5 + y, pos.method_10260() + 0.5 + z, motionx, motiony, motionz);
				}
			}

			return true;
		}
		return false;
	}

	private static boolean tryCompletePistonRelayBinding(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_2338 pos = ctx.method_8037();
		class_1657 player = ctx.method_8036();

		class_4208 bindPos = ((BlockPistonRelay) ModBlocks.pistonRelay).activeBindingAttempts.get(player.method_5667());
		if (bindPos != null && bindPos.method_19442() == world.method_27983()) {
			((BlockPistonRelay) ModBlocks.pistonRelay).activeBindingAttempts.remove(player.method_5667());
			BlockPistonRelay.WorldData data = BlockPistonRelay.WorldData.get(world);
			data.mapping.put(bindPos.method_19446(), pos.method_10062());
			data.method_80();

			PacketBotaniaEffect.sendNearby(world, pos, PacketBotaniaEffect.EffectType.PARTICLE_BEAM,
					bindPos.method_19446().method_10263() + 0.5, bindPos.method_19446().method_10264() + 0.5, bindPos.method_19446().method_10260() + 0.5,
					pos.method_10263(), pos.method_10264(), pos.method_10260());

			world.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), ModSounds.ding, class_3419.field_15248, 1F, 1F);
			return true;
		}
		return false;
	}

	@Nonnull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1799 stack = ctx.method_8041();
		class_1937 world = ctx.method_8045();
		class_1657 player = ctx.method_8036();
		class_2338 pos = ctx.method_8037();
		class_2680 state = world.method_8320(pos);
		class_2248 block = state.method_26204();
		class_2350 side = ctx.method_8038();
		Optional<class_2338> boundPos = getBindingAttempt(stack);

		if (player == null) {
			return class_1269.field_5811;
		}

		if (player.method_5715()) {
			if (boundPos.isPresent() && tryCompleteBinding(boundPos.get(), stack, ctx)) {
				return class_1269.field_5812;
			}

			if (player.method_7343(pos, side, stack)
					&& (!(block instanceof class_2288) || player.method_7338())) {
				class_2680 newState = rotate(state, side.method_10166());
				if (newState != state) {
					world.method_8501(pos, newState);
					return class_1269.field_5812;
				}
			}
		}

		if (block == class_2246.field_10441 && ConfigHandler.COMMON.enchanterEnabled.getValue() && tryFormEnchanter(ctx)) {
			return class_1269.field_5812;
		}

		if (block instanceof IWandable) {
			class_2586 tile = world.method_8321(pos);
			boolean bindable = tile instanceof IWandBindable;

			boolean wanded;
			if (getBindMode(stack) && bindable && player.method_5715() && ((IWandBindable) tile).canSelect(player, stack, pos, side)) {
				if (boundPos.isPresent() && boundPos.get().equals(pos)) {
					setBindingAttempt(stack, UNBOUND_POS);
				} else {
					setBindingAttempt(stack, pos);
				}

				if (world.field_9236) {
					player.method_5783(ModSounds.ding, 0.11F, 1F);
				}

				wanded = true;
			} else {
				wanded = ((IWandable) block).onUsedByWand(player, stack, world, pos, side);
			}

			return wanded ? class_1269.field_5812 : class_1269.field_5814;
		}

		if (!world.field_9236 && getBindMode(stack) && tryCompletePistonRelayBinding(ctx)) {
			return class_1269.field_5812;
		}

		return class_1269.field_5811;
	}

	private static class_2680 rotate(class_2680 old, class_2350.class_2351 axis) {
		for (class_2769<?> prop : old.method_28501()) {
			if (prop.method_11899().equals("facing") && prop.method_11902() == class_2350.class) {
				@SuppressWarnings("unchecked")
				class_2769<class_2350> facingProp = (class_2769<class_2350>) prop;

				class_2350 oldDir = old.method_11654(facingProp);
				class_2350 newDir = rotateAround(oldDir, axis);
				if (oldDir != newDir && facingProp.method_11898().contains(newDir)) {
					return old.method_11657(facingProp, newDir);
				}
			}
		}

		return old.method_26186(class_2470.field_11463);
	}

	private static class_2350 rotateAround(class_2350 old, class_2350.class_2351 axis) {
		switch (axis) {
		case field_11048: {
			switch (old) {
			case field_11033:
				return class_2350.field_11035;
			case field_11035:
				return class_2350.field_11036;
			case field_11036:
				return class_2350.field_11043;
			case field_11043:
				return class_2350.field_11033;
			}
			break;
		}
		case field_11052: {
			switch (old) {
			case field_11043:
				return class_2350.field_11034;
			case field_11034:
				return class_2350.field_11035;
			case field_11035:
				return class_2350.field_11039;
			case field_11039:
				return class_2350.field_11043;
			}
			break;
		}
		case field_11051: {
			switch (old) {
			case field_11033:
				return class_2350.field_11039;
			case field_11039:
				return class_2350.field_11036;
			case field_11036:
				return class_2350.field_11034;
			case field_11034:
				return class_2350.field_11033;
			}
			break;
		}
		}

		return old;
	}

	public static void doParticleBeamWithOffset(class_1937 world, class_2338 orig, class_2338 end) {
		class_243 origOffset = world.method_8320(orig).method_26226(world, orig);
		Vector3 vorig = new Vector3(orig.method_10263() + origOffset.method_10216() + 0.5, orig.method_10264() + origOffset.method_10214() + 0.5, orig.method_10260() + origOffset.method_10215() + 0.5);
		class_243 endOffset = world.method_8320(end).method_26226(world, end);
		Vector3 vend = new Vector3(end.method_10263() + endOffset.method_10216() + 0.5, end.method_10264() + endOffset.method_10214() + 0.5, end.method_10260() + endOffset.method_10215() + 0.5);
		doParticleBeam(world, vorig, vend);
	}

	public static void doParticleBeam(class_1937 world, Vector3 orig, Vector3 end) {
		if (!world.field_9236) {
			return;
		}

		Vector3 diff = end.subtract(orig);
		Vector3 movement = diff.normalize().multiply(0.05);
		int iters = (int) (diff.mag() / movement.mag());
		float huePer = 1F / iters;
		float hueSum = (float) Math.random();

		Vector3 currentPos = orig;
		for (int i = 0; i < iters; i++) {
			float hue = i * huePer + hueSum;
			int color = class_3532.method_15369(class_3532.method_22450(hue), 1F, 1F);
			float r = (color >> 16 & 0xFF) / 255F;
			float g = (color >> 8 & 0xFF) / 255F;
			float b = (color & 0xFF) / 255F;

			SparkleParticleData data = SparkleParticleData.noClip(0.5F, r, g, b, 4);
			Botania.proxy.addParticleForceNear(world, data, currentPos.x, currentPos.y, currentPos.z, 0, 0, 0);
			currentPos = currentPos.add(movement);
		}
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
		getBindingAttempt(stack).ifPresent(coords -> {
			class_2586 tile = world.method_8321(coords);
			if (!(tile instanceof IWandBindable)) {
				setBindingAttempt(stack, UNBOUND_POS);
			}
		});
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		if (player.method_5715()) {
			if (!world.field_9236) {
				setBindMode(stack, !getBindMode(stack));
			} else {
				player.method_5783(ModSounds.ding, 0.1F, 1F);
			}
		}

		return class_1271.method_22427(stack);
	}

	@Override
	public void method_7850(@Nonnull class_1761 group, @Nonnull class_2371<class_1799> stacks) {
		if (method_7877(group)) {
			for (int i = 0; i < 16; i++) {
				stacks.add(forColors(i, i));
			}
		}
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> list, class_1836 flags) {
		list.add(new class_2588(getModeString(stack)).method_27692(class_124.field_1080));
	}

	/* todo 1.16-fabric
	@Override
	public Text getHighlightTip(ItemStack stack, Text displayName) {
		Text mode = new LiteralText(" (")
				.append(new TranslatableText(getModeString(stack)).formatted(Formatting.DARK_GREEN))
				.append(")");
		return displayName.shallowCopy().append(mode);
	}
	*/

	public static class_1799 forColors(int color1, int color2) {
		class_1799 stack = new class_1799(ModItems.twigWand);
		ItemNBTHelper.setInt(stack, TAG_COLOR1, color1);
		ItemNBTHelper.setInt(stack, TAG_COLOR2, color2);

		return stack;
	}

	public static int getColor1(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_COLOR1, 0);
	}

	public static int getColor2(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_COLOR2, 0);
	}

	public static void setBindingAttempt(class_1799 stack, class_2338 pos) {
		ItemNBTHelper.setInt(stack, TAG_BOUND_TILE_X, pos.method_10263());
		ItemNBTHelper.setInt(stack, TAG_BOUND_TILE_Y, pos.method_10264());
		ItemNBTHelper.setInt(stack, TAG_BOUND_TILE_Z, pos.method_10260());
	}

	public static Optional<class_2338> getBindingAttempt(class_1799 stack) {
		int x = ItemNBTHelper.getInt(stack, TAG_BOUND_TILE_X, 0);
		int y = ItemNBTHelper.getInt(stack, TAG_BOUND_TILE_Y, -1);
		int z = ItemNBTHelper.getInt(stack, TAG_BOUND_TILE_Z, 0);
		return y < 0 ? Optional.empty() : Optional.of(new class_2338(x, y, z));
	}

	public static boolean getBindMode(class_1799 stack) {
		return ItemNBTHelper.getBoolean(stack, TAG_BIND_MODE, true);
	}

	public static void setBindMode(class_1799 stack, boolean bindMode) {
		ItemNBTHelper.setBoolean(stack, TAG_BIND_MODE, bindMode);
	}

	public static String getModeString(class_1799 stack) {
		return "botaniamisc.wandMode." + (getBindMode(stack) ? "bind" : "function");
	}

	@Nullable
	@Override
	public class_2338 getBinding(class_1937 world, class_1799 stack) {
		Optional<class_2338> bound = getBindingAttempt(stack);
		if (bound.isPresent()) {
			return bound.get();
		}

		class_239 pos = class_310.method_1551().field_1765;
		if (pos != null && pos.method_17783() == class_239.class_240.field_1332) {
			class_2586 tile = world.method_8321(((class_3965) pos).method_17777());
			if (tile instanceof ITileBound) {
				return ((ITileBound) tile).getBinding();
			}
		}

		return null;
	}

}
