/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import vazkii.botania.common.core.helper.ItemNBTHelper;

import javax.annotation.Nonnull;

import java.util.List;

public class ItemTemperanceStone extends class_1792 {
	public static final String TAG_ACTIVE = "active";

	public ItemTemperanceStone(class_1793 builder) {
		super(builder);
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		ItemNBTHelper.setBoolean(stack, TAG_ACTIVE, !ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, false));
		world.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14627, class_3419.field_15254, 0.3F, 0.1F);
		return class_1271.method_22427(stack);
	}

	@Override
	@Environment(EnvType.CLIENT)
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> stacks, class_1836 flags) {
		if (ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, false)) {
			stacks.add(new class_2588("botaniamisc.active"));
		} else {
			stacks.add(new class_2588("botaniamisc.inactive"));
		}
	}

	public static boolean hasTemperanceActive(class_1657 player) {
		class_1263 inv = player.field_7514;
		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960() && stack.method_7909() == ModItems.temperanceStone && ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, false)) {
				return true;
			}
		}

		return false;
	}

}
