/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.common.entity.EntitySpark;

import javax.annotation.Nonnull;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;

public class ItemSpark extends class_1792 {

	public ItemSpark(class_1793 builder) {
		super(builder);
	}

	@Nonnull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		return attachSpark(ctx.method_8045(), ctx.method_8037(), ctx.method_8041()) ? class_1269.method_29236(ctx.method_8045().field_9236) : class_1269.field_5811;
	}

	public static boolean attachSpark(class_1937 world, class_2338 pos, class_1799 stack) {
		class_2586 tile = world.method_8321(pos);
		if (tile instanceof ISparkAttachable) {
			ISparkAttachable attach = (ISparkAttachable) tile;
			if (attach.canAttachSpark(stack) && attach.getAttachedSpark() == null) {
				if (!world.field_9236) {
					stack.method_7934(1);
					EntitySpark spark = new EntitySpark(world);
					spark.method_5814(pos.method_10263() + 0.5, pos.method_10264() + 1.25, pos.method_10260() + 0.5);
					world.method_8649(spark);
					attach.attachSpark(spark);
				}
				return true;
			}
		}
		return false;
	}
}
