/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.entity.EntityVineBall;

import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import java.util.function.Predicate;

public class ItemSlingshot extends class_1792 {

	private static final Predicate<class_1799> AMMO_FUNC = s -> s != null && s.method_7909() == ModItems.vineBall;

	public ItemSlingshot(class_1793 builder) {
		super(builder);
	}

	@Override
	public void method_7840(class_1799 stack, class_1937 world, class_1309 living, int duration) {
		int j = method_7881(stack) - duration;

		if (!world.field_9236 && (!(living instanceof class_1657) || ((class_1657) living).field_7503.field_7477 || PlayerHelper.hasAmmo((class_1657) living, AMMO_FUNC))) {
			float f = j / 20.0F;
			f = (f * f + f * 2.0F) / 3.0F;

			if (f < 1F) {
				return;
			}

			if (living instanceof class_1657 && !((class_1657) living).field_7503.field_7477) {
				PlayerHelper.consumeAmmo((class_1657) living, AMMO_FUNC);
			}

			EntityVineBall ball = new EntityVineBall(living, false);
			ball.method_24919(living, living.field_5965, living.field_6031, 0F, 1.5F, 1F);
			ball.method_18799(ball.method_18798().method_1021(1.6));
			world.method_8649(ball);
			world.method_8465(null, living.method_23317(), living.method_23318(), living.method_23321(), class_3417.field_14600, class_3419.field_15254, 0.5F, 0.4F / (field_8005.nextFloat() * 0.4F + 0.8F));
		}
	}

	@Override
	public int method_7881(class_1799 stack) {
		return 72000;
	}

	@Nonnull
	@Override
	public class_1839 method_7853(class_1799 stack) {
		return class_1839.field_8953;
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		if (player.field_7503.field_7477 || PlayerHelper.hasAmmo(player, AMMO_FUNC)) {
			player.method_6019(hand);
			return class_1271.method_22428(stack);
		}

		return class_1271.method_22430(stack);
	}

}
