/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import com.mojang.blaze3d.systems.RenderSystem;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2470;
import net.minecraft.class_2585;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import org.lwjgl.opengl.GL11;

import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;

import javax.annotation.Nonnull;

import java.util.HashMap;
import java.util.Map;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class ItemSextant extends class_1792 {
	public static final class_2960 MULTIBLOCK_ID = prefix("sextant");
	private static final int MAX_RADIUS = 256;
	private static final String TAG_SOURCE_X = "sourceX";
	private static final String TAG_SOURCE_Y = "sourceY";
	private static final String TAG_SOURCE_Z = "sourceZ";

	public ItemSextant(class_1793 builder) {
		super(builder);
	}

	@Nonnull
	@Override
	public class_1839 method_7853(class_1799 stack) {
		return class_1839.field_8953;
	}

	@Override
	public int method_7881(class_1799 stack) {
		return 72000;
	}

	@Override
	public void method_7852(class_1937 world, class_1309 living, class_1799 stack, int count) {
		if (method_7881(stack) - count < 10
				|| !(living instanceof class_1657)
				|| world.field_9236) {
			return;
		}

		int x = ItemNBTHelper.getInt(stack, TAG_SOURCE_X, 0);
		int y = ItemNBTHelper.getInt(stack, TAG_SOURCE_Y, -1);
		int z = ItemNBTHelper.getInt(stack, TAG_SOURCE_Z, 0);
		if (y != -1) {
			Vector3 source = new Vector3(x, y, z);

			double radius = calculateRadius(stack, living);

			if (count % 10 == 0) {
				WispParticleData data = WispParticleData.wisp(0.3F, 0F, 1F, 1F, 1);
				for (int i = 0; i < 360; i++) {
					float radian = (float) (i * Math.PI / 180);
					double xp = x + Math.cos(radian) * radius;
					double zp = z + Math.sin(radian) * radius;
					world.method_8406(data, xp + 0.5, source.y + 1, zp + 0.5, 0, - -0.01F, 0);
				}
			}
		}
	}

	@Override
	public void method_7840(class_1799 stack, class_1937 world, class_1309 living, int time) {
		if (!(living instanceof class_1657)) {
			return;
		}

		double radius = calculateRadius(stack, living);
		if (1 < radius && radius <= MAX_RADIUS) {
			IStateMatcher matcher = PatchouliAPI.get().predicateMatcher(class_2246.field_10445, s -> !s.method_26215());
			int x = ItemNBTHelper.getInt(stack, TAG_SOURCE_X, 0);
			int y = ItemNBTHelper.getInt(stack, TAG_SOURCE_Y, -1);
			int z = ItemNBTHelper.getInt(stack, TAG_SOURCE_Z, 0);
			int iradius = (int) radius + 1;
			if (y != -1) {
				Map<class_2338, IStateMatcher> map = new HashMap<>();
				for (int i = 0; i < iradius * 2 + 1; i++) {
					for (int j = 0; j < iradius * 2 + 1; j++) {
						int xp = x + i - iradius;
						int zp = z + j - iradius;

						if ((int) Math.floor(MathHelper.pointDistancePlane(xp, zp, x, z)) == iradius - 1) {
							map.put(new class_2338(xp - x, 0, zp - z), matcher);
						}
					}
				}
				IMultiblock sparse = PatchouliAPI.get().makeSparseMultiblock(map).setId(MULTIBLOCK_ID);
				Botania.proxy.showMultiblock(sparse, new class_2585("r = " + (int) radius), new class_2338(x, y, z), class_2470.field_11467);
			}
		}
	}

	private void reset(class_1937 world, class_1799 stack) {
		ItemNBTHelper.setInt(stack, TAG_SOURCE_Y, -1);
		if (world.field_9236) {
			Botania.proxy.clearSextantMultiblock();
		}
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		if (!player.method_5715()) {
			class_3965 rtr = ToolCommons.raytraceFromEntity(player, 128, false);
			if (rtr.method_17783() == class_239.class_240.field_1332) {
				if (!world.field_9236) {
					class_2338 pos = rtr.method_17777();
					ItemNBTHelper.setInt(stack, TAG_SOURCE_X, pos.method_10263());
					ItemNBTHelper.setInt(stack, TAG_SOURCE_Y, pos.method_10264());
					ItemNBTHelper.setInt(stack, TAG_SOURCE_Z, pos.method_10260());
				}
				player.method_6019(hand);
			}
		} else {
			reset(world, stack);
		}

		return class_1271.method_22427(stack);
	}

	private static double calculateRadius(class_1799 stack, class_1309 living) {
		int x = ItemNBTHelper.getInt(stack, TAG_SOURCE_X, 0);
		int y = ItemNBTHelper.getInt(stack, TAG_SOURCE_Y, -1);
		int z = ItemNBTHelper.getInt(stack, TAG_SOURCE_Z, 0);
		Vector3 source = new Vector3(x, y, z);
		WispParticleData data = WispParticleData.wisp(0.2F, 1F, 0F, 0F, 1);
		living.field_6002.method_8406(data, source.x + 0.5, source.y + 1, source.z + 0.5, 0, - -0.1F, 0);

		Vector3 centerVec = Vector3.fromEntityCenter(living);
		Vector3 diffVec = source.subtract(centerVec);
		Vector3 lookVec = new Vector3(living.method_5720());
		double mul = diffVec.y / lookVec.y;
		lookVec = lookVec.multiply(mul).add(centerVec);

		lookVec = new Vector3(net.minecraft.class_3532.method_15357(lookVec.x),
				lookVec.y,
				net.minecraft.class_3532.method_15357(lookVec.z));

		return MathHelper.pointDistancePlane(source.x, source.z, lookVec.x, lookVec.z);
	}

	@Environment(EnvType.CLIENT)
	public static void renderHUD(class_4587 ms, class_1657 player, class_1799 stack) {
		class_1799 onUse = player.method_6030();
		int time = player.method_6014();

		if (onUse == stack && stack.method_7909().method_7881(stack) - time >= 10) {
			double radius = calculateRadius(stack, player);
			class_327 font = class_310.method_1551().field_1772;
			int x = class_310.method_1551().method_22683().method_4486() / 2 + 30;
			int y = class_310.method_1551().method_22683().method_4502() / 2;

			String s = Integer.toString((int) radius);
			boolean inRange = 0 < radius && radius <= MAX_RADIUS;
			if (!inRange) {
				s = class_124.field_1061 + s;
			}

			font.method_1720(ms, s, x - font.method_1727(s) / 2, y - 4, 0xFFFFFF);

			if (inRange) {
				radius += 4;
				RenderSystem.disableTexture();
				RenderSystem.lineWidth(3F);
				class_289.method_1348().method_1349().method_1328(GL11.GL_LINE_STRIP, class_290.field_1592);
				RenderSystem.color4f(0F, 1F, 1F, 1F);
				for (int i = 0; i < 361; i++) {
					float radian = (float) (i * Math.PI / 180);
					float xp = x + net.minecraft.class_3532.method_15362(radian) * (float) radius;
					float yp = y + net.minecraft.class_3532.method_15374(radian) * (float) radius;
					class_289.method_1348().method_1349().method_22918(ms.method_23760().method_23761(), xp, yp, 0).method_1344();
				}
				class_289.method_1348().method_1350();
				RenderSystem.enableTexture();
			}
		}
	}

}
