/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1528;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.entity.EntityPinkWither;
import vazkii.botania.common.entity.ModEntities;

import javax.annotation.Nonnull;

import java.util.List;

public class ItemPinkinator extends class_1792 {

	public ItemPinkinator(class_1793 builder) {
		super(builder);
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		int range = 16;
		List<class_1528> withers = world.method_18467(class_1528.class, new class_238(player.method_23317() - range, player.method_23318() - range, player.method_23321() - range, player.method_23317() + range, player.method_23318() + range, player.method_23321() + range));
		for (class_1528 wither : withers) {
			if (!world.field_9236 && wither.method_5805() && !(wither instanceof EntityPinkWither)) {
				wither.method_5650();
				EntityPinkWither pink = ModEntities.PINK_WITHER.method_5883(world);
				pink.method_5808(wither.method_23317(), wither.method_23318(), wither.method_23321(), wither.field_6031, wither.field_5965);
				pink.method_5977(wither.method_5987());
				if (wither.method_16914()) {
					pink.method_5665(wither.method_5797());
					pink.method_5880(wither.method_5807());
				}
				pink.method_5943((class_5425) world, world.method_8404(pink.method_24515()), class_3730.field_16468, null, null);
				world.method_8649(pink);
				pink.method_5990();
				pink.method_5783(class_3417.field_15152, 4F, (1F + (world.field_9229.nextFloat() - world.field_9229.nextFloat()) * 0.2F) * 0.7F);
				UseItemSuccessTrigger.INSTANCE.trigger((class_3222) player, stack, (class_3218) world, player.method_23317(), player.method_23318(), player.method_23321());
				stack.method_7934(1);
				return class_1271.method_22427(stack);
			}
		}

		return class_1271.method_22430(stack);
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flags) {
		tooltip.add(new class_2588("botaniamisc.pinkinatorDesc").method_27692(class_124.field_1080));
	}

}
