/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import vazkii.botania.api.mana.IManaCollector;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;

import javax.annotation.Nonnull;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import java.util.function.BiFunction;

public class ItemObedienceStick extends class_1792 {

	public ItemObedienceStick(class_1793 props) {
		super(props);
	}

	@Nonnull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_2338 pos = ctx.method_8037();
		return applyStick(world, pos) ? class_1269.field_5812 : class_1269.field_5811;
	}

	public static boolean applyStick(class_1937 world, class_2338 pos) {
		class_2586 tileAt = world.method_8321(pos);
		if (tileAt instanceof IManaPool || tileAt instanceof IManaCollector) {
			boolean pool = tileAt instanceof IManaPool;
			BiFunction<TileEntitySpecialFlower, class_2586, Boolean> act = pool ? functionalActuator : generatingActuator;
			int range = pool ? TileEntityFunctionalFlower.LINK_RANGE : TileEntityGeneratingFlower.LINK_RANGE;

			for (class_2338 iterPos : class_2338.method_10097(pos.method_10069(-range, -range, -range),
					pos.method_10069(range, range, range))) {
				if (iterPos.method_10262(pos) > range * range) {
					continue;
				}

				class_2586 tile = world.method_8321(iterPos);
				if (tile instanceof TileEntitySpecialFlower) {
					TileEntitySpecialFlower subtile = ((TileEntitySpecialFlower) tile);
					if (act.apply(subtile, tileAt)) {
						ItemTwigWand.doParticleBeamWithOffset(world, iterPos, pos);
					}
				}
			}

			return true;
		}

		return false;
	}

	private static final BiFunction<TileEntitySpecialFlower, class_2586, Boolean> generatingActuator = (flower, tile) -> {
		if (flower instanceof TileEntityGeneratingFlower) {
			((TileEntityGeneratingFlower) flower).linkToForcefully(tile);
			return true;
		}
		return false;
	};

	private static final BiFunction<TileEntitySpecialFlower, class_2586, Boolean> functionalActuator = (flower, tile) -> {
		if (flower instanceof TileEntityFunctionalFlower) {
			((TileEntityFunctionalFlower) flower).linkToForcefully(tile);
			return true;
		}
		return false;
	};

}
