/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_3532;
import vazkii.botania.api.mana.ICreativeManaProvider;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaTooltipDisplay;
import vazkii.botania.common.core.helper.ItemNBTHelper;

import javax.annotation.Nonnull;

import java.util.List;

public class ItemManaTablet extends class_1792 implements IManaItem, ICreativeManaProvider, IManaTooltipDisplay, IDurabilityExtension {

	public static final int MAX_MANA = 500000;

	private static final String TAG_MANA = "mana";
	private static final String TAG_CREATIVE = "creative";
	private static final String TAG_ONE_USE = "oneUse";

	public ItemManaTablet(class_1793 props) {
		super(props);
	}

	@Override
	public void method_7850(@Nonnull class_1761 tab, @Nonnull class_2371<class_1799> stacks) {
		if (method_7877(tab)) {
			stacks.add(new class_1799(this));

			class_1799 fullPower = new class_1799(this);
			setMana(fullPower, MAX_MANA);
			stacks.add(fullPower);

			class_1799 creative = new class_1799(this);
			setMana(creative, MAX_MANA);
			setStackCreative(creative);
			stacks.add(creative);
		}
	}

	@Nonnull
	@Override
	public class_1814 method_7862(@Nonnull class_1799 stack) {
		return isCreative(stack) ? class_1814.field_8904 : super.method_7862(stack);
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> stacks, class_1836 flags) {
		if (isStackCreative(stack)) {
			stacks.add(new class_2588("botaniamisc.creative").method_27692(class_124.field_1080));
		}
	}

	public static void setMana(class_1799 stack, int mana) {
		ItemNBTHelper.setInt(stack, TAG_MANA, mana);
	}

	public static void setStackCreative(class_1799 stack) {
		ItemNBTHelper.setBoolean(stack, TAG_CREATIVE, true);
	}

	public static boolean isStackCreative(class_1799 stack) {
		return ItemNBTHelper.getBoolean(stack, TAG_CREATIVE, false);
	}

	@Override
	public int getMana(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_MANA, 0);
	}

	@Override
	public int getMaxMana(class_1799 stack) {
		return isStackCreative(stack) ? MAX_MANA + 1000 : MAX_MANA;
	}

	@Override
	public void addMana(class_1799 stack, int mana) {
		if (!isStackCreative(stack)) {
			setMana(stack, Math.min(getMana(stack) + mana, MAX_MANA));
		}
	}

	@Override
	public boolean canReceiveManaFromPool(class_1799 stack, class_2586 pool) {
		return !ItemNBTHelper.getBoolean(stack, TAG_ONE_USE, false);
	}

	@Override
	public boolean canReceiveManaFromItem(class_1799 stack, class_1799 otherStack) {
		return !isCreative(stack);
	}

	@Override
	public boolean canExportManaToPool(class_1799 stack, class_2586 pool) {
		return true;
	}

	@Override
	public boolean canExportManaToItem(class_1799 stack, class_1799 otherStack) {
		return true;
	}

	@Override
	public boolean isNoExport(class_1799 stack) {
		return false;
	}

	@Override
	public boolean isCreative(class_1799 stack) {
		return isStackCreative(stack);
	}

	@Override
	public float getManaFractionForDisplay(class_1799 stack) {
		return (float) getMana(stack) / (float) getMaxMana(stack);
	}

	@Override
	public boolean showDurability(class_1799 stack) {
		return !isStackCreative(stack);
	}

	@Override
	public double getDurability(class_1799 stack) {
		return 1 - getManaFractionForDisplay(stack);
	}

	@Override
	public int getDurabilityColor(class_1799 stack) {
		return class_3532.method_15369(getManaFractionForDisplay(stack) / 3.0F, 1.0F, 1.0F);
	}
}
