/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3419;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IManaTooltipDisplay;
import vazkii.botania.api.wand.ICoordBoundItem;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import java.util.Optional;

public class ItemManaMirror extends class_1792 implements IManaItem, ICoordBoundItem, IManaTooltipDisplay, IDurabilityExtension {

	private static final String TAG_MANA = "mana";
	private static final String TAG_MANA_BACKLOG = "manaBacklog";
	private static final String TAG_POS = "pos";

	private static final DummyPool fallbackPool = new DummyPool();

	public ItemManaMirror(class_1793 props) {
		super(props);
	}

	@Override
	public boolean showDurability(class_1799 stack) {
		return true;
	}

	@Override
	public double getDurability(class_1799 stack) {
		return 1 - getManaFractionForDisplay(stack);
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
		if (world.field_9236) {
			return;
		}

		IManaPool pool = getManaPool(world.method_8503(), stack);
		if (!(pool instanceof DummyPool)) {
			if (pool == null) {
				setMana(stack, 0);
			} else {
				pool.receiveMana(getManaBacklog(stack));
				setManaBacklog(stack, 0);
				setMana(stack, pool.getCurrentMana());
			}
		}
	}

	@Nonnull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_1657 player = ctx.method_8036();

		if (player != null && player.method_5715() && !world.field_9236) {
			class_2586 tile = world.method_8321(ctx.method_8037());
			if (tile instanceof IManaPool) {
				bindPool(ctx.method_8041(), tile);
				world.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), ModSounds.ding, class_3419.field_15248, 1F, 1F);
				return class_1269.field_5812;
			}
		}

		return class_1269.field_5811;
	}

	@Override
	public int getMana(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_MANA, 0);
	}

	public void setMana(class_1799 stack, int mana) {
		ItemNBTHelper.setInt(stack, TAG_MANA, Math.max(0, mana));
	}

	public int getManaBacklog(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_MANA_BACKLOG, 0);
	}

	public void setManaBacklog(class_1799 stack, int backlog) {
		ItemNBTHelper.setInt(stack, TAG_MANA_BACKLOG, backlog);
	}

	@Override
	public int getMaxMana(class_1799 stack) {
		return TilePool.MAX_MANA;
	}

	@Override
	public void addMana(class_1799 stack, int mana) {
		setMana(stack, getMana(stack) + mana);
		setManaBacklog(stack, getManaBacklog(stack) + mana);
	}

	public void bindPool(class_1799 stack, class_2586 pool) {
		class_4208 pos = class_4208.method_19443(pool.method_10997().method_27983(), pool.method_11016());
		class_2520 ser = class_4208.field_25066.encodeStart(class_2509.field_11560, pos).get().orThrow();
		ItemNBTHelper.set(stack, TAG_POS, ser);
	}

	@Nullable
	private static class_4208 getBoundPos(class_1799 stack) {
		if (!stack.method_7948().method_10545(TAG_POS)) {
			return null;
		}

		Optional<class_4208> pos = class_4208.field_25066.parse(class_2509.field_11560, ItemNBTHelper.get(stack, TAG_POS)).result();
		if (!pos.isPresent()) {
			return null;
		}

		class_2338 coords = pos.get().method_19446();
		if (coords.method_10264() == -1) {
			return null;
		}
		return pos.get();
	}

	@Nullable
	private IManaPool getManaPool(@Nullable MinecraftServer server, class_1799 stack) {
		if (server == null) {
			return fallbackPool;
		}

		class_4208 pos = getBoundPos(stack);
		if (pos == null) {
			return fallbackPool;
		}

		class_5321<class_1937> type = pos.method_19442();
		class_1937 world = server.method_3847(type);
		if (world != null) {
			class_2586 tile = world.method_8321(pos.method_19446());
			if (tile instanceof IManaPool) {
				return (IManaPool) tile;
			}
		}

		return null;
	}

	@Override
	public boolean canReceiveManaFromPool(class_1799 stack, class_2586 pool) {
		return false;
	}

	@Override
	public boolean canReceiveManaFromItem(class_1799 stack, class_1799 otherStack) {
		return false;
	}

	@Override
	public boolean canExportManaToPool(class_1799 stack, class_2586 pool) {
		return false;
	}

	@Override
	public boolean canExportManaToItem(class_1799 stack, class_1799 otherStack) {
		return true;
	}

	private static class DummyPool implements IManaPool {

		@Override
		public boolean isFull() {
			return false;
		}

		@Override
		public void receiveMana(int mana) {}

		@Override
		public boolean canReceiveManaFromBursts() {
			return false;
		}

		@Override
		public int getCurrentMana() {
			return 0;
		}

		@Override
		public boolean isOutputtingPower() {
			return false;
		}

		@Override
		public class_1767 getColor() {
			return class_1767.field_7952;
		}

		@Override
		public void setColor(class_1767 color) {}

	}

	@Override
	public boolean isNoExport(class_1799 stack) {
		return false;
	}

	@Nullable
	@Override
	public class_2338 getBinding(class_1937 world, class_1799 stack) {
		class_4208 pos = getBoundPos(stack);
		if (pos == null) {
			return null;
		}

		if (pos.method_19442() == world.method_27983()) {
			return pos.method_19446();
		}

		return null;
	}

	@Override
	public float getManaFractionForDisplay(class_1799 stack) {
		return (float) getMana(stack) / (float) getMaxMana(stack);
	}

}
