/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.client.core.handler.TooltipHandler;
import vazkii.botania.common.advancements.ManaGunTrigger;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.entity.EntityManaBurst;

import javax.annotation.Nonnull;

import java.util.ArrayList;
import java.util.List;

public class ItemManaGun extends class_1792 implements IManaUsingItem, IDurabilityExtension {

	private static final String TAG_LENS = "lens";
	private static final String TAG_CLIP = "clip";
	private static final String TAG_CLIP_POS = "clipPos";
	private static final String TAG_COOLDOWN = "cooldown";

	private static final int CLIP_SLOTS = 6;
	private static final int COOLDOWN = 30;

	public ItemManaGun(class_1793 props) {
		super(props);
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		int effCd = COOLDOWN;
		class_1293 effect = player.method_6112(class_1294.field_5917);
		if (effect != null) {
			effCd -= (effect.method_5578() + 1) * 8;
		}

		if (player.method_5715() && hasClip(stack)) {
			rotatePos(stack);
			world.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14791, class_3419.field_15248, 0.6F, (1.0F + (world.field_9229.nextFloat() - world.field_9229.nextFloat()) * 0.2F) * 0.7F);
			if (!world.field_9236) {
				class_1799 lens = getLens(stack);
				ItemsRemainingRenderHandler.send(player, lens, -2);
				setCooldown(stack, effCd);
			}
			return class_1271.method_29237(stack, world.field_9236);
		} else if (getCooldown(stack) == 0) {
			EntityManaBurst burst = getBurst(player, stack, true, hand);
			if (burst != null && ManaItemHandler.instance().requestManaExact(stack, player, burst.getMana(), true)) {
				if (!world.field_9236) {
					world.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), ModSounds.manaBlaster, class_3419.field_15248, 0.6F, 1);
					world.method_8649(burst);
					ManaGunTrigger.INSTANCE.trigger((class_3222) player, stack);
					setCooldown(stack, effCd);
				} else {
					player.method_18799(player.method_18798().method_1020(burst.method_18798().method_18805(0.1, 0.3, 0.1)));
				}
			} else if (!world.field_9236) {
				world.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14962, class_3419.field_15248, 0.6F, (1.0F + (world.field_9229.nextFloat() - world.field_9229.nextFloat()) * 0.2F) * 0.7F);
			}
			return class_1271.method_29237(stack, world.field_9236);
		}

		return class_1271.method_22430(stack);
	}

	// ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN
	// ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN
	// ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN
	// ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN
	// ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN
	// ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN
	// ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN
	// ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN
	// ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN
	// ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN
	// ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN
	// ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN
	// ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN
	// ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN ASADA-SAN
	public static boolean isSugoiKawaiiDesuNe(class_1799 stack) {
		return stack.method_7964().getString().equalsIgnoreCase("desu gun");
	}

	@Nonnull
	public BurstProperties getBurstProps(class_1657 player, class_1799 stack, boolean request, class_1268 hand) {
		int maxMana = 120;
		int color = 0x20FF20;
		int ticksBeforeManaLoss = 60;
		float manaLossPerTick = 4F;
		float motionModifier = 5F;
		float gravity = 0F;
		BurstProperties props = new BurstProperties(maxMana, ticksBeforeManaLoss, manaLossPerTick, gravity, motionModifier, color);

		class_1799 lens = getLens(stack);
		if (!lens.method_7960()) {
			((ILens) lens.method_7909()).apply(lens, props);
		}
		return props;
	}

	private EntityManaBurst getBurst(class_1657 player, class_1799 stack, boolean request, class_1268 hand) {
		EntityManaBurst burst = new EntityManaBurst(player);
		BurstProperties props = getBurstProps(player, stack, request, hand);

		burst.setSourceLens(getLens(stack));
		if (!request || ManaItemHandler.instance().requestManaExact(stack, player, props.maxMana, false)) {
			burst.setColor(props.color);
			burst.setMana(props.maxMana);
			burst.setStartingMana(props.maxMana);
			burst.setMinManaLoss(props.ticksBeforeManaLoss);
			burst.setManaLossPerTick(props.manaLossPerTick);
			burst.setGravity(props.gravity);
			burst.setBurstMotion(burst.method_18798().method_10216() * props.motionModifier,
					burst.method_18798().method_10214() * props.motionModifier,
					burst.method_18798().method_10215() * props.motionModifier);

			return burst;
		}
		return null;
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flags) {
		boolean clip = hasClip(stack);
		if (clip && !class_437.method_25442()) {
			tooltip.add(TooltipHandler.getShiftInfoTooltip());
			return;
		}

		class_1799 lens = getLens(stack);
		if (!lens.method_7960()) {
			List<class_2561> lensTip = lens.method_7950(class_310.method_1551().field_1724, class_1836.class_1837.field_8934);
			if (lensTip.size() > 1) {
				tooltip.addAll(lensTip.subList(1, lensTip.size()));
			}
		}

		if (clip) {
			int pos = getClipPos(stack);
			tooltip.add(new class_2588("botaniamisc.hasClip"));
			for (int i = 0; i < CLIP_SLOTS; i++) {
				class_1799 lensAt = getLensAtPos(stack, i);

				class_2561 name;
				if (lensAt.method_7960()) {
					name = new class_2588("botaniamisc.clipEmpty");
				} else {
					name = lensAt.method_7964();
				}

				class_5250 tip = new class_2585(" - ").method_10852(name);
				tip.method_27692(i == pos ? class_124.field_1060 : class_124.field_1080);
				tooltip.add(tip);
			}
		}
	}

	@Nonnull
	@Override
	public class_2561 method_7864(@Nonnull class_1799 stack) {
		class_1799 lens = getLens(stack);
		class_5250 cmp = super.method_7864(stack).method_27661();
		if (!lens.method_7960()) {
			cmp.method_27693(" (");
			cmp.method_10852(lens.method_7964().method_27661().method_27692(class_124.field_1060));
			cmp.method_27693(")");
		}
		return cmp;
	}

	public static boolean hasClip(class_1799 stack) {
		return ItemNBTHelper.getBoolean(stack, TAG_CLIP, false);
	}

	public static void setClip(class_1799 stack, boolean clip) {
		ItemNBTHelper.setBoolean(stack, TAG_CLIP, clip);
	}

	public static int getClipPos(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_CLIP_POS, 0);
	}

	public static void setClipPos(class_1799 stack, int pos) {
		ItemNBTHelper.setInt(stack, TAG_CLIP_POS, pos);
	}

	public static void rotatePos(class_1799 stack) {
		int currPos = getClipPos(stack);
		boolean acceptEmpty = !getLensAtPos(stack, currPos).method_7960();
		int[] slots = new int[CLIP_SLOTS - 1];

		int index = 0;
		for (int i = currPos + 1; i < CLIP_SLOTS; i++, index++) {
			slots[index] = i;
		}
		for (int i = 0; i < currPos; i++, index++) {
			slots[index] = i;
		}

		for (int i : slots) {
			class_1799 lensAt = getLensAtPos(stack, i);
			if (acceptEmpty || !lensAt.method_7960()) {
				setClipPos(stack, i);
				return;
			}
		}
	}

	public static class_1799 getLensAtPos(class_1799 stack, int pos) {
		class_2487 cmp = ItemNBTHelper.getCompound(stack, TAG_LENS + pos, true);
		if (cmp != null) {
			return class_1799.method_7915(cmp);
		}
		return class_1799.field_8037;
	}

	public static void setLensAtPos(class_1799 stack, class_1799 lens, int pos) {
		class_2487 cmp = new class_2487();
		if (lens != null) {
			cmp = lens.method_7953(cmp);
		}
		ItemNBTHelper.setCompound(stack, TAG_LENS + pos, cmp);
	}

	public static void setLens(class_1799 stack, class_1799 lens) {
		if (hasClip(stack)) {
			setLensAtPos(stack, lens, getClipPos(stack));
		}

		class_2487 cmp = new class_2487();
		if (!lens.method_7960()) {
			cmp = lens.method_7953(cmp);
		}
		ItemNBTHelper.setCompound(stack, TAG_LENS, cmp);
	}

	public static class_1799 getLens(class_1799 stack) {
		if (hasClip(stack)) {
			return getLensAtPos(stack, getClipPos(stack));
		}

		class_2487 cmp = ItemNBTHelper.getCompound(stack, TAG_LENS, true);
		if (cmp != null) {
			return class_1799.method_7915(cmp);
		}
		return class_1799.field_8037;
	}

	public static List<class_1799> getAllLens(class_1799 stack) {
		List<class_1799> ret = new ArrayList<>();

		for (int i = 0; i < 6; i++) {
			ret.add(getLensAtPos(stack, i));
		}

		return ret;
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
		if (getCooldown(stack) > 0) {
			setCooldown(stack, getCooldown(stack) - 1);
		}
	}

	@Override
	public boolean showDurability(class_1799 stack) {
		return getCooldown(stack) > 0;
	}

	@Override
	public double getDurability(class_1799 stack) {
		return getCooldown(stack) / (double) COOLDOWN;
	}

	private int getCooldown(class_1799 stack) {
		return stack.method_7948().method_10550(TAG_COOLDOWN);
	}

	private void setCooldown(class_1799 stack, int cooldown) {
		class_2487 tag = stack.method_7948();
		tag.method_10569(TAG_COOLDOWN, cooldown);
	}

	@Override
	public boolean usesMana(class_1799 stack) {
		return true;
	}
}
