/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import vazkii.botania.api.recipe.IElvenItem;
import vazkii.botania.client.core.handler.TooltipHandler;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.patchouli.api.PatchouliAPI;

import javax.annotation.Nonnull;

import java.util.List;

public class ItemLexicon extends class_1792 implements IElvenItem {

	public static final String TAG_ELVEN_UNLOCK = "botania:elven_unlock";

	public ItemLexicon(class_1793 props) {
		super(props);
	}

	public static boolean isOpen() {
		return class_2378.field_11142.method_10221(ModItems.lexicon).equals(PatchouliAPI.get().getOpenBookGui());
	}

	@Override
	public void method_7850(@Nonnull class_1761 tab, @Nonnull class_2371<class_1799> list) {
		if (method_7877(tab)) {
			list.add(new class_1799(this));
			class_1799 creative = new class_1799(this);
			creative.method_7948().method_10556(TAG_ELVEN_UNLOCK, true);
			list.add(creative);
		}
	}

	@Override
	@Environment(EnvType.CLIENT)
	public void method_7851(class_1799 stack, class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
		super.method_7851(stack, worldIn, tooltip, flagIn);

		TooltipHandler.addOnShift(tooltip, () -> {
			tooltip.add(getEdition().method_27661().method_27692(class_124.field_1080));
		});
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
		class_1799 stack = playerIn.method_5998(handIn);

		if (playerIn instanceof class_3222) {
			class_3222 player = (class_3222) playerIn;
			UseItemSuccessTrigger.INSTANCE.trigger(player, stack, player.method_14220(), player.method_23317(), player.method_23318(), player.method_23321());
			PatchouliAPI.get().openBookGUI((class_3222) playerIn, class_2378.field_11142.method_10221(this));
			playerIn.method_5783(ModSounds.lexiconOpen, 1F, (float) (0.7 + Math.random() * 0.4));
		}

		return new class_1271<>(class_1269.field_5812, stack);
	}

	public static class_2561 getEdition() {
		return PatchouliAPI.get().getSubtitle(class_2378.field_11142.method_10221(ModItems.lexicon));
	}

	public static class_2561 getTitle(class_1799 stack) {
		class_2561 title = stack.method_7964();

		String akashicTomeNBT = "akashictome:displayName";
		if (stack.method_7985() && stack.method_7969().method_10545(akashicTomeNBT)) {
			title = new class_2585(stack.method_7969().method_10558(akashicTomeNBT));
		}

		return title;
	}

	@Override
	public boolean isElvenItem(class_1799 stack) {
		return stack.method_7985() && stack.method_7969().method_10577(TAG_ELVEN_UNLOCK);
	}

	// Random item to expose this as public
	public static class_3965 doRayTrace(class_1937 world, class_1657 player, class_3959.class_242 fluidMode) {
		return class_1792.method_7872(world, player, fluidMode);
	}
}
