/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.block.*;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2346;
import net.minecraft.class_2371;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ILaputaImmobile;
import vazkii.botania.api.mana.ILensEffect;
import vazkii.botania.api.mana.ITinyPlanetExcempt;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.entity.ModEntities;

import javax.annotation.Nonnull;

import java.util.List;

public class ItemLaputaShard extends class_1792 implements ILensEffect, ITinyPlanetExcempt {

	private static final String TAG_STATE = "_state";
	private static final String TAG_TILE = "_tile";
	private static final String TAG_X = "_x";
	private static final String TAG_Y = "_y";
	private static final String TAG_Y_START = "_yStart";
	private static final String TAG_Z = "_z";
	private static final String TAG_POINTY = "_pointy";
	private static final String TAG_HEIGHTSCALE = "_heightscale";
	private static final String TAG_ITERATION_I = "iterationI";
	private static final String TAG_ITERATION_J = "iterationJ";
	private static final String TAG_ITERATION_K = "iterationK";
	public static final String TAG_LEVEL = "level";

	private static final int BASE_RANGE = 14;
	private static final int BASE_OFFSET = 42;

	public ItemLaputaShard(class_1793 props) {
		super(props);
	}

	@Override
	public void method_7850(@Nonnull class_1761 tab, @Nonnull class_2371<class_1799> list) {
		if (method_7877(tab)) {
			for (int i = 0; i <= 20; i += 5) {
				class_1799 s = new class_1799(this);
				if (i != 0) {
					s.method_7948().method_10569(TAG_LEVEL, i - 1);
				}
				list.add(s);
			}
		}
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> list, class_1836 flags) {
		int level = getShardLevel(stack);
		class_2561 levelLoc = new class_2588("botania.roman" + (level + 1));
		list.add(new class_2588("botaniamisc.shardLevel", levelLoc).method_27692(class_124.field_1080));
	}

	@Nonnull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_2338 pos = ctx.method_8037();
		if (!world.field_9236 && pos.method_10264() < 160 && !world.method_8597().method_27999()) {
			world.method_8396(null, pos, ModSounds.laputaStart, class_3419.field_15245, 1.0F + world.field_9229.nextFloat(), world.field_9229.nextFloat() * 0.7F + 1.3F);
			class_1799 stack = ctx.method_8041();
			spawnBurstFirst(world, pos, stack);
			if (ctx.method_8036() != null) {
				UseItemSuccessTrigger.INSTANCE.trigger((class_3222) ctx.method_8036(), stack, (class_3218) world, pos.method_10263(), pos.method_10264(), pos.method_10260());
			}
			stack.method_7934(1);
		}

		return class_1269.field_5812;
	}

	public void spawnBurstFirst(class_1937 world, class_2338 pos, class_1799 shard) {
		int range = BASE_RANGE + getShardLevel(shard);
		boolean pointy = world.field_9229.nextDouble() < 0.25;
		double heightscale = (world.field_9229.nextDouble() + 0.5) * ((double) BASE_RANGE / (double) range);
		spawnBurst(world, pos, shard, pointy, heightscale);
	}

	public void spawnBurst(class_1937 world, class_2338 pos, class_1799 lens) {
		boolean pointy = ItemNBTHelper.getBoolean(lens, TAG_POINTY, false);
		double heightscale = ItemNBTHelper.getDouble(lens, TAG_HEIGHTSCALE, 1);

		spawnBurst(world, pos, lens, pointy, heightscale);
	}

	private static boolean canMove(class_2680 state, class_1937 world, class_2338 pos) {
		class_3610 fluidState = state.method_26227();
		boolean isFlowingFluid = !fluidState.method_15769() && !fluidState.method_15771();
		class_2248 block = state.method_26204();

		return !state.method_26215()
				&& !isFlowingFluid
				&& !(block instanceof class_2346)
				&& (!(block instanceof ILaputaImmobile) || ((ILaputaImmobile) block).canMove(world, pos))
				&& state.method_26214(world, pos) != -1;
	}

	public void spawnBurst(class_1937 world, class_2338 pos, class_1799 shard, boolean pointy, double heightscale) {
		int range = BASE_RANGE + getShardLevel(shard);

		int i = ItemNBTHelper.getInt(shard, TAG_ITERATION_I, 0);
		int j = ItemNBTHelper.getInt(shard, TAG_ITERATION_J, BASE_OFFSET - BASE_RANGE / 2);
		int k = ItemNBTHelper.getInt(shard, TAG_ITERATION_K, 0);

		if (j <= -BASE_RANGE * 2) {
			j = BASE_OFFSET - BASE_RANGE / 2;
		}
		if (k >= range * 2 + 1) {
			k = 0;
		}

		if (!world.field_9236) {
			for (; i < range * 2 + 1; i++) {
				for (; j > -BASE_RANGE * 2; j--) {
					for (; k < range * 2 + 1; k++) {
						class_2338 pos_ = pos.method_10069(-range + i, -BASE_RANGE + j, -range + k);

						if (inRange(pos_, pos, range, heightscale, pointy)) {
							class_2680 state = world.method_8320(pos_);
							class_2248 block = state.method_26204();
							if (canMove(state, world, pos_)) {
								class_2586 tile = world.method_8321(pos_);

								if (tile != null && block instanceof class_2343) {
									// Reset the TE so e.g. chests don't spawn their drops
									class_2586 newTile = ((class_2343) block).method_10123(world);
									world.method_8526(pos_, newTile);
								}
								world.method_20290(2001, pos_, class_2248.method_9507(state));
								world.method_8501(pos_, class_2246.field_10124.method_9564());

								class_1799 copyLens = new class_1799(this);
								copyLens.method_7948().method_10569(TAG_LEVEL, getShardLevel(shard));
								copyLens.method_7969().method_10566(TAG_STATE, class_2512.method_10686(state));
								class_2487 cmp = new class_2487();
								if (tile != null) {
									cmp = tile.method_11007(cmp);
								}
								ItemNBTHelper.setCompound(copyLens, TAG_TILE, cmp);
								ItemNBTHelper.setInt(copyLens, TAG_X, pos.method_10263());
								ItemNBTHelper.setInt(copyLens, TAG_Y, pos.method_10264());
								ItemNBTHelper.setInt(copyLens, TAG_Y_START, pos_.method_10264());
								ItemNBTHelper.setInt(copyLens, TAG_Z, pos.method_10260());
								ItemNBTHelper.setBoolean(copyLens, TAG_POINTY, pointy);
								ItemNBTHelper.setDouble(copyLens, TAG_HEIGHTSCALE, heightscale);
								ItemNBTHelper.setInt(copyLens, TAG_ITERATION_I, i);
								ItemNBTHelper.setInt(copyLens, TAG_ITERATION_J, j);
								ItemNBTHelper.setInt(copyLens, TAG_ITERATION_K, k);

								EntityManaBurst burst = getBurst(world, pos_, copyLens);
								world.method_8649(burst);
								return;
							}
						}
					}
					k = 0;
				}
				j = BASE_OFFSET - BASE_RANGE / 2;
			}
		}
	}

	public static int getShardLevel(class_1799 shard) {
		if (!shard.method_7985()) {
			return 0;
		}
		return shard.method_7948().method_10550(TAG_LEVEL);
	}

	private boolean inRange(class_2338 pos, class_2338 srcPos, int range, double heightscale, boolean pointy) {
		if (pos.method_10264() >= srcPos.method_10264()) {
			return MathHelper.pointDistanceSpace(pos.method_10263(), 0, pos.method_10260(), srcPos.method_10263(), 0, srcPos.method_10260()) < range;
		} else if (!pointy) {
			return MathHelper.pointDistanceSpace(pos.method_10263(), pos.method_10264() / heightscale, pos.method_10260(), srcPos.method_10263(), srcPos.method_10264() / heightscale, srcPos.method_10260()) < range;
		} else {
			return MathHelper.pointDistanceSpace(pos.method_10263(), 0, pos.method_10260(), srcPos.method_10263(), 0, srcPos.method_10260()) < range - (srcPos.method_10264() - pos.method_10264()) / heightscale;
		}
	}

	public EntityManaBurst getBurst(class_1937 world, class_2338 pos, class_1799 stack) {
		EntityManaBurst burst = ModEntities.MANA_BURST.method_5883(world);
		burst.method_5814(pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5);

		burst.setColor(0x00EAFF);
		burst.setMana(1);
		burst.setStartingMana(1);
		burst.setMinManaLoss(0);
		burst.setManaLossPerTick(0F);
		burst.setGravity(0F);
		burst.setBurstMotion(0, 0.5, 0);

		burst.setSourceLens(stack);
		return burst;
	}

	@Override
	public void apply(class_1799 stack, BurstProperties props) {}

	@Override
	public boolean collideBurst(IManaBurst burst, class_239 pos, boolean isManaBlock, boolean dead, class_1799 stack) {
		return false;
	}

	@Override
	public void updateBurst(IManaBurst burst, class_1799 stack) {
		double speed = 0.35;
		int targetDistance = BASE_OFFSET;
		class_1297 entity = burst.entity();
		if (!entity.field_6002.field_9236) {
			entity.method_18800(0, speed, 0);

			final int spawnTicks = 2;
			final int placeTicks = net.minecraft.class_3532.method_15357(targetDistance / speed);

			class_1799 lens = burst.getSourceLens();

			if (burst.getTicksExisted() == spawnTicks) {
				int x = ItemNBTHelper.getInt(lens, TAG_X, 0);
				int y = ItemNBTHelper.getInt(lens, TAG_Y, -1);
				int z = ItemNBTHelper.getInt(lens, TAG_Z, 0);

				if (y != -1) {
					spawnBurst(entity.field_6002, new class_2338(x, y, z), lens);
				}
			} else if (burst.getTicksExisted() == placeTicks) {
				int x = net.minecraft.class_3532.method_15357(entity.method_23317());
				int y = ItemNBTHelper.getInt(lens, TAG_Y_START, -1) + targetDistance;
				int z = net.minecraft.class_3532.method_15357(entity.method_23321());
				class_2338 pos = new class_2338(x, y, z);

				class_2680 placeState = class_2246.field_10124.method_9564();
				if (lens.method_7985() && lens.method_7969().method_10545(TAG_STATE)) {
					placeState = class_2512.method_10681(lens.method_7969().method_10562(TAG_STATE));
				}

				if (entity.field_6002.method_8597().method_27999() && placeState.method_28498(class_2741.field_12508)) {
					placeState = placeState.method_11657(class_2741.field_12508, false);
				}

				if (entity.field_6002.method_8320(pos).method_26207().method_15800()) {
					class_2586 tile = null;
					class_2487 tilecmp = ItemNBTHelper.getCompound(lens, TAG_TILE, false);
					if (tilecmp.method_10545("id")) {
						tile = class_2586.method_11005(placeState, tilecmp);
					}

					entity.field_6002.method_8501(pos, placeState);
					entity.field_6002.method_20290(2001, pos, class_2248.method_9507(placeState));
					if (tile != null) {
						tile.method_10998(pos);
						entity.field_6002.method_8526(pos, tile);
					}
				} else {
					int ox = ItemNBTHelper.getInt(lens, TAG_X, 0);
					int oy = ItemNBTHelper.getInt(lens, TAG_Y_START, -1);
					int oz = ItemNBTHelper.getInt(lens, TAG_Z, 0);
					class_2248.method_9497(placeState, entity.field_6002, new class_2338(ox, oy, oz));
				}

				entity.method_5650();
			}
		}
	}

	@Override
	public boolean doParticles(IManaBurst burst, class_1799 stack) {
		class_1297 entity = burst.entity();
		class_1799 lens = burst.getSourceLens();
		class_2680 state = class_2512.method_10681(lens.method_7948().method_10562(TAG_STATE));
		entity.field_6002.method_8406(new class_2388(class_2398.field_11217, state), entity.method_23317(), entity.method_23318(), entity.method_23321(),
				entity.method_18798().method_10216(), entity.method_18798().method_10214(), entity.method_18798().method_10215());

		return true;
	}

	@Override
	public boolean shouldPull(class_1799 stack) {
		return false;
	}

}
