/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import vazkii.botania.common.components.EntityComponents;
import vazkii.botania.common.components.KeptItemsComponent;
import vazkii.botania.common.core.helper.ItemNBTHelper;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3222;

public class ItemKeepIvy extends class_1792 {

	public static final String TAG_KEEP = "Botania_keepIvy";

	public static final String TAG_PLAYER_KEPT_DROPS = "Botania_playerKeptDrops";
	private static final String TAG_DROP_COUNT = "dropCount";
	private static final String TAG_DROP_PREFIX = "dropPrefix";

	public ItemKeepIvy(class_1793 props) {
		super(props);
	}

	public static boolean hasIvy(class_1799 stack) {
		return !stack.method_7960() && stack.method_7985() && ItemNBTHelper.getBoolean(stack, TAG_KEEP, false);
	}

	// Curios are handled in CurioIntegration#keepCurioDrops
	public static void onPlayerDrops(class_1657 player) {
		List<class_1799> keeps = new ArrayList<>();
		for (int i = 0; i < player.field_7514.method_5439(); i++) {
			class_1799 stack = player.field_7514.method_5438(i);
			if (!stack.method_7960() && stack.method_7985() && ItemNBTHelper.getBoolean(stack, TAG_KEEP, false)) {
				keeps.add(stack);
				player.field_7514.method_5447(i, class_1799.field_8037);
			}
		}

		if (keeps.size() > 0) {
			KeptItemsComponent data = EntityComponents.KEPT_ITEMS.get(player);
			data.addAll(keeps);
		}
	}

	public static void onPlayerRespawn(class_3222 oldPlayer, class_3222 newPlayer, boolean alive) {
		if (!alive) {
			KeptItemsComponent keeps = EntityComponents.KEPT_ITEMS.get(oldPlayer);

			for (class_1799 stack : keeps.getStacks()) {
				class_1799 copy = stack.method_7972();
				copy.method_7983(TAG_KEEP);
				if (!newPlayer.field_7514.method_7394(copy)) {
					newPlayer.method_5775(copy);
				}
			}
		}
	}

}
