/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import vazkii.botania.api.item.IHornHarvestable;
import vazkii.botania.api.item.IHornHarvestable.EnumHornType;
import vazkii.botania.common.lib.ModTags;

import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ItemHorn extends class_1792 {
	public ItemHorn(class_1793 props) {
		super(props);
	}

	@Nonnull
	@Override
	public class_1839 method_7853(class_1799 stack) {
		return class_1839.field_8953;
	}

	@Override
	public int method_7881(class_1799 stack) {
		return 72000;
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
		player.method_6019(hand);
		return class_1271.method_22428(player.method_5998(hand));
	}

	@Override
	public void method_7852(class_1937 world, @Nonnull class_1309 player, @Nonnull class_1799 stack, int time) {
		if (!world.field_9236) {
			if (time != method_7881(stack) && time % 5 == 0) {
				breakGrass(world, stack, player.method_24515());
			}
			world.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14624, class_3419.field_15245, 1F, 0.001F);
		}
	}

	public static void breakGrass(class_1937 world, class_1799 stack, class_2338 srcPos) {
		EnumHornType type = null;
		if (stack.method_7909() == ModItems.grassHorn) {
			type = EnumHornType.WILD;
		} else if (stack.method_7909() == ModItems.leavesHorn) {
			type = EnumHornType.CANOPY;
		} else if (stack.method_7909() == ModItems.snowHorn) {
			type = EnumHornType.COVERING;
		}

		int range = 12 - type.ordinal() * 3;
		int rangeY = 3 + type.ordinal() * 4;
		List<class_2338> coords = new ArrayList<>();

		for (class_2338 pos : class_2338.method_10097(srcPos.method_10069(-range, -rangeY, -range),
				srcPos.method_10069(range, rangeY, range))) {
			class_2248 block = world.method_8320(pos).method_26204();
			if (block instanceof IHornHarvestable
					? ((IHornHarvestable) block).canHornHarvest(world, pos, stack, type)
					: type == EnumHornType.WILD && block instanceof class_2261 && !block.method_9525(ModTags.Blocks.SPECIAL_FLOWERS)
							|| type == EnumHornType.CANOPY && class_3481.field_15503.method_15141(block)
							|| type == EnumHornType.COVERING && block == class_2246.field_10477) {
				coords.add(pos.method_10062());
			}
		}

		Collections.shuffle(coords, world.field_9229);

		int count = Math.min(coords.size(), 32 + type.ordinal() * 16);
		for (int i = 0; i < count; i++) {
			class_2338 currCoords = coords.get(i);
			class_2680 state = world.method_8320(currCoords);
			class_2248 block = state.method_26204();

			if (block instanceof IHornHarvestable && ((IHornHarvestable) block).hasSpecialHornHarvest(world, currCoords, stack, type)) {
				((IHornHarvestable) block).harvestByHorn(world, currCoords, stack, type);
			} else {
				world.method_22352(currCoords, true);
			}
		}
	}

}
