/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1277;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2614;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.util.*;
import vazkii.botania.client.gui.bag.ContainerFlowerBag;
import vazkii.botania.common.block.BlockModFlower;

import javax.annotation.Nonnull;

public class ItemFlowerBag extends class_1792 {
	public static final int SIZE = 16;

	public ItemFlowerBag(class_1793 props) {
		super(props);
	}

	public static boolean isValid(int slot, class_1799 stack) {
		class_2248 blk = class_2248.method_9503(stack.method_7909());
		return !stack.method_7960()
				&& blk.getClass() == BlockModFlower.class
				&& slot == ((BlockModFlower) blk).color.method_7789();
	}

	public static class_1277 getInventory(class_1799 stack) {
		return new ItemBackedInventory(stack, SIZE) {
			@Override
			public boolean method_5437(int slot, @Nonnull class_1799 stack) {
				return method_5437(slot, stack);
			}
		};
	}

	public static boolean onPickupItem(class_1542 entity, class_1657 player) {
		class_1799 entityStack = entity.method_6983();
		if (class_2248.method_9503(entityStack.method_7909()) instanceof BlockModFlower && entityStack.method_7947() > 0) {
			int color = ((BlockModFlower) class_2248.method_9503(entityStack.method_7909())).color.method_7789();

			for (int i = 0; i < player.field_7514.method_5439(); i++) {
				if (i == player.field_7514.field_7545) {
					continue; // prevent item deletion
				}

				class_1799 bag = player.field_7514.method_5438(i);
				if (!bag.method_7960() && bag.method_7909() == ModItems.flowerBag) {
					class_1277 bagInv = getInventory(bag);
					class_1799 existing = bagInv.method_5438(color);
					int newCount = Math.min(existing.method_7947() + entityStack.method_7947(),
							Math.min(existing.method_7914(), bagInv.method_5444()));
					int numPickedUp = newCount - existing.method_7947();

					if (numPickedUp > 0) {
						if (existing.method_7960()) {
							bagInv.method_5447(color, entityStack.method_7971(numPickedUp));
						} else {
							existing.method_7933(numPickedUp);
							entityStack.method_7934(numPickedUp);
						}
						entity.method_6979(entityStack);
						bagInv.method_5431();

						player.method_6103(entity, numPickedUp);

						return true;
					}
				}
			}
		}
		return false;
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
		if (!world.field_9236) {
			class_1799 stack = player.method_5998(hand);
			class_3908 container = new ExtendedScreenHandlerFactory() {
				@Override
				public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
					buf.writeBoolean(hand == class_1268.field_5808);
				}

				@Override
				public class_2561 method_5476() {
					return stack.method_7964();
				}

				@Override
				public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
					return new ContainerFlowerBag(syncId, inv, stack);
				}
			};
			player.method_17355(container);
		}
		return class_1271.method_22427(player.method_5998(hand));
	}

	@Nonnull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_2338 pos = ctx.method_8037();
		class_2350 side = ctx.method_8038();

		class_2586 tile = world.method_8321(pos);
		if (tile != null) {
			if (!world.field_9236) {
				class_1263 tileInv;
				if (tile instanceof class_1263) {
					tileInv = (class_1263) tile;
				} else {
					return class_1269.field_5814;
				}

				class_1263 bagInv = getInventory(ctx.method_8041());
				for (int i = 0; i < bagInv.method_5439(); i++) {
					class_1799 flower = bagInv.method_5438(i);
					class_1799 rem = class_2614.method_11260(bagInv, tileInv, flower, side);
					bagInv.method_5447(i, rem);
				}

			}

			return class_1269.field_5812;
		}
		return class_1269.field_5811;
	}
}
