/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.ModBlocks;

import javax.annotation.Nonnull;
import net.minecraft.class_1269;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import java.util.ArrayList;
import java.util.List;

public class ItemFertilizer extends class_1792 {

	public ItemFertilizer(class_1793 props) {
		super(props);
	}

	@Nonnull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_2338 pos = ctx.method_8037();
		final int range = 3;
		if (!world.field_9236) {
			List<class_2338> validCoords = new ArrayList<>();

			for (int i = -range - 1; i < range; i++) {
				for (int j = -range - 1; j < range; j++) {
					for (int k = 2; k >= -2; k--) {
						class_2338 pos_ = pos.method_10069(i + 1, k + 1, j + 1);
						if (world.method_22347(pos_) && (!world.method_8597().method_27999() || pos_.method_10264() < 255)
								&& ModBlocks.whiteFlower.method_9564().method_26184(world, pos_)) {
							validCoords.add(pos_);
						}
					}
				}
			}

			int flowerCount = Math.min(validCoords.size(), world.field_9229.nextBoolean() ? 3 : 4);
			for (int i = 0; i < flowerCount; i++) {
				class_2338 coords = validCoords.get(world.field_9229.nextInt(validCoords.size()));
				validCoords.remove(coords);
				world.method_8501(coords, ModBlocks.getFlower(class_1767.method_7791(world.field_9229.nextInt(16))).method_9564());
			}
			ctx.method_8041().method_7934(1);
		} else {
			for (int i = 0; i < 15; i++) {
				double x = pos.method_10263() - range + world.field_9229.nextInt(range * 2 + 1) + Math.random();
				double y = pos.method_10264() + 1;
				double z = pos.method_10260() - range + world.field_9229.nextInt(range * 2 + 1) + Math.random();
				float red = (float) Math.random();
				float green = (float) Math.random();
				float blue = (float) Math.random();
				WispParticleData data = WispParticleData.wisp(0.15F + (float) Math.random() * 0.25F, red, green, blue, 1);
				world.method_8406(data, x, y, z, 0, (float) Math.random() * 0.1F - 0.05F, 0);
			}
		}

		return class_1269.field_5812;
	}
}
