/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.rod.ItemExchangeRod;

import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1707;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_3417;
import net.minecraft.class_747;

public class ItemEnderHand extends class_1792 implements IManaUsingItem, IBlockProvider {

	private static final int COST_PROVIDE = 5;
	private static final int COST_SELF = 250;
	private static final int COST_OTHER = 5000;

	public ItemEnderHand(class_1793 props) {
		super(props);
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		if (ManaItemHandler.instance().requestManaExact(stack, player, COST_SELF, false)) {
			if (!player.field_6002.field_9236) {
				player.method_17355(new class_747((windowId, playerInv, p) -> {
					return class_1707.method_19245(windowId, playerInv, p.method_7274());
				}, stack.method_7964()));
				ManaItemHandler.instance().requestManaExact(stack, player, COST_SELF, true);
			}
			player.method_5783(class_3417.field_14952, 1F, 1F);
			return class_1271.method_22427(stack);
		}
		return class_1271.method_22430(stack);
	}

	@Override
	public class_1269 method_7847(class_1799 stack, class_1657 player, class_1309 entity, class_1268 hand) {
		if (ConfigHandler.COMMON.enderPickpocketEnabled.getValue() && entity instanceof class_1657 && ManaItemHandler.instance().requestManaExact(stack, player, COST_OTHER, false)) {
			if (!player.field_6002.field_9236) {
				class_1657 other = (class_1657) entity;
				player.method_17355(new class_747((windowId, playerInv, p) -> {
					return class_1707.method_19245(windowId, playerInv, other.method_7274());
				}, stack.method_7964()));
			}
			ManaItemHandler.instance().requestManaExact(stack, player, COST_OTHER, true);
			player.method_5783(class_3417.field_14952, 1F, 1F);
			return class_1269.field_5812;
		}

		return class_1269.field_5811;
	}

	@Override
	public boolean usesMana(class_1799 stack) {
		return true;
	}

	@Override
	public boolean provideBlock(class_1657 player, class_1799 requestor, class_1799 stack, class_2248 block, boolean doit) {
		if (!requestor.method_7960() && requestor.method_7909() == this) {
			return false;
		}

		class_1799 istack = ItemExchangeRod.removeFromInventory(player, player.method_7274(), stack, block, false);
		if (!istack.method_7960()) {
			boolean mana = ManaItemHandler.instance().requestManaExact(stack, player, COST_PROVIDE, false);
			if (mana) {
				if (doit) {
					ManaItemHandler.instance().requestManaExact(stack, player, COST_PROVIDE, true);
					ItemExchangeRod.removeFromInventory(player, player.method_7274(), stack, block, true);
				}

				return true;
			}
		}

		return false;
	}

	@Override
	public int getBlockCount(class_1657 player, class_1799 requestor, class_1799 stack, class_2248 block) {
		if (!requestor.method_7960() && requestor.method_7909() == this) {
			return 0;
		}

		return ItemExchangeRod.getInventoryItemCount(player, player.method_7274(), stack, block);
	}

}
