/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.CratePattern;
import vazkii.botania.common.block.ModBlocks;

import javax.annotation.Nonnull;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class ItemCraftPattern extends class_1792 {
	public final CratePattern pattern;

	public ItemCraftPattern(CratePattern pattern, class_1793 props) {
		super(props);
		this.pattern = pattern;
	}

	@Nonnull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_2338 pos = ctx.method_8037();
		class_2680 state = world.method_8320(pos);

		if (state.method_26204() == ModBlocks.craftCrate) {
			if (pattern != state.method_11654(BotaniaStateProps.CRATE_PATTERN)) {
				world.method_8501(pos, state.method_11657(BotaniaStateProps.CRATE_PATTERN, this.pattern));
				return class_1269.field_5812;
			}
		}

		return class_1269.field_5811;
	}
}
