/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5328;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.entity.EntityPixie;

import javax.annotation.Nonnull;

import java.util.List;
import java.util.Random;

public class ItemBottledMana extends class_1792 {
	public static final int SWIGS = 6;
	private static final String TAG_SWIGS_LEFT = "swigsLeft";
	private static final String TAG_SEED = "randomSeed";

	public ItemBottledMana(class_1793 props) {
		super(props);
	}

	public void effect(class_1799 stack, class_1309 living, int id) {
		switch (id) {
		case 0: { // Random motion
			living.method_18800((Math.random() - 0.5) * 3, living.method_18798().method_10214(),
					(Math.random() - 0.5) * 3);
			break;
		}
		case 1: { // Water
			if (!living.field_6002.field_9236 && !living.field_6002.method_8597().method_27999()) {
				living.field_6002.method_8501(living.method_24515(), class_2246.field_10382.method_9564());
			}
			break;
		}
		case 2: { // Set on Fire
			if (!living.field_6002.field_9236) {
				living.method_5639(4);
			}
			break;
		}
		case 3: { // Mini Explosion
			if (!living.field_6002.field_9236) {
				living.field_6002.method_8437(null, living.method_23317(), living.method_23318(),
						living.method_23321(), 0.25F, class_1927.class_4179.field_18685);
			}
			break;
		}
		case 4: { // Mega Jump
			if (!living.field_6002.method_8597().method_27999()) {
				if (!living.field_6002.field_9236) {
					living.method_6092(new class_1293(class_1294.field_5907, 300, 5));
				}
				living.method_18800(living.method_18798().method_10216(), 6, living.method_18798().method_10215());
			}

			break;
		}
		case 5: { // Randomly set HP
			if (!living.field_6002.field_9236) {
				living.method_6033(living.field_6002.field_9229.nextInt(19) + 1);
			}
			break;
		}
		case 6: { // Lots O' Hearts
			if (!living.field_6002.field_9236) {
				living.method_6092(new class_1293(class_1294.field_5898, 20 * 60 * 2, 9));
			}
			break;
		}
		case 7: { // All your inventory is belong to us
			if (!living.field_6002.field_9236 && living instanceof class_1657) {
				class_1657 player = (class_1657) living;
				for (int i = 0; i < player.field_7514.method_5439(); i++) {
					class_1799 stackAt = player.field_7514.method_5438(i);
					if (stackAt != stack) {
						if (!stackAt.method_7960()) {
							player.method_5699(stackAt, 0);
						}
						player.field_7514.method_5447(i, class_1799.field_8037);
					}
				}
			}

			break;
		}
		case 8: { // Break your neck
			living.field_5965 = (float) Math.random() * 360F;
			living.field_6031 = (float) Math.random() * 180F;

			break;
		}
		case 9: { // Highest Possible
			int x = class_3532.method_15357(living.method_23317());
			int z = class_3532.method_15357(living.method_23321());
			for (int i = 256; i > 0; i--) {
				class_2680 state = living.field_6002.method_8320(new class_2338(x, i, z));
				if (!state.method_26215()) {
					if (living instanceof class_3222) {
						class_3222 mp = (class_3222) living;
						mp.field_13987.method_14363(living.method_23317(), i, living.method_23321(), living.field_6031, living.field_5965);
					}
					break;
				}
			}

			break;
		}
		case 10: { // HYPERSPEEEEEED
			if (!living.field_6002.field_9236) {
				living.method_6092(new class_1293(class_1294.field_5904, 60, 200));
			}
			break;
		}
		case 11: { // Night Vision
			if (!living.field_6002.field_9236) {
				living.method_6092(new class_1293(class_1294.field_5925, 6000, 0));
			}
			break;
		}
		case 12: { // ???
			if (!living.field_6002.field_9236) {
				// todo 1.16 pick something new
			}

			break;
		}
		case 13: { // Pixie Friend
			if (!living.field_6002.field_9236) {
				EntityPixie pixie = new EntityPixie(living.field_6002);
				pixie.method_5814(living.method_23317(), living.method_23318() + 1.5, living.method_23321());
				living.field_6002.method_8649(pixie);
			}
			break;
		}
		case 14: { // Nausea + Blindness :3
			if (!living.field_6002.field_9236) {
				living.method_6092(new class_1293(class_1294.field_5916, 160, 3));
				living.method_6092(new class_1293(class_1294.field_5919, 160, 0));
			}

			break;
		}
		case 15: { // Drop own Head
			if (!living.field_6002.field_9236 && living instanceof class_1657) {
				living.method_5643(class_1282.field_5846, living.method_6032() - 1);
				class_1799 skull = new class_1799(class_1802.field_8575);
				ItemNBTHelper.setString(skull, "SkullOwner", ((class_1657) living).method_7334().getName());
				living.method_5699(skull, 0);
			}
			break;
		}
		}
	}

	private void randomEffect(class_1309 player, class_1799 stack) {
		effect(stack, player, new Random(getSeed(stack)).nextInt(16));
	}

	private long getSeed(class_1799 stack) {
		long seed = ItemNBTHelper.getLong(stack, TAG_SEED, -1);
		if (seed == -1) {
			return randomSeed(stack);
		}
		return seed;
	}

	private long randomSeed(class_1799 stack) {
		long seed = Math.abs(field_8005.nextLong());
		ItemNBTHelper.setLong(stack, TAG_SEED, seed);
		return seed;
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> stacks, class_1836 flags) {
		stacks.add(new class_2588("botaniamisc.bottleTooltip"));
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
		return class_5328.method_29282(world, player, hand);
	}

	@Nonnull
	@Override
	public class_1799 method_7861(@Nonnull class_1799 stack, class_1937 world, class_1309 living) {
		randomEffect(living, stack);
		int left = getSwigsLeft(stack);
		if (left <= 1) {
			return new class_1799(class_1802.field_8469);
		} else {
			setSwigsLeft(stack, left - 1);
			randomSeed(stack);
			return stack;
		}
	}

	@Override
	public int method_7881(class_1799 stack) {
		return 20;
	}

	@Nonnull
	@Override
	public class_1839 method_7853(class_1799 stack) {
		return class_1839.field_8946;
	}

	public static int getSwigsLeft(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_SWIGS_LEFT, SWIGS);
	}

	private void setSwigsLeft(class_1799 stack, int swigs) {
		ItemNBTHelper.setInt(stack, TAG_SWIGS_LEFT, swigs);
	}

}
