/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import vazkii.botania.api.item.IManaDissolvable;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.network.PacketBotaniaEffect;

import java.util.List;

public class ItemBlackLotus extends class_1792 implements IManaDissolvable {

	private static final int MANA_PER = 8000;
	private static final int MANA_PER_T2 = 100000;

	public ItemBlackLotus(class_1793 props) {
		super(props);
	}

	@Override
	public boolean method_7886(class_1799 stack) {
		return stack.method_7909() == ModItems.blackerLotus;
	}

	@Override
	public void onDissolveTick(IManaPool pool, class_1799 stack, class_1542 item) {
		if (pool.isFull() || pool.getCurrentMana() == 0) {
			return;
		}

		class_2338 pos = pool.tileEntity().method_11016();
		boolean t2 = stack.method_7909() == ModItems.blackerLotus;

		if (!item.field_6002.field_9236) {
			pool.receiveMana(t2 ? MANA_PER_T2 : MANA_PER);
			stack.method_7934(1);
			PacketBotaniaEffect.sendNearby(item, PacketBotaniaEffect.EffectType.BLACK_LOTUS_DISSOLVE, pos.method_10263(), pos.method_10264() + 0.5, pos.method_10260());
		}

		item.method_5783(ModSounds.blackLotus, 0.5F, t2 ? 0.1F : 1F);
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> list, class_1836 flags) {
		list.add(new class_2588("botaniamisc.lotusDesc").method_27692(class_124.field_1080));
	}

}
