/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.util.*;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.PlayerHelper;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import java.util.List;

public class ItemBlackHoleTalisman extends class_1792 implements IBlockProvider {
	public static final String TAG_ACTIVE = "active";
	private static final String TAG_BLOCK_NAME = "blockName";
	private static final String TAG_BLOCK_COUNT = "blockCount";

	public ItemBlackHoleTalisman(class_1793 props) {
		super(props);
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		if (getBlock(stack) != null && player.method_5715()) {
			ItemNBTHelper.setBoolean(stack, TAG_ACTIVE, !ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, false));
			player.method_5783(class_3417.field_14627, 0.3F, 0.1F);
			return class_1271.method_22427(stack);
		}

		return class_1271.method_22430(stack);
	}

	@Nonnull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_2338 pos = ctx.method_8037();
		class_2350 side = ctx.method_8038();
		class_1657 player = ctx.method_8036();
		class_2680 state = world.method_8320(pos);
		class_1799 stack = ctx.method_8041();

		if (!state.method_26215() && setBlock(stack, state.method_26204())) {
			return class_1269.field_5812;
		} else {
			class_2248 bBlock = getBlock(stack);

			if (bBlock == null) {
				return class_1269.field_5811;
			}

			class_2586 tile = world.method_8321(pos);
			if (tile instanceof class_1263) {
				if (!world.field_9236) {
					class_1799 toAdd = new class_1799(bBlock);
					int maxSize = toAdd.method_7914();
					toAdd.method_7939(remove(stack, maxSize));
					class_1799 remainder = class_2614.method_11260(null, (class_1263) tile, toAdd, side);
					if (!remainder.method_7960()) {
						add(stack, remainder.method_7947());
					}
				}
				return class_1269.field_5812;
			} else {
				if (player == null || player.field_7503.field_7477 || getBlockCount(stack) > 0) {
					class_1799 toUse = new class_1799(bBlock);
					class_1269 result = PlayerHelper.substituteUse(ctx, toUse);

					if (result.method_23665()) {
						if (!world.field_9236) {
							remove(stack, 1);
							ItemsRemainingRenderHandler.send(player, toUse, getBlockCount(stack));
						}
						return result;
					}
				}
			}
		}

		return class_1269.field_5811;
	}

	@Override
	public void method_7888(class_1799 itemstack, class_1937 world, class_1297 entity, int slot, boolean selected) {
		class_2248 block = getBlock(itemstack);
		if (!entity.field_6002.field_9236 && ItemNBTHelper.getBoolean(itemstack, TAG_ACTIVE, false) && block != null && entity instanceof class_1657) {
			class_1657 player = (class_1657) entity;

			int highest = -1;
			int[] counts = new int[player.field_7514.method_5439() - player.field_7514.field_7548.size()];

			for (int i = 0; i < counts.length; i++) {
				class_1799 stack = player.field_7514.method_5438(i);
				if (stack.method_7960()) {
					continue;
				}

				if (block.method_8389() == stack.method_7909()) {
					counts[i] = stack.method_7947();
					if (highest == -1) {
						highest = i;
					} else {
						highest = counts[i] > counts[highest] && highest > 8 ? i : highest;
					}
				}
			}

			if (highest == -1) {
				/*ItemStack heldItem = player.inventory.getItemStack();
				if(hasFreeSlot && (heldItem == null || Item.getItemFromBlock(block) == heldItem.getItem() || heldItem.getItemDamage() != meta)) {
					ItemStack stack = new ItemStack(block, remove(itemstack, 64), meta);
					if(stack.stackSize != 0)
						player.inventory.addItemStackToInventory(stack);
				}*/
				// Used to keep one stack, disabled for now
			} else {
				for (int i = 0; i < counts.length; i++) {
					int count = counts[i];

					// highest is used to keep one stack, disabled for now
					if (/*i == highest || */count == 0) {
						continue;
					}

					add(itemstack, count);
					player.field_7514.method_5447(i, class_1799.field_8037);
				}

				/*int countInHighest = counts[highest];
				int maxSize = new ItemStack(block, 1, meta).getMaxStackSize();
				if(countInHighest < maxSize) {
					int missing = maxSize - countInHighest;
					ItemStack stackInHighest = player.inventory.getStackInSlot(highest);
					stackInHighest.stackSize += remove(itemstack, missing);
				}*/
				// Used to keep one stack, disabled for now
			}
		}
	}

	@Nonnull
	@Override
	public class_2561 method_7864(@Nonnull class_1799 stack) {
		class_2248 block = getBlock(stack);
		class_1799 bstack = new class_1799(block);
		class_5250 cand = super.method_7864(stack).method_27661();

		if (!bstack.method_7960()) {
			cand.method_27693(" (");
			cand.method_10852(bstack.method_7964().method_27661().method_27692(class_124.field_1060));
			cand.method_27693(")");
		}

		return cand;
	}

	private boolean setBlock(class_1799 stack, class_2248 block) {
		if (block.method_8389() != class_1802.field_8162 && (getBlock(stack) == null || getBlockCount(stack) == 0)) {
			ItemNBTHelper.setString(stack, TAG_BLOCK_NAME, class_2378.field_11146.method_10221(block).toString());
			return true;
		}
		return false;
	}

	private void add(class_1799 stack, int count) {
		int current = getBlockCount(stack);
		setCount(stack, current + count);
	}

	@Override
	@Environment(EnvType.CLIENT)
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> stacks, class_1836 flags) {
		class_2248 block = getBlock(stack);
		if (block != null) {
			int count = getBlockCount(stack);
			stacks.add(new class_2585(count + " ").method_10852(new class_1799(block).method_7964()).method_27692(class_124.field_1080));
		}

		if (ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, false)) {
			stacks.add(new class_2588("botaniamisc.active"));
		} else {
			stacks.add(new class_2588("botaniamisc.inactive"));
		}
	}

	private static void setCount(class_1799 stack, int count) {
		ItemNBTHelper.setInt(stack, TAG_BLOCK_COUNT, count);
	}

	public static int remove(class_1799 stack, int count) {
		int current = getBlockCount(stack);
		setCount(stack, Math.max(current - count, 0));

		return Math.min(current, count);
	}

	private static String getBlockName(class_1799 stack) {
		return ItemNBTHelper.getString(stack, TAG_BLOCK_NAME, "");
	}

	@Nullable
	public static class_2248 getBlock(class_1799 stack) {
		class_2960 id = class_2960.method_12829(getBlockName(stack));
		if (id != null) {
			return class_2378.field_11146.method_17966(id).orElse(null);
		}
		return null;
	}

	public static int getBlockCount(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_BLOCK_COUNT, 0);
	}

	@Override
	public boolean provideBlock(class_1657 player, class_1799 requestor, class_1799 stack, class_2248 block, boolean doit) {
		class_2248 stored = getBlock(stack);
		if (stored == block) {
			int count = getBlockCount(stack);
			if (count > 0) {
				if (doit) {
					setCount(stack, count - 1);
				}
				return true;
			}
		}

		return false;
	}

	@Override
	public int getBlockCount(class_1657 player, class_1799 requestor, class_1799 stack, class_2248 block) {
		class_2248 stored = getBlock(stack);
		if (stored == block) {
			return getBlockCount(stack);
		}
		return 0;
	}

}
