/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import vazkii.botania.client.gui.box.ContainerBaubleBox;
import vazkii.botania.common.core.handler.EquipmentHandler;

import javax.annotation.Nonnull;

public class ItemBaubleBox extends class_1792 {
	public static final int SIZE = 24;

	public ItemBaubleBox(class_1793 props) {
		super(props);
	}

	public static class_1277 getInventory(class_1799 stack) {
		return new ItemBackedInventory(stack, SIZE) {
			@Override
			public boolean method_5437(int index, @Nonnull class_1799 stack) {
				return EquipmentHandler.instance.isAccessory(stack);
			}
		};
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
		if (!world.field_9236) {
			class_1799 stack = player.method_5998(hand);
			class_3908 container = new ExtendedScreenHandlerFactory() {
				@Override
				public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
					buf.writeBoolean(hand == class_1268.field_5808);
				}

				@Override
				public class_2561 method_5476() {
					return stack.method_7964();
				}

				@Override
				public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
					return new ContainerBaubleBox(syncId, inv, stack);
				}
			};
			player.method_17355(container);
		}
		return class_1271.method_22427(player.method_5998(hand));
	}
}
