/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_239;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3965;
import net.minecraft.util.*;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.rod.ItemExchangeRod;

import javax.annotation.Nonnull;

import java.util.ArrayList;
import java.util.List;

public class ItemAstrolabe extends class_1792 {

	private static final String TAG_BLOCKSTATE = "blockstate";
	private static final String TAG_SIZE = "size";

	public ItemAstrolabe(class_1793 props) {
		super(props);
	}

	@Nonnull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1799 stack = ctx.method_8041();
		class_2680 state = ctx.method_8045().method_8320(ctx.method_8037());
		class_1657 player = ctx.method_8036();

		if (player != null && player.method_5715()) {
			if (setBlock(stack, state)) {
				displayRemainderCounter(player, stack);
				return class_1269.field_5812;
			}
		} else if (player != null) {
			boolean did = placeAllBlocks(stack, player);
			if (did) {
				displayRemainderCounter(player, stack);
			}

			return did ? class_1269.field_5812 : class_1269.field_5814;
		}

		return class_1269.field_5811;
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, @Nonnull class_1268 hand) {
		class_1799 stack = playerIn.method_5998(hand);
		if (playerIn.method_5715()) {
			playerIn.method_5783(class_3417.field_14627, 0.5F, 1F);
			if (!worldIn.field_9236) {
				int size = getSize(stack);
				int newSize = size == 11 ? 3 : size + 2;
				setSize(stack, newSize);
				ItemsRemainingRenderHandler.send(playerIn, stack, 0, new class_2585(newSize + "x" + newSize));
			}

			return class_1271.method_22427(stack);
		}

		return class_1271.method_22430(stack);
	}

	public boolean placeAllBlocks(class_1799 stack, class_1657 player) {
		List<class_2338> blocksToPlace = getBlocksToPlace(stack, player);
		if (!hasBlocks(stack, player, blocksToPlace)) {
			return false;
		}

		int size = getSize(stack);
		int cost = size * 320;
		if (!ManaItemHandler.instance().requestManaExact(stack, player, cost, false)) {
			return false;
		}

		class_1799 stackToPlace = new class_1799(getBlock(stack));
		for (class_2338 coords : blocksToPlace) {
			placeBlockAndConsume(player, stack, stackToPlace, coords);
		}
		ManaItemHandler.instance().requestManaExact(stack, player, cost, true);

		return true;
	}

	private void placeBlockAndConsume(class_1657 player, class_1799 requestor, class_1799 blockToPlace, class_2338 coords) {
		if (blockToPlace.method_7960()) {
			return;
		}

		class_2248 block = class_2248.method_9503(blockToPlace.method_7909());
		class_2680 state = block.method_9564();
		player.field_6002.method_8501(coords, state);
		player.field_6002.method_20290(2001, coords, class_2248.method_9507(state));

		if (player.field_7503.field_7477) {
			return;
		}

		List<class_1799> stacksToCheck = new ArrayList<>();
		for (int i = 0; i < player.field_7514.method_5439(); i++) {
			class_1799 stackInSlot = player.field_7514.method_5438(i);
			if (!stackInSlot.method_7960() && stackInSlot.method_7909() == blockToPlace.method_7909()) {
				stackInSlot.method_7934(1);
				return;
			}

			if (!stackInSlot.method_7960() && stackInSlot.method_7909() instanceof IBlockProvider) {
				stacksToCheck.add(stackInSlot);
			}
		}

		for (class_1799 providerStack : stacksToCheck) {
			IBlockProvider prov = (IBlockProvider) providerStack.method_7909();

			if (prov.provideBlock(player, requestor, providerStack, block, false)) {
				prov.provideBlock(player, requestor, providerStack, block, true);
				return;
			}
		}
	}

	public static boolean hasBlocks(class_1799 stack, class_1657 player, List<class_2338> blocks) {
		if (player.field_7503.field_7477) {
			return true;
		}

		class_2248 block = getBlock(stack);
		class_1799 reqStack = new class_1799(block);

		int required = blocks.size();
		int current = 0;
		List<class_1799> stacksToCheck = new ArrayList<>();
		for (int i = 0; i < player.field_7514.method_5439(); i++) {
			class_1799 stackInSlot = player.field_7514.method_5438(i);
			if (!stackInSlot.method_7960() && stackInSlot.method_7909() == reqStack.method_7909()) {
				current += stackInSlot.method_7947();
				if (current >= required) {
					return true;
				}
			}
			if (!stackInSlot.method_7960() && stackInSlot.method_7909() instanceof IBlockProvider) {
				stacksToCheck.add(stackInSlot);
			}
		}

		for (class_1799 providerStack : stacksToCheck) {
			IBlockProvider prov = (IBlockProvider) providerStack.method_7909();
			int count = prov.getBlockCount(player, stack, providerStack, block);
			if (count == -1) {
				return true;
			}

			current += count;

			if (current >= required) {
				return true;
			}
		}

		return false;
	}

	public static List<class_2338> getBlocksToPlace(class_1799 stack, class_1657 player) {
		List<class_2338> coords = new ArrayList<>();
		class_3965 rtr = ToolCommons.raytraceFromEntity(player, 5, true);
		if (rtr.method_17783() == class_239.class_240.field_1332) {
			class_2338 pos = rtr.method_17777();
			class_2680 state = player.field_6002.method_8320(pos);
			if (state.method_26207().method_15800()) {
				pos = pos.method_10074();
			}

			int range = (getSize(stack) ^ 1) / 2;

			class_2350 dir = rtr.method_17780();
			class_2350 rotationDir = class_2350.method_10150(player.field_6031);

			boolean pitchedVertically = Math.abs(player.field_5965) > 50;

			boolean axisX = rotationDir.method_10166() == class_2351.field_11048;
			boolean axisZ = rotationDir.method_10166() == class_2351.field_11051;

			int xOff = axisZ || pitchedVertically ? range : 0;
			int yOff = pitchedVertically ? 0 : range;
			int zOff = axisX || pitchedVertically ? range : 0;

			for (int x = -xOff; x < xOff + 1; x++) {
				for (int y = 0; y < yOff * 2 + 1; y++) {
					for (int z = -zOff; z < zOff + 1; z++) {
						int xp = pos.method_10263() + x + dir.method_10148();
						int yp = pos.method_10264() + y + dir.method_10164();
						int zp = pos.method_10260() + z + dir.method_10165();

						class_2338 newPos = new class_2338(xp, yp, zp);
						class_2680 state1 = player.field_6002.method_8320(newPos);
						if (player.field_6002.method_8621().method_11952(newPos)
								&& (state1.method_26215() || state1.method_26207().method_15800())) {
							coords.add(newPos);
						}
					}
				}
			}

		}

		return coords;
	}

	public void displayRemainderCounter(class_1657 player, class_1799 stack) {
		class_2248 block = getBlock(stack);
		int count = ItemExchangeRod.getInventoryItemCount(player, stack, block);
		if (!player.field_6002.field_9236) {
			ItemsRemainingRenderHandler.send(player, new class_1799(block), count);
		}
	}

	private boolean setBlock(class_1799 stack, class_2680 state) {
		if (!state.method_26215()) {
			ItemNBTHelper.setCompound(stack, TAG_BLOCKSTATE, class_2512.method_10686(state));
			return true;
		}
		return false;
	}

	private static void setSize(class_1799 stack, int size) {
		ItemNBTHelper.setInt(stack, TAG_SIZE, size | 1);
	}

	public static int getSize(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_SIZE, 3) | 1;
	}

	public static class_2248 getBlock(class_1799 stack) {
		return getBlockState(stack).method_26204();
	}

	public static class_2680 getBlockState(class_1799 stack) {
		return class_2512.method_10681(ItemNBTHelper.getCompound(stack, TAG_BLOCKSTATE, false));
	}

	@Override
	@Environment(EnvType.CLIENT)
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tip, class_1836 flags) {
		class_2248 block = getBlock(stack);
		int size = getSize(stack);

		tip.add(new class_2585(size + " x " + size));
		if (block != class_2246.field_10124) {
			tip.add(new class_1799(block).method_7964().method_27662().method_27692(class_124.field_1080));
		}
	}

}
