/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.integration.curios;

import com.google.common.collect.Multimap;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_897;
import org.apache.commons.lang3.tuple.ImmutableTriple;

import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosComponent;
import top.theillusivec4.curios.api.SlotTypeInfo;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.component.ICurio;
import top.theillusivec4.curios.api.type.component.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.component.IRenderableCurio;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.item.ItemKeepIvy;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

import nerdhub.cardinal.components.api.event.ItemComponentCallbackV2;

// Classloading-safe way to attach curio behaviour to our items
public class CurioIntegration extends EquipmentHandler {

	public static void init() {
		CuriosApi.enqueueSlotType(SlotTypeInfo.BuildScheme.REGISTER, SlotTypePreset.CHARM.getInfoBuilder().build());
		CuriosApi.enqueueSlotType(SlotTypeInfo.BuildScheme.REGISTER, SlotTypePreset.RING.getInfoBuilder().size(2).build());
		CuriosApi.enqueueSlotType(SlotTypeInfo.BuildScheme.REGISTER, SlotTypePreset.BELT.getInfoBuilder().build());
		CuriosApi.enqueueSlotType(SlotTypeInfo.BuildScheme.REGISTER, SlotTypePreset.BODY.getInfoBuilder().build());
		CuriosApi.enqueueSlotType(SlotTypeInfo.BuildScheme.REGISTER, SlotTypePreset.HEAD.getInfoBuilder().build());
		CuriosApi.enqueueSlotType(SlotTypeInfo.BuildScheme.REGISTER, SlotTypePreset.NECKLACE.getInfoBuilder().build());
	}

	public static void keepCurioDrops(class_1309 livingEntity, ICuriosItemHandler handler, class_1282 source,
			int lootingLevel, boolean recentlyHit, List<class_3545<Predicate<class_1799>, ICurio.DropRule>> overrides) { //TODO make this less hacky
		overrides.add(new class_3545<>(stack -> {
			if (ItemKeepIvy.hasIvy(stack)) {
				stack.method_7983(ItemKeepIvy.TAG_KEEP);
				return true;
			}
			return false;
		}, ICurio.DropRule.ALWAYS_KEEP));
	}

	@Override
	protected class_1263 getAllWornItems(class_1309 living) {
		return CuriosApi.getCuriosHelper().getCuriosHandler(living)
				.map(h -> {
					List<class_1799> list = new ArrayList<>();
					for (ICurioStacksHandler sh : h.getCurios().values()) {
						class_1263 stacks = sh.getStacks();
						for (int i = 0; i < stacks.method_5439(); i++) {
							list.add(stacks.method_5438(i));
						}
					}
					return new class_1277(list.toArray(new class_1799[0]));
				})
				.orElseGet(() -> new class_1277(0));
	}

	@Override
	protected class_1799 findItem(class_1792 item, class_1309 living) {
		return CuriosApi.getCuriosHelper().findEquippedCurio(item, living)
				.map(ImmutableTriple::getRight)
				.orElse(class_1799.field_8037);
	}

	@Override
	protected class_1799 findItem(Predicate<class_1799> pred, class_1309 living) {
		return CuriosApi.getCuriosHelper().findEquippedCurio(pred, living)
				.map(ImmutableTriple::getRight)
				.orElse(class_1799.field_8037);
	}

	@SuppressWarnings("deprecation")
	@Override
	protected void registerComponentEvent(class_1792 item) {
		ItemComponentCallbackV2.event(item).register((item1, stack, components) -> {
			components.put(CuriosComponent.ITEM, new Wrapper(stack));
			Botania.proxy.runOnClient(() -> () -> components.put(CuriosComponent.ITEM_RENDER, new RenderWrapper(stack)));
		});
	}

	@Override
	public boolean isAccessory(class_1799 stack) {
		return super.isAccessory(stack) || CuriosComponent.ITEM.getNullable(stack) != null;
	}

	public static class Wrapper implements ICurio {
		private final class_1799 stack;

		Wrapper(class_1799 stack) {
			this.stack = stack;
		}

		private ItemBauble getItem() {
			return (ItemBauble) stack.method_7909();
		}

		@Override
		public void curioTick(String identifier, int index, class_1309 entity) {
			getItem().onWornTick(stack, entity);
		}

		@Override
		public void onEquip(String identifier, int index, class_1309 entity) {
			getItem().onEquipped(stack, entity);
		}

		@Override
		public void onUnequip(String identifier, int index, class_1309 entity) {
			getItem().onUnequipped(stack, entity);
		}

		@Override
		public boolean canEquip(String identifier, class_1309 entity) {
			return getItem().canEquip(stack, entity);
		}

		@Override
		public Multimap<class_1320, class_1322> getAttributeModifiers(String identifier) {
			return getItem().getEquippedAttributeModifiers(stack);
		}

		@Override
		public void playRightClickEquipSound(class_1309 entity) {
			entity.field_6002.method_8465(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), ModSounds.equipBauble, entity.method_5634(), 0.1F, 1.3F);
		}

		@Override
		public boolean canRightClickEquip() {
			return true;
		}

	}

	private static class RenderWrapper implements IRenderableCurio {
		private final class_1799 stack;

		RenderWrapper(class_1799 stack) {
			this.stack = stack;
		}

		private ItemBauble getItem() {
			return (ItemBauble) stack.method_7909();
		}

		@Override
		@Environment(EnvType.CLIENT)
		public void render(String identifier, int index, class_4587 matrixStack, class_4597 renderTypeBuffer, int light, class_1309 livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
			if (!getItem().hasRender(stack, livingEntity)) {
				return;
			}

			class_897<?> renderer = class_310.method_1551().method_1561().method_3953(livingEntity);
			if (!(renderer instanceof class_3883<?, ?>)) {
				return;
			}
			class_583<?> model = ((class_3883<?, ?>) renderer).method_4038();
			if (!(model instanceof class_572<?>)) {
				return;
			}

			class_1799 cosmetic = getItem().getCosmeticItem(stack);
			if (!cosmetic.method_7960()) {
				IRenderableCurio sub = CuriosComponent.ITEM_RENDER.getNullable(cosmetic);
				if (sub != null) {
					sub.render(identifier, index, matrixStack, renderTypeBuffer, light, livingEntity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
				}
			} else {
				getItem().doRender((class_572<?>) model, stack, livingEntity, matrixStack, renderTypeBuffer, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
			}
		}
	}
}
