/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.integration.corporea;

import vazkii.botania.api.corporea.ICorporeaNode;
import vazkii.botania.api.corporea.ICorporeaNodeDetector;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.impl.corporea.SidedVanillaCorporeaNode;
import vazkii.botania.common.impl.corporea.VanillaCorporeaNode;

import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2586;

public class VanillaNodeDetector implements ICorporeaNodeDetector {
	@Nullable
	@Override
	public ICorporeaNode getNode(class_1937 world, ICorporeaSpark spark) {
		class_2586 te = world.method_8321(spark.getAttachPos());
		if (te instanceof class_1278) {
			return new SidedVanillaCorporeaNode(world, spark.getAttachPos(), spark, (class_1278) te, class_2350.field_11036);
		} else if (te instanceof class_1263) {
			return new VanillaCorporeaNode(world, spark.getAttachPos(), (class_1263) te, spark);
		}
		return null;
	}
}
