/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.impl.mana;

import com.google.common.collect.Iterables;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.*;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;

public class ManaItemHandlerImpl implements ManaItemHandler {
	@Override
	public List<class_1799> getManaItems(class_1657 player) {
		if (player == null) {
			return Collections.emptyList();
		}

		List<class_1799> toReturn = new ArrayList<>();

		for (class_1799 stackInSlot : Iterables.concat(player.field_7514.field_7547, player.field_7514.field_7544)) {
			if (!stackInSlot.method_7960() && stackInSlot.method_7909() instanceof IManaItem) {
				toReturn.add(stackInSlot);
			}
		}

		ManaItemsCallback.EVENT.invoker().getManaItems(player, toReturn);
		return toReturn;
	}

	@Override
	public List<class_1799> getManaAccesories(class_1657 player) {
		if (player == null) {
			return Collections.emptyList();
		}

		class_1263 acc = BotaniaAPI.instance().getAccessoriesInventory(player);

		List<class_1799> toReturn = new ArrayList<>(acc.method_5439());

		for (int slot = 0; slot < acc.method_5439(); slot++) {
			class_1799 stackInSlot = acc.method_5438(slot);

			if (!stackInSlot.method_7960() && stackInSlot.method_7909() instanceof IManaItem) {
				toReturn.add(stackInSlot);
			}
		}

		return toReturn;
	}

	@Override
	public int requestMana(class_1799 stack, class_1657 player, int manaToGet, boolean remove) {
		if (stack.method_7960()) {
			return 0;
		}

		List<class_1799> items = getManaItems(player);
		List<class_1799> acc = getManaAccesories(player);
		for (class_1799 stackInSlot : Iterables.concat(items, acc)) {
			if (stackInSlot == stack) {
				continue;
			}
			IManaItem manaItem = (IManaItem) stackInSlot.method_7909();
			if (manaItem.canExportManaToItem(stackInSlot, stack) && manaItem.getMana(stackInSlot) > 0) {
				if (stack.method_7909() instanceof IManaItem && !((IManaItem) stack.method_7909()).canReceiveManaFromItem(stack, stackInSlot)) {
					continue;
				}

				int mana = Math.min(manaToGet, manaItem.getMana(stackInSlot));

				if (remove) {
					manaItem.addMana(stackInSlot, -mana);
				}

				return mana;
			}
		}

		return 0;
	}

	@Override
	public boolean requestManaExact(class_1799 stack, class_1657 player, int manaToGet, boolean remove) {
		if (stack.method_7960()) {
			return false;
		}

		List<class_1799> items = getManaItems(player);
		List<class_1799> acc = getManaAccesories(player);
		for (class_1799 stackInSlot : Iterables.concat(items, acc)) {
			if (stackInSlot == stack) {
				continue;
			}
			IManaItem manaItemSlot = (IManaItem) stackInSlot.method_7909();
			if (manaItemSlot.canExportManaToItem(stackInSlot, stack) && manaItemSlot.getMana(stackInSlot) > manaToGet) {
				if (stack.method_7909() instanceof IManaItem && !((IManaItem) stack.method_7909()).canReceiveManaFromItem(stack, stackInSlot)) {
					continue;
				}

				if (remove) {
					manaItemSlot.addMana(stackInSlot, -manaToGet);
				}

				return true;
			}
		}

		return false;
	}

	@Override
	public int dispatchMana(class_1799 stack, class_1657 player, int manaToSend, boolean add) {
		if (stack.method_7960()) {
			return 0;
		}

		List<class_1799> items = getManaItems(player);
		List<class_1799> acc = getManaAccesories(player);
		for (class_1799 stackInSlot : Iterables.concat(items, acc)) {
			if (stackInSlot == stack) {
				continue;
			}
			IManaItem manaItemSlot = (IManaItem) stackInSlot.method_7909();
			if (manaItemSlot.canReceiveManaFromItem(stackInSlot, stack)) {
				if (stack.method_7909() instanceof IManaItem && !((IManaItem) stack.method_7909()).canExportManaToItem(stack, stackInSlot)) {
					continue;
				}

				int received;
				if (manaItemSlot.getMana(stackInSlot) + manaToSend <= manaItemSlot.getMaxMana(stackInSlot)) {
					received = manaToSend;
				} else {
					received = manaToSend - (manaItemSlot.getMana(stackInSlot) + manaToSend - manaItemSlot.getMaxMana(stackInSlot));
				}

				if (add) {
					manaItemSlot.addMana(stackInSlot, manaToSend);
				}

				return received;
			}
		}

		return 0;
	}

	@Override
	public boolean dispatchManaExact(class_1799 stack, class_1657 player, int manaToSend, boolean add) {
		if (stack.method_7960()) {
			return false;
		}

		List<class_1799> items = getManaItems(player);
		List<class_1799> acc = getManaAccesories(player);
		for (class_1799 stackInSlot : Iterables.concat(items, acc)) {
			if (stackInSlot == stack) {
				continue;
			}
			IManaItem manaItemSlot = (IManaItem) stackInSlot.method_7909();
			if (manaItemSlot.getMana(stackInSlot) + manaToSend <= manaItemSlot.getMaxMana(stackInSlot) && manaItemSlot.canReceiveManaFromItem(stackInSlot, stack)) {
				if (stack.method_7909() instanceof IManaItem && !((IManaItem) stack.method_7909()).canExportManaToItem(stack, stackInSlot)) {
					continue;
				}

				if (add) {
					manaItemSlot.addMana(stackInSlot, manaToSend);
				}

				return true;
			}
		}

		return false;
	}

	@Override
	public int requestManaForTool(class_1799 stack, class_1657 player, int manaToGet, boolean remove) {
		float multiplier = Math.max(0F, 1F - getFullDiscountForTools(player, stack));
		int cost = (int) (manaToGet * multiplier);
		return (int) (requestMana(stack, player, cost, remove) / multiplier);
	}

	@Override
	public boolean requestManaExactForTool(class_1799 stack, class_1657 player, int manaToGet, boolean remove) {
		float multiplier = Math.max(0F, 1F - getFullDiscountForTools(player, stack));
		int cost = (int) (manaToGet * multiplier);
		return requestManaExact(stack, player, cost, remove);
	}

	@Override
	public float getFullDiscountForTools(class_1657 player, class_1799 tool) {
		float discount = 0F;
		for (int i = 0; i < player.field_7514.field_7548.size(); i++) {
			class_1799 armor = player.field_7514.field_7548.get(i);
			if (!armor.method_7960() && armor.method_7909() instanceof IManaDiscountArmor) {
				discount += ((IManaDiscountArmor) armor.method_7909()).getDiscount(armor, i, player, tool);
			}
		}

		int unbreaking = class_1890.method_8225(class_1893.field_9119, tool);
		discount += unbreaking * 0.05F;
		discount = ManaDiscountCallback.EVENT.invoker().getManaDiscount(player, discount, tool);

		return discount;
	}
}
