/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.impl.corporea;

import vazkii.botania.api.corporea.ICorporeaNode;
import vazkii.botania.api.corporea.ICorporeaSpark;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public abstract class AbstractCorporeaNode implements ICorporeaNode {

	private final class_1937 world;
	private final class_2338 pos;
	private final ICorporeaSpark spark;

	public AbstractCorporeaNode(class_1937 world, class_2338 pos, ICorporeaSpark spark) {
		this.world = world;
		this.pos = pos;
		this.spark = spark;
	}

	@Override
	public class_1937 getWorld() {
		return world;
	}

	@Override
	public class_2338 getPos() {
		return pos;
	}

	@Override
	public ICorporeaSpark getSpark() {
		return spark;
	}

	/**
	 * Breaks down the oversized {@code stack} into multiple stacks within their stack limit.
	 * Used when performing extractions with {@link #extractItems}. Not necessary for {@link #countItems}.
	 */
	protected static Collection<class_1799> breakDownBigStack(class_1799 stack) {
		if (stack.method_7947() < stack.method_7914()) {
			return Collections.singleton(stack);
		}

		List<class_1799> stacks = new ArrayList<>();

		int additionalStacks = stack.method_7947() / stack.method_7914();
		class_1799 fullStack = stack.method_7972();
		fullStack.method_7939(stack.method_7914());
		for (int i = 0; i < additionalStacks; i++) {
			stacks.add(fullStack.method_7972());
		}

		int lastStackSize = stack.method_7947() % stack.method_7914();
		class_1799 lastStack = stack.method_7972();
		lastStack.method_7939(lastStackSize);
		stacks.add(lastStack);

		return stacks;
	}
}
