/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.impl;

import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1832;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3528;
import net.minecraft.item.*;
import net.minecraft.util.*;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.corporea.ICorporeaNodeDetector;
import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.subtile.functional.SubTileSolegnolia;
import vazkii.botania.common.brew.ModBrews;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.handler.ManaNetworkHandler;
import vazkii.botania.common.integration.corporea.CorporeaNodeDetectors;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.relic.ItemLokiRing;
import vazkii.botania.common.lib.LibMisc;

import javax.annotation.Nonnull;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class BotaniaAPIImpl implements BotaniaAPI {
	private static final class_3528<class_1814> RELIC_RARITY = new class_3528<>(() -> class_1814.field_8904);

	private enum ArmorMaterial implements net.minecraft.class_1741 {
		MANASTEEL("manasteel", 16, new int[] { 2, 5, 6, 2 }, 18, () -> class_3417.field_14862, () -> ModItems.manaSteel, 0),
		MANAWEAVE("manaweave", 5, new int[] { 1, 2, 2, 1 }, 18, () -> class_3417.field_14581, () -> ModItems.manaweaveCloth, 0),
		ELEMENTIUM("elementium", 18, new int[] { 2, 5, 6, 2 }, 18, () -> class_3417.field_14862, () -> ModItems.elementium, 0),
		TERRASTEEL("terrasteel", 34, new int[] { 3, 6, 8, 3 }, 26, () -> class_3417.field_15103, () -> ModItems.terrasteel, 3);

		private final String name;
		private final int durabilityMultiplier;
		private final int[] damageReduction;
		private final int enchantability;
		private final Supplier<class_3414> equipSound;
		private final Supplier<class_1792> repairItem;
		private final float toughness;
		private static final int[] MAX_DAMAGE_ARRAY = new int[] { 13, 15, 16, 11 };

		ArmorMaterial(String name, int durabilityMultiplier, int[] damageReduction, int enchantability, Supplier<class_3414> equipSound, Supplier<class_1792> repairItem, float toughness) {
			this.name = name;
			this.durabilityMultiplier = durabilityMultiplier;
			this.damageReduction = damageReduction;
			this.enchantability = enchantability;
			this.equipSound = equipSound;
			this.repairItem = repairItem;
			this.toughness = toughness;
		}

		@Override
		public int method_7696(class_1304 slot) {
			return durabilityMultiplier * MAX_DAMAGE_ARRAY[slot.method_5927()];
		}

		@Override
		public int method_7697(class_1304 slot) {
			return damageReduction[slot.method_5927()];
		}

		@Override
		public int method_7699() {
			return enchantability;
		}

		@Nonnull
		@Override
		public class_3414 method_7698() {
			return equipSound.get();
		}

		@Nonnull
		@Override
		public class_1856 method_7695() {
			return class_1856.method_8091(repairItem.get());
		}

		@Nonnull
		@Override
		public String method_7694() {
			return name;
		}

		@Override
		public float method_7700() {
			return toughness;
		}

		@Override
		public float method_24355() {
			return 0;
		}
	}

	private enum ItemTier implements class_1832 {
		MANASTEEL(300, 6.2F, 2, 3, 20, () -> ModItems.manaSteel),
		ELEMENTIUM(720, 6.2F, 2, 3, 20, () -> ModItems.elementium),
		TERRASTEEL(2300, 9, 3, 4, 26, () -> ModItems.terrasteel);

		private final int maxUses;
		private final float efficiency;
		private final float attackDamage;
		private final int harvestLevel;
		private final int enchantability;
		private final Supplier<class_1792> repairItem;

		ItemTier(int maxUses, float efficiency, float attackDamage, int harvestLevel, int enchantability, Supplier<class_1792> repairItem) {
			this.maxUses = maxUses;
			this.efficiency = efficiency;
			this.attackDamage = attackDamage;
			this.harvestLevel = harvestLevel;
			this.enchantability = enchantability;
			this.repairItem = repairItem;
		}

		@Override
		public int method_8025() {
			return maxUses;
		}

		@Override
		public float method_8027() {
			return efficiency;
		}

		@Override
		public float method_8028() {
			return attackDamage;
		}

		@Override
		public int method_8024() {
			return harvestLevel;
		}

		@Override
		public int method_8026() {
			return enchantability;
		}

		@Override
		public class_1856 method_8023() {
			return class_1856.method_8091(repairItem.get());
		}
	}

	@Override
	public int apiVersion() {
		return 1;
	}

	@Override
	public class_2378<Brew> getBrewRegistry() {
		return ModBrews.registry;
	}

	@Override
	public net.minecraft.class_1741 getManasteelArmorMaterial() {
		return ArmorMaterial.MANASTEEL;
	}

	@Override
	public net.minecraft.class_1741 getElementiumArmorMaterial() {
		return ArmorMaterial.ELEMENTIUM;
	}

	@Override
	public net.minecraft.class_1741 getManaweaveArmorMaterial() {
		return ArmorMaterial.MANAWEAVE;
	}

	@Override
	public net.minecraft.class_1741 getTerrasteelArmorMaterial() {
		return ArmorMaterial.TERRASTEEL;
	}

	@Override
	public class_1832 getManasteelItemTier() {
		return ItemTier.MANASTEEL;
	}

	@Override
	public class_1832 getElementiumItemTier() {
		return ItemTier.ELEMENTIUM;
	}

	@Override
	public class_1832 getTerrasteelItemTier() {
		return ItemTier.TERRASTEEL;
	}

	@Override
	public class_1814 getRelicRarity() {
		return RELIC_RARITY.method_15332();
	}

	@Override
	public IManaNetwork getManaNetworkInstance() {
		return ManaNetworkHandler.instance;
	}

	@Override
	public int getPassiveFlowerDecay() {
		return LibMisc.PASSIVE_FLOWER_DECAY;
	}

	@Override
	public class_1263 getAccessoriesInventory(class_1657 player) {
		return EquipmentHandler.getAllWorn(player);
	}

	@Override
	public void breakOnAllCursors(class_1657 player, class_1799 stack, class_2338 pos, class_2350 side) {
		ItemLokiRing.breakOnAllCursors(player, stack, pos, side);
	}

	@Override
	public boolean hasSolegnoliaAround(class_1297 e) {
		return SubTileSolegnolia.hasSolegnoliaAround(e);
	}

	@Override
	public void sparkleFX(class_1937 world, double x, double y, double z, float r, float g, float b, float size, int m) {
		SparkleParticleData data = SparkleParticleData.sparkle(size, r, g, b, m);
		world.method_8406(data, x, y, z, 0, 0, 0);
	}

	@Override
	public boolean shouldForceCheck() {
		return ConfigHandler.COMMON.flowerForceCheck.getValue();
	}

	private final Map<class_2960, Integer> oreWeights = new ConcurrentHashMap<>();
	private final Map<class_2960, Integer> netherOreWeights = new ConcurrentHashMap<>();
	private final Map<class_2960, Function<class_1767, class_2248>> paintableBlocks = new ConcurrentHashMap<>();

	@Override
	public Map<class_2960, Integer> getOreWeights() {
		return Collections.unmodifiableMap(oreWeights);
	}

	@Override
	public Map<class_2960, Integer> getNetherOreWeights() {
		return Collections.unmodifiableMap(netherOreWeights);
	}

	@Override
	public void registerOreWeight(class_2960 tag, int weight) {
		oreWeights.put(tag, weight);
	}

	@Override
	public void registerNetherOreWeight(class_2960 tag, int weight) {
		netherOreWeights.put(tag, weight);
	}

	@Override
	public Map<class_2960, Function<class_1767, class_2248>> getPaintableBlocks() {
		return Collections.unmodifiableMap(paintableBlocks);
	}

	@Override
	public void registerPaintableBlock(class_2960 block, Function<class_1767, class_2248> transformer) {
		paintableBlocks.put(block, transformer);
	}

	@Override
	public void registerCorporeaNodeDetector(ICorporeaNodeDetector detector) {
		CorporeaNodeDetectors.register(detector);
	}
}
