/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2378;
import net.minecraft.class_4048;
import vazkii.botania.common.block.tile.TileLightRelay.EntityPlayerMover;
import vazkii.botania.common.lib.LibEntityNames;

import static vazkii.botania.common.block.ModBlocks.register;

public final class ModEntities {
	private static final class_4048 ZERO_SIZE = class_4048.method_18385(0, 0);

	public static final class_1299<EntityManaBurst> MANA_BURST = FabricEntityTypeBuilder.<EntityManaBurst>create(
			class_1311.field_17715, EntityManaBurst::new)
			.dimensions(ZERO_SIZE)
			.trackedUpdateRate(10)
			.trackRangeBlocks(64)
			.forceTrackedVelocityUpdates(true)
			.build();
	public static final class_1299<EntityPixie> PIXIE = FabricEntityTypeBuilder.<EntityPixie>create(class_1311.field_17715, EntityPixie::new)
			.dimensions(class_4048.method_18384(1, 1))
			.trackedUpdateRate(3)
			.trackRangeBlocks(16)
			.forceTrackedVelocityUpdates(true)
			.build();
	public static final class_1299<EntityFlameRing> FLAME_RING = FabricEntityTypeBuilder.<EntityFlameRing>create(class_1311.field_17715, EntityFlameRing::new)
			.dimensions(ZERO_SIZE)
			.trackRangeBlocks(32)
			.trackedUpdateRate(40)
			.forceTrackedVelocityUpdates(false)
			.build();
	public static final class_1299<EntityVineBall> VINE_BALL = FabricEntityTypeBuilder.<EntityVineBall>create(class_1311.field_17715, EntityVineBall::new)
			.dimensions(class_4048.method_18384(0.25F, 0.25F))
			.trackRangeBlocks(64)
			.trackedUpdateRate(10)
			.forceTrackedVelocityUpdates(true)
			.build();
	public static final class_1299<EntityDoppleganger> DOPPLEGANGER = FabricEntityTypeBuilder.create(class_1311.field_6302, EntityDoppleganger::new)
			.dimensions(class_4048.method_18384(0.6F, 1.8F))
			.fireImmune()
			.trackRangeBlocks(128)
			.trackedUpdateRate(10)
			.forceTrackedVelocityUpdates(true)
			.build();
	public static final class_1299<EntityMagicLandmine> MAGIC_LANDMINE = FabricEntityTypeBuilder.create(class_1311.field_17715, EntityMagicLandmine::new)
			.dimensions(class_4048.method_18384(5F, 0.1F))
			.trackRangeBlocks(128)
			.trackedUpdateRate(40)
			.forceTrackedVelocityUpdates(false)
			.build();
	public static final class_1299<EntitySpark> SPARK = FabricEntityTypeBuilder.<EntitySpark>create(class_1311.field_17715, EntitySpark::new)
			.dimensions(class_4048.method_18384(0.2F, 0.5F))
			.fireImmune()
			.trackRangeBlocks(64)
			.trackedUpdateRate(10)
			.forceTrackedVelocityUpdates(false)
			.build();
	public static final class_1299<EntityThrownItem> THROWN_ITEM = FabricEntityTypeBuilder.<EntityThrownItem>create(class_1311.field_17715, EntityThrownItem::new)
			.dimensions(class_4048.method_18384(0.25F, 0.25F))
			.trackRangeBlocks(64)
			.trackedUpdateRate(20)
			.forceTrackedVelocityUpdates(true)
			.build();
	public static final class_1299<EntityMagicMissile> MAGIC_MISSILE = FabricEntityTypeBuilder.<EntityMagicMissile>create(class_1311.field_17715, EntityMagicMissile::new)
			.dimensions(ZERO_SIZE)
			.trackRangeBlocks(64)
			.trackedUpdateRate(2)
			.forceTrackedVelocityUpdates(true)
			.build();
	public static final class_1299<EntityThornChakram> THORN_CHAKRAM = FabricEntityTypeBuilder.<EntityThornChakram>create(class_1311.field_17715, EntityThornChakram::new)
			.dimensions(class_4048.method_18384(0.25F, 0.25F))
			.trackRangeBlocks(64)
			.trackedUpdateRate(10)
			.forceTrackedVelocityUpdates(true)
			.build();
	public static final class_1299<EntityCorporeaSpark> CORPOREA_SPARK = FabricEntityTypeBuilder.<EntityCorporeaSpark>create(class_1311.field_17715, EntityCorporeaSpark::new)
			.dimensions(class_4048.method_18384(0.2F, 0.5F))
			.fireImmune()
			.trackRangeBlocks(64)
			.trackedUpdateRate(40)
			.forceTrackedVelocityUpdates(false)
			.build();
	public static final class_1299<EntityEnderAirBottle> ENDER_AIR_BOTTLE = FabricEntityTypeBuilder.<EntityEnderAirBottle>create(class_1311.field_17715, EntityEnderAirBottle::new)
			.dimensions(class_4048.method_18384(0.25F, 0.25F))
			.trackRangeBlocks(64)
			.trackedUpdateRate(10)
			.forceTrackedVelocityUpdates(true)
			.build();
	public static final class_1299<EntityPoolMinecart> POOL_MINECART = FabricEntityTypeBuilder.<EntityPoolMinecart>create(class_1311.field_17715, EntityPoolMinecart::new)
			.dimensions(class_4048.method_18384(0.98F, 0.7F))
			.trackRangeBlocks(80)
			.trackedUpdateRate(3)
			.forceTrackedVelocityUpdates(true)
			.build();
	public static final class_1299<EntityPinkWither> PINK_WITHER = FabricEntityTypeBuilder.create(class_1311.field_17715, EntityPinkWither::new)
			.dimensions(class_4048.method_18384(0.9F, 3.5F))
			.trackRangeBlocks(80)
			.trackedUpdateRate(3)
			.forceTrackedVelocityUpdates(false)
			.build();
	public static final class_1299<EntityPlayerMover> PLAYER_MOVER = FabricEntityTypeBuilder.<EntityPlayerMover>create(class_1311.field_17715, EntityPlayerMover::new)
			.dimensions(ZERO_SIZE)
			.trackRangeBlocks(40)
			.trackedUpdateRate(3)
			.forceTrackedVelocityUpdates(true)
			.build();
	public static final class_1299<EntityManaStorm> MANA_STORM = FabricEntityTypeBuilder.create(class_1311.field_17715, EntityManaStorm::new)
			.dimensions(class_4048.method_18384(0.98F, 0.98F))
			.trackRangeBlocks(64)
			.trackedUpdateRate(10)
			.forceTrackedVelocityUpdates(false)
			.build();
	public static final class_1299<EntityBabylonWeapon> BABYLON_WEAPON = FabricEntityTypeBuilder.<EntityBabylonWeapon>create(class_1311.field_17715, EntityBabylonWeapon::new)
			.dimensions(ZERO_SIZE)
			.trackRangeBlocks(64)
			.trackedUpdateRate(10)
			.forceTrackedVelocityUpdates(true)
			.build();
	public static final class_1299<EntityFallingStar> FALLING_STAR = FabricEntityTypeBuilder.<EntityFallingStar>create(class_1311.field_17715, EntityFallingStar::new)
			.dimensions(ZERO_SIZE)
			.trackRangeBlocks(64)
			.trackedUpdateRate(10)
			.forceTrackedVelocityUpdates(true)
			.build();

	public static void registerEntities() {
		class_2378<class_1299<?>> r = class_2378.field_11145;
		register(r, LibEntityNames.MANA_BURST, MANA_BURST);
		register(r, LibEntityNames.PIXIE, PIXIE);
		register(r, LibEntityNames.FLAME_RING, FLAME_RING);
		register(r, LibEntityNames.VINE_BALL, VINE_BALL);
		register(r, LibEntityNames.DOPPLEGANGER, DOPPLEGANGER);
		register(r, LibEntityNames.MAGIC_LANDMINE, MAGIC_LANDMINE);
		register(r, LibEntityNames.SPARK, SPARK);
		register(r, LibEntityNames.THROWN_ITEM, THROWN_ITEM);
		register(r, LibEntityNames.MAGIC_MISSILE, MAGIC_MISSILE);
		register(r, LibEntityNames.THORN_CHAKRAM, THORN_CHAKRAM);
		register(r, LibEntityNames.CORPOREA_SPARK, CORPOREA_SPARK);
		register(r, LibEntityNames.ENDER_AIR_BOTTLE, ENDER_AIR_BOTTLE);
		register(r, LibEntityNames.POOL_MINECART, POOL_MINECART);
		register(r, LibEntityNames.PINK_WITHER, PINK_WITHER);
		register(r, LibEntityNames.PLAYER_MOVER, PLAYER_MOVER);
		register(r, LibEntityNames.MANA_STORM, MANA_STORM);
		register(r, LibEntityNames.BABYLON_WEAPON, BABYLON_WEAPON);
		register(r, LibEntityNames.FALLING_STAR, FALLING_STAR);
	}

}
