/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import com.google.common.collect.ImmutableMap;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.EnvironmentInterface;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1682;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_2541;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3856;
import net.minecraft.class_3965;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.network.PacketSpawnEntity;

import javax.annotation.Nonnull;

import java.util.Map;

@EnvironmentInterface(value = EnvType.CLIENT, itf = class_3856.class)
public class EntityVineBall extends class_1682 implements class_3856 {
	private static final class_2940<Float> GRAVITY = class_2945.method_12791(EntityVineBall.class, class_2943.field_13320);
	private static final Map<class_2350, class_2746> propMap = ImmutableMap.of(class_2350.field_11043, class_2541.field_11706, class_2350.field_11035, class_2541.field_11699,
			class_2350.field_11039, class_2541.field_11696, class_2350.field_11034, class_2541.field_11702);

	public EntityVineBall(class_1299<EntityVineBall> type, class_1937 world) {
		super(type, world);
	}

	public EntityVineBall(class_1309 thrower, boolean gravity) {
		super(ModEntities.VINE_BALL, thrower, thrower.field_6002);
		field_6011.method_12778(GRAVITY, gravity ? 0.03F : 0F);
	}

	@Override
	protected void method_5693() {
		field_6011.method_12784(GRAVITY, 0F);
	}

	@Nonnull
	@Override
	public class_2596<?> method_18002() {
		return PacketSpawnEntity.make(this);
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void method_5711(byte id) {
		if (id == 3) {
			for (int j = 0; j < 16; j++) {
				field_6002.method_8406(new class_2392(class_2398.field_11218, new class_1799(ModItems.vineBall)), method_23317(), method_23318(), method_23321(), Math.random() * 0.2 - 0.1, Math.random() * 0.25, Math.random() * 0.2 - 0.1);
			}
		}
	}

	@Override
	protected void method_7488(@Nonnull class_239 rtr) {
		if (!field_6002.field_9236) {
			if (rtr.method_17783() == class_239.class_240.field_1332) {
				class_2350 dir = ((class_3965) rtr).method_17780();

				if (dir.method_10166() != class_2350.class_2351.field_11052) {
					class_2338 pos = ((class_3965) rtr).method_17777().method_10093(dir);
					boolean first = true;
					while (pos.method_10264() > 0) {
						class_2680 state = field_6002.method_8320(pos);
						if (state.method_26215()) {
							class_2680 stateSet = ModBlocks.solidVines.method_9564().method_11657(propMap.get(dir.method_10153()), true);

							if (first && !stateSet.method_26184(field_6002, pos)) {
								break;
							}
							first = false;

							field_6002.method_8501(pos, stateSet);
							field_6002.method_20290(2001, pos, class_2248.method_9507(stateSet));
							pos = pos.method_10074();
						} else {
							break;
						}
					}
				}

			}

			this.field_6002.method_8421(this, (byte) 3);
			method_5650();
		}
	}

	@Override
	protected float method_7490() {
		return field_6011.method_12789(GRAVITY);
	}

	@Nonnull
	@Override
	public class_1799 method_7495() {
		return new class_1799(ModItems.vineBall);
	}
}
