/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2643;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.util.math.*;
import vazkii.botania.common.network.PacketSpawnEntity;
import vazkii.botania.mixin.AccessorItemEntity;

import javax.annotation.Nonnull;

import java.util.function.Predicate;

public class EntityThrownItem extends class_1542 {
	public EntityThrownItem(class_1299<EntityThrownItem> type, class_1937 world) {
		super(type, world);
	}

	public EntityThrownItem(class_1937 world, double x,
			double y, double z, class_1542 item) {
		super(world, x, y, z, item.method_6983());
		method_6982(((AccessorItemEntity) item).getPickupDelay());
		method_18799(item.method_18798());
		method_5684(true);
	}

	@Nonnull
	@Override
	public class_1299<?> method_5864() {
		return ModEntities.THROWN_ITEM;
	}

	@Nonnull
	@Override
	public class_2596<?> method_18002() {
		return PacketSpawnEntity.make(this);
	}

	@Override
	public void method_5773() {
		super.method_5773();

		// [VanillaCopy] derivative from ThrowableEntity
		int pickupDelay = ((AccessorItemEntity) this).getPickupDelay();
		Predicate<class_1297> filter = e -> !e.method_7325() && e.method_5805() && e.method_5863() && (!(e instanceof class_1657) || pickupDelay == 0);
		class_239 ray = class_1675.method_18074(this, filter);
		if (ray.method_17783() == class_239.class_240.field_1332) {
			class_2338 pos = ((class_3965) ray).method_17777();
			class_2680 state = this.field_6002.method_8320(pos);
			if (state.method_27852(class_2246.field_10316)) {
				this.method_5717(pos);
			} else if (state.method_27852(class_2246.field_10613)) {
				class_2586 tileentity = this.field_6002.method_8321(pos);
				if (tileentity instanceof class_2643) {
					((class_2643) tileentity).method_11409(this);
				}
			}
		}

		// Bonk any entities hit
		if (!field_6002.field_9236 && ray.method_17783() == class_239.class_240.field_1331) {
			class_1297 bonk = ((class_3966) ray).method_17782();
			bonk.method_5643(class_1282.field_5846, 2.0F);
			class_1297 item = new class_1542(field_6002, method_23317(), method_23318(), method_23321(), method_6983());
			field_6002.method_8649(item);
			item.method_18799(method_18798().method_1021(0.25));
			method_5650();
			return;
		}

		if (!field_6002.field_9236 && method_18798().method_1033() < 1.0F) {
			class_1297 item = new class_1542(field_6002, method_23317(), method_23318(), method_23321(), method_6983());
			field_6002.method_8649(item);
			item.method_18799(method_18798());
			method_5650();
		}
	}
}
