/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2643;
import net.minecraft.class_2680;
import net.minecraft.class_3965;

public abstract class EntityThrowableCopy extends class_1676 {
	protected EntityThrowableCopy(class_1299<? extends EntityThrowableCopy> type, class_1937 worldIn) {
		super(type, worldIn);
	}

	protected EntityThrowableCopy(class_1299<? extends EntityThrowableCopy> type, double x, double y, double z, class_1937 worldIn) {
		this(type, worldIn);
		this.method_5814(x, y, z);
	}

	protected EntityThrowableCopy(class_1299<? extends EntityThrowableCopy> type, class_1309 livingEntityIn, class_1937 worldIn) {
		this(type, livingEntityIn.method_23317(), livingEntityIn.method_23320() - (double) 0.1F, livingEntityIn.method_23321(), worldIn);
		this.method_7432(livingEntityIn);
	}

	/**
	 * Checks if the entity is in range to render.
	 */
	@Override
	@Environment(EnvType.CLIENT)
	public boolean method_5640(double distance) {
		double d0 = this.method_5829().method_995() * 4.0D;
		if (Double.isNaN(d0)) {
			d0 = 4.0D;
		}

		d0 = d0 * 64.0D;
		return distance < d0 * d0;
	}

	/**
	 * Called to update the entity's position/logic.
	 */
	@Override
	public void method_5773() {
		super.method_5773();
		class_239 raytraceresult = class_1675.method_18074(this, this::method_26958);
		boolean flag = false;
		if (raytraceresult.method_17783() == class_239.class_240.field_1332) {
			class_2338 blockpos = ((class_3965) raytraceresult).method_17777();
			class_2680 blockstate = this.field_6002.method_8320(blockpos);
			if (blockstate.method_27852(class_2246.field_10316)) {
				this.method_5717(blockpos);
				flag = true;
			} else if (blockstate.method_27852(class_2246.field_10613)) {
				class_2586 tileentity = this.field_6002.method_8321(blockpos);
				if (tileentity instanceof class_2643) {
					((class_2643) tileentity).method_11409(this);
				}

				flag = true;
			}
		}

		if (raytraceresult.method_17783() != class_239.class_240.field_1333 && !flag) {
			this.method_7488(raytraceresult);
		}

		this.method_5852();
		class_243 vector3d = this.method_18798();
		double d2 = this.method_23317() + vector3d.field_1352;
		double d0 = this.method_23318() + vector3d.field_1351;
		double d1 = this.method_23321() + vector3d.field_1350;
		this.method_26962();
		float f;
		if (this.method_5799()) {
			for (int i = 0; i < 4; ++i) {
				float f1 = 0.25F;
				this.field_6002.method_8406(class_2398.field_11247, d2 - vector3d.field_1352 * 0.25D, d0 - vector3d.field_1351 * 0.25D, d1 - vector3d.field_1350 * 0.25D, vector3d.field_1352, vector3d.field_1351, vector3d.field_1350);
			}

			f = 0.8F;
		} else {
			f = 0.99F;
		}

		this.method_18799(vector3d.method_1021((double) f));
		if (!this.method_5740()) {
			class_243 vector3d1 = this.method_18798();
			this.method_18800(vector3d1.field_1352, vector3d1.field_1351 - (double) this.getGravityVelocity(), vector3d1.field_1350);
		}

		this.method_5814(d2, d0, d1);
	}

	/**
	 * Gets the amount of gravity to apply to the thrown entity with each tick.
	 */
	protected float getGravityVelocity() {
		return 0.03F;
	}

	@Override
	public class_2596<?> method_18002() {
		return new class_2604(this);
	}
}
