/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import net.fabricmc.fabric.api.entity.EntityPickInteractionAware;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.mana.spark.SparkUpgradeType;
import vazkii.botania.common.item.ItemSparkUpgrade;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketSpawnEntity;

import javax.annotation.Nonnull;

import java.util.*;
import java.util.stream.Collectors;

public class EntitySpark extends EntitySparkBase implements ISparkEntity, EntityPickInteractionAware {
	private static final int TRANSFER_RATE = 1000;
	private static final String TAG_UPGRADE = "upgrade";
	private static final class_2940<Integer> UPGRADE = class_2945.method_12791(EntitySpark.class, class_2943.field_13327);

	private final Set<ISparkEntity> transfers = Collections.newSetFromMap(new WeakHashMap<>());

	private int removeTransferants = 2;

	public EntitySpark(class_1299<EntitySpark> type, class_1937 world) {
		super(type, world);
	}

	public EntitySpark(class_1937 world) {
		this(ModEntities.SPARK, world);
	}

	@Override
	protected void method_5693() {
		super.method_5693();
		field_6011.method_12784(UPGRADE, 0);
	}

	@Nonnull
	@Override
	public class_1799 getPickedStack(class_1657 player, class_239 target) {
		return new class_1799(ModItems.spark);
	}

	@Override
	public void method_5773() {
		super.method_5773();

		if (field_6002.field_9236) {
			return;
		}

		ISparkAttachable tile = getAttachedTile();
		if (tile == null) {
			dropAndKill();
			return;
		}

		SparkUpgradeType upgrade = getUpgrade();
		Collection<ISparkEntity> transfers = getTransfers();

		switch (upgrade) {
		case DISPERSIVE: {
			List<class_1657> players = SparkHelper.getEntitiesAround(class_1657.class, field_6002, method_23317(), method_23318() + (method_17682() / 2.0), method_23321());

			Map<class_1657, Map<class_1799, Integer>> receivingPlayers = new HashMap<>();

			class_1799 input = new class_1799(ModItems.spark);
			for (class_1657 player : players) {
				List<class_1799> stacks = new ArrayList<>();
				stacks.addAll(player.field_7514.field_7547);
				stacks.addAll(player.field_7514.field_7548);

				class_1263 inv = BotaniaAPI.instance().getAccessoriesInventory(player);
				for (int i = 0; i < inv.method_5439(); i++) {
					stacks.add(inv.method_5438(i));
				}

				for (class_1799 stack : stacks) {
					if (stack.method_7960() || !(stack.method_7909() instanceof IManaItem)) {
						continue;
					}

					IManaItem manaItem = (IManaItem) stack.method_7909();
					if (manaItem.canReceiveManaFromItem(stack, input)) {
						Map<class_1799, Integer> receivingStacks;
						boolean add = false;
						if (!receivingPlayers.containsKey(player)) {
							add = true;
							receivingStacks = new HashMap<>();
						} else {
							receivingStacks = receivingPlayers.get(player);
						}

						int recv = Math.min(getAttachedTile().getCurrentMana(), Math.min(TRANSFER_RATE, manaItem.getMaxMana(stack) - manaItem.getMana(stack)));
						if (recv > 0) {
							receivingStacks.put(stack, recv);
							if (add) {
								receivingPlayers.put(player, receivingStacks);
							}
						}
					}
				}
			}

			if (!receivingPlayers.isEmpty()) {
				List<class_1657> keys = new ArrayList<>(receivingPlayers.keySet());
				Collections.shuffle(keys);
				class_1657 player = keys.iterator().next();

				Map<class_1799, Integer> items = receivingPlayers.get(player);
				class_1799 stack = items.keySet().iterator().next();
				int cost = items.get(stack);
				int manaToPut = Math.min(getAttachedTile().getCurrentMana(), cost);
				((IManaItem) stack.method_7909()).addMana(stack, manaToPut);
				getAttachedTile().receiveMana(-manaToPut);
				particlesTowards(player);
			}

			break;
		}
		case DOMINANT: {
			List<ISparkEntity> validSparks = SparkHelper.getSparksAround(field_6002, method_23317(), method_23318() + (method_17682() / 2), method_23321(), getNetwork())
					.filter(s -> {
						SparkUpgradeType otherUpgrade = s.getUpgrade();
						return s != this && otherUpgrade == SparkUpgradeType.NONE && s.getAttachedTile() instanceof IManaPool;
					})
					.collect(Collectors.toList());
			if (validSparks.size() > 0) {
				validSparks.get(field_6002.field_9229.nextInt(validSparks.size())).registerTransfer(this);
			}

			break;
		}
		case RECESSIVE: {
			SparkHelper.getSparksAround(field_6002, method_23317(), method_23318() + (method_17682() / 2), method_23321(), getNetwork())
					.filter(s -> {
						SparkUpgradeType otherUpgrade = s.getUpgrade();
						return s != this
								&& otherUpgrade != SparkUpgradeType.DOMINANT
								&& otherUpgrade != SparkUpgradeType.RECESSIVE
								&& otherUpgrade != SparkUpgradeType.ISOLATED;
					})
					.forEach(transfers::add);
			break;
		}
		case NONE:
		default:
			break;
		}

		if (!transfers.isEmpty()) {
			int manaTotal = Math.min(TRANSFER_RATE * transfers.size(), tile.getCurrentMana());
			int count = transfers.size();
			int manaSpent = 0;

			if (manaTotal > 0) {
				for (ISparkEntity spark : transfers) {
					count--;
					if (spark.getAttachedTile() == null || spark.getAttachedTile().isFull() || spark.areIncomingTransfersDone()) {
						continue;
					}

					ISparkAttachable attached = spark.getAttachedTile();
					int spend = Math.min(attached.getAvailableSpaceForMana(), (manaTotal - manaSpent) / (count + 1));
					attached.receiveMana(spend);
					manaSpent += spend;

					particlesTowards((class_1297) spark);
				}
				tile.receiveMana(-manaSpent);
			}
		}

		if (removeTransferants > 0) {
			removeTransferants--;
		}
		filterTransfers();
	}

	private void particlesTowards(class_1297 e) {
		PacketBotaniaEffect.sendNearby(this, PacketBotaniaEffect.EffectType.SPARK_MANA_FLOW, method_23317(), method_23318(), method_23321(),
				method_5628(), e.method_5628());
	}

	public static void particleBeam(class_1657 player, class_1297 e1, class_1297 e2) {
		if (e1 != null && e2 != null && !e1.field_6002.field_9236) {
			PacketBotaniaEffect.send(player, PacketBotaniaEffect.EffectType.SPARK_NET_INDICATOR, e1.method_23317(), e1.method_23318(), e1.method_23321(),
					e1.method_5628(), e2.method_5628());
		}
	}

	private void dropAndKill() {
		SparkUpgradeType upgrade = getUpgrade();
		method_5699(new class_1799(ModItems.spark), 0F);
		if (upgrade != SparkUpgradeType.NONE) {
			method_5699(ItemSparkUpgrade.getByType(upgrade), 0F);
		}
		method_5650();
	}

	@Override
	public class_1269 method_5688(class_1657 player, class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		if (method_5805() && !stack.method_7960()) {
			SparkUpgradeType upgrade = getUpgrade();
			if (stack.method_7909() == ModItems.twigWand) {
				if (!field_6002.field_9236) {
					if (player.method_5715()) {
						if (upgrade != SparkUpgradeType.NONE) {
							method_5699(ItemSparkUpgrade.getByType(upgrade), 0F);
							setUpgrade(SparkUpgradeType.NONE);

							transfers.clear();
							removeTransferants = 2;
						} else {
							dropAndKill();
						}
					} else {
						SparkHelper.getSparksAround(field_6002, method_23317(), method_23318() + (method_17682() / 2), method_23321(), getNetwork())
								.forEach(s -> particleBeam(player, this, (class_1297) s));
					}
				}

				return class_1269.method_29236(field_6002.field_9236);
			} else if (stack.method_7909() instanceof ItemSparkUpgrade && upgrade == SparkUpgradeType.NONE) {
				if (!field_6002.field_9236) {
					setUpgrade(((ItemSparkUpgrade) stack.method_7909()).type);
					stack.method_7934(1);
				}
				return class_1269.method_29236(field_6002.field_9236);
			} else if (stack.method_7909() == ModItems.phantomInk) {
				if (!field_6002.field_9236) {
					method_5648(true);
				}
				return class_1269.method_29236(field_6002.field_9236);
			} else if (stack.method_7909() instanceof class_1769) {
				class_1767 color = ((class_1769) stack.method_7909()).method_7802();
				if (color != getNetwork()) {
					if (!field_6002.field_9236) {
						setNetwork(color);
						stack.method_7934(1);
					}
					return class_1269.method_29236(field_6002.field_9236);
				}
			}
		}

		return class_1269.field_5811;
	}

	@Nonnull
	@Override
	public class_2596<?> method_18002() {
		return PacketSpawnEntity.make(this);
	}

	@Override
	protected void method_5749(@Nonnull class_2487 cmp) {
		super.method_5749(cmp);
		setUpgrade(SparkUpgradeType.values()[cmp.method_10550(TAG_UPGRADE)]);
	}

	@Override
	protected void method_5652(@Nonnull class_2487 cmp) {
		super.method_5652(cmp);
		cmp.method_10569(TAG_UPGRADE, getUpgrade().ordinal());
	}

	@Override
	public ISparkAttachable getAttachedTile() {
		int x = class_3532.method_15357(method_23317());
		int y = class_3532.method_15357(method_23318()) - 1;
		int z = class_3532.method_15357(method_23321());
		class_2586 tile = field_6002.method_8321(new class_2338(x, y, z));
		if (tile instanceof ISparkAttachable) {
			return (ISparkAttachable) tile;
		}

		return null;
	}

	private void filterTransfers() {
		Iterator<ISparkEntity> iter = transfers.iterator();
		while (iter.hasNext()) {
			ISparkEntity spark = iter.next();
			SparkUpgradeType upgr = getUpgrade();
			SparkUpgradeType supgr = spark.getUpgrade();
			ISparkAttachable atile = spark.getAttachedTile();

			if (spark == this
					|| spark.areIncomingTransfersDone()
					|| getNetwork() != spark.getNetwork()
					|| atile == null
					|| atile.isFull()
					|| !(upgr == SparkUpgradeType.NONE && supgr == SparkUpgradeType.DOMINANT
							|| upgr == SparkUpgradeType.RECESSIVE && (supgr == SparkUpgradeType.NONE || supgr == SparkUpgradeType.DISPERSIVE)
							|| !(atile instanceof IManaPool))) {
				iter.remove();
			}
		}
	}

	@Override
	public Collection<ISparkEntity> getTransfers() {
		filterTransfers();
		return transfers;
	}

	private boolean hasTransfer(ISparkEntity entity) {
		return transfers.contains(entity);
	}

	@Override
	public void registerTransfer(ISparkEntity entity) {
		if (hasTransfer(entity)) {
			return;
		}
		transfers.add(entity);
	}

	@Override
	public SparkUpgradeType getUpgrade() {
		return SparkUpgradeType.values()[field_6011.method_12789(UPGRADE)];
	}

	@Override
	public void setUpgrade(SparkUpgradeType upgrade) {
		field_6011.method_12778(UPGRADE, upgrade.ordinal());
	}

	@Override
	public boolean areIncomingTransfersDone() {
		ISparkAttachable tile = getAttachedTile();
		if (tile instanceof IManaPool) {
			return removeTransferants > 0;
		}
		return tile != null && tile.areIncomingTranfersDone();
	}

}
