/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import vazkii.botania.mixin.AccessorGoalSelector;
import vazkii.botania.mixin.AccessorWitherEntity;

import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1381;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1528;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_3222;

public class EntityPinkWither extends class_1528 {
	public EntityPinkWither(class_1299<EntityPinkWither> type, class_1937 world) {
		super(type, world);
	}

	@Override
	protected void method_5959() {
		super.method_5959();

		// Remove firing wither skulls
		((AccessorGoalSelector) field_6201).getGoals().removeIf(entry -> entry.method_19058() instanceof class_1381);

		// Remove revenge and aggro
		((AccessorGoalSelector) field_6185).getGoals().removeIf(entry -> entry.method_19058() instanceof class_1399
				|| entry.method_19058() instanceof class_1400);
	}

	@Override
	public void method_6007() {
		super.method_6007();

		if (Math.random() < 0.1) {
			for (int j = 0; j < 3; ++j) {
				double x = ((AccessorWitherEntity) this).botania_getHeadX(j);
				double y = ((AccessorWitherEntity) this).botania_getHeadY(j);
				double z = ((AccessorWitherEntity) this).botania_getHeadZ(j);
				field_6002.method_8406(class_2398.field_11201, x + field_5974.nextGaussian() * 0.3, y + field_5974.nextGaussian() * 0.3, z + field_5974.nextGaussian() * 0.3, 0.0D, 0.0D, 0.0D);
			}
		}
	}

	@Override
	protected void method_6099(class_1282 source, int lootingMultiplier, boolean allowDrops) {}

	@Override
	public void method_5958() {
		if (field_6012 % 20 == 0) {
			method_6025(1.0F);
		}
	}

	@Override
	protected class_1269 method_5992(class_1657 player, class_1268 hand) {
		if (!player.method_5715()) {
			player.method_5804(this);
			return class_1269.field_5812;
		}
		return class_1269.field_5811;
	}

	@Override
	public void method_5837(@Nonnull class_3222 player) {}
}
