/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.block.*;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1682;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3965;
import net.minecraft.util.math.*;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.*;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.network.PacketSpawnEntity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import java.util.*;

public class EntityManaBurst extends class_1682 implements IManaBurst {
	private static final String TAG_TICKS_EXISTED = "ticksExisted";
	private static final String TAG_COLOR = "color";
	private static final String TAG_MANA = "mana";
	private static final String TAG_STARTING_MANA = "startingMana";
	private static final String TAG_MIN_MANA_LOSS = "minManaLoss";
	private static final String TAG_TICK_MANA_LOSS = "manaLossTick";
	private static final String TAG_SPREADER_X = "spreaderX";
	private static final String TAG_SPREADER_Y = "spreaderY";
	private static final String TAG_SPREADER_Z = "spreaderZ";
	private static final String TAG_GRAVITY = "gravity";
	private static final String TAG_LENS_STACK = "lensStack";
	private static final String TAG_LAST_MOTION_X = "lastMotionX";
	private static final String TAG_LAST_MOTION_Y = "lastMotionY";
	private static final String TAG_LAST_MOTION_Z = "lastMotionZ";
	private static final String TAG_HAS_SHOOTER = "hasShooter";
	private static final String TAG_SHOOTER = "shooterUUID";
	private static final String TAG_LAST_COLLISION_X = "lastCollisionX";
	private static final String TAG_LAST_COLLISION_Y = "lastCollisionY";
	private static final String TAG_LAST_COLLISION_Z = "lastCollisionZ";
	private static final String TAG_WARPED = "warped";
	private static final String TAG_ORBIT_TIME = "orbitTime";
	private static final String TAG_TRIPPED = "tripped";
	private static final String TAG_MAGNETIZE_POS = "magnetizePos";

	private static final class_2940<Integer> COLOR = class_2945.method_12791(EntityManaBurst.class, class_2943.field_13327);
	private static final class_2940<Integer> MANA = class_2945.method_12791(EntityManaBurst.class, class_2943.field_13327);
	private static final class_2940<Integer> START_MANA = class_2945.method_12791(EntityManaBurst.class, class_2943.field_13327);
	private static final class_2940<Integer> MIN_MANA_LOSS = class_2945.method_12791(EntityManaBurst.class, class_2943.field_13327);
	private static final class_2940<Float> MANA_LOSS_PER_TICK = class_2945.method_12791(EntityManaBurst.class, class_2943.field_13320);
	private static final class_2940<Float> GRAVITY = class_2945.method_12791(EntityManaBurst.class, class_2943.field_13320);
	private static final class_2940<class_2338> SOURCE_COORDS = class_2945.method_12791(EntityManaBurst.class, class_2943.field_13324);
	private static final class_2940<class_1799> SOURCE_LENS = class_2945.method_12791(EntityManaBurst.class, class_2943.field_13322);

	private float accumulatedManaLoss = 0;
	private boolean fake = false;
	private final Set<class_2338> alreadyCollidedAt = new HashSet<>();
	private boolean fullManaLastTick = true;
	private UUID shooterIdentity = null;
	private int _ticksExisted = 0;
	private boolean scanBeam = false;
	private class_2338 lastCollision;
	private boolean warped = false;
	private int orbitTime = 0;
	private boolean tripped = false;
	private class_2338 magnetizePos = null;

	public final List<PositionProperties> propsList = new ArrayList<>();

	public EntityManaBurst(class_1299<EntityManaBurst> type, class_1937 world) {
		super(type, world);
	}

	@Override
	protected void method_5693() {
		field_6011.method_12784(COLOR, 0);
		field_6011.method_12784(MANA, 0);
		field_6011.method_12784(START_MANA, 0);
		field_6011.method_12784(MIN_MANA_LOSS, 0);
		field_6011.method_12784(MANA_LOSS_PER_TICK, 0F);
		field_6011.method_12784(GRAVITY, 0F);
		field_6011.method_12784(SOURCE_COORDS, class_2338.field_10980);
		field_6011.method_12784(SOURCE_LENS, class_1799.field_8037);
	}

	public EntityManaBurst(IManaSpreader spreader, boolean fake) {
		this(ModEntities.MANA_BURST, ((class_2586) spreader).method_10997());

		class_2586 tile = spreader.tileEntity();

		this.fake = fake;

		setBurstSourceCoords(tile.method_11016());
		method_5808(tile.method_11016().method_10263() + 0.5, tile.method_11016().method_10264() + 0.5, tile.method_11016().method_10260() + 0.5, 0, 0);
		field_6031 = -(spreader.getRotationX() + 90F);
		field_5965 = spreader.getRotationY();

		float f = 0.4F;
		double mx = class_3532.method_15374(field_6031 / 180.0F * (float) Math.PI) * class_3532.method_15362(field_5965 / 180.0F * (float) Math.PI) * f / 2D;
		double mz = -(class_3532.method_15362(field_6031 / 180.0F * (float) Math.PI) * class_3532.method_15362(field_5965 / 180.0F * (float) Math.PI) * f) / 2D;
		double my = class_3532.method_15374(field_5965 / 180.0F * (float) Math.PI) * f / 2D;
		setBurstMotion(mx, my, mz);
	}

	public EntityManaBurst(class_1657 player) {
		super(ModEntities.MANA_BURST, player, player.field_6002);

		setBurstSourceCoords(new class_2338(0, -1, 0));
		method_5710(player.field_6031 + 180, -player.field_5965);

		float f = 0.4F;
		double mx = class_3532.method_15374(field_6031 / 180.0F * (float) Math.PI) * class_3532.method_15362(field_5965 / 180.0F * (float) Math.PI) * f / 2D;
		double mz = -(class_3532.method_15362(field_6031 / 180.0F * (float) Math.PI) * class_3532.method_15362(field_5965 / 180.0F * (float) Math.PI) * f) / 2D;
		double my = class_3532.method_15374(field_5965 / 180.0F * (float) Math.PI) * f / 2D;
		setBurstMotion(mx, my, mz);
	}

	@Override
	public void method_5773() {
		setTicksExisted(getTicksExisted() + 1);
		super.method_5773();

		if (!fake && method_5805() && !scanBeam) {
			ping();
		}

		ILensEffect lens = getLensInstance();
		if (lens != null) {
			lens.updateBurst(this, getSourceLens());
		}

		int mana = getMana();
		if (getTicksExisted() >= getMinManaLoss()) {
			accumulatedManaLoss += getManaLossPerTick();
			int loss = (int) accumulatedManaLoss;
			setMana(mana - loss);
			accumulatedManaLoss -= loss;

			if (getMana() <= 0) {
				method_5650();
			}
		}

		particles();

		setBurstMotion(method_18798().method_10216(), method_18798().method_10214(), method_18798().method_10215());

		fullManaLastTick = getMana() == getStartingMana();

		if (scanBeam) {
			PositionProperties props = new PositionProperties(this);
			if (propsList.isEmpty()) {
				propsList.add(props);
			} else {
				PositionProperties lastProps = propsList.get(propsList.size() - 1);
				if (!props.coordsEqual(lastProps)) {
					propsList.add(props);
				}
			}
		}
	}

	@Override
	@Environment(EnvType.CLIENT)
	public void method_5759(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
		method_5814(x, y, z);
		method_5710(yaw, pitch);
	}

	@Override
	public boolean method_5692(class_3494<class_3611> fluid, double mag) {
		return false;
	}

	@Override
	public boolean method_5771() {
		return false;
	}

	private class_2586 collidedTile = null;
	private boolean noParticles = false;

	public class_2586 getCollidedTile(boolean noParticles) {
		this.noParticles = noParticles;

		int iterations = 0;
		while (method_5805() && iterations < ConfigHandler.COMMON.spreaderTraceTime.getValue()) {
			method_5773();
			iterations++;
		}

		if (fake) {
			incrementFakeParticleTick();
		}

		return collidedTile;
	}

	@Override
	public void method_5652(class_2487 tag) {
		super.method_5652(tag);
		tag.method_10569(TAG_TICKS_EXISTED, getTicksExisted());
		tag.method_10569(TAG_COLOR, getColor());
		tag.method_10569(TAG_MANA, getMana());
		tag.method_10569(TAG_STARTING_MANA, getStartingMana());
		tag.method_10569(TAG_MIN_MANA_LOSS, getMinManaLoss());
		tag.method_10548(TAG_TICK_MANA_LOSS, getManaLossPerTick());
		tag.method_10548(TAG_GRAVITY, method_7490());

		class_1799 stack = getSourceLens();
		class_2487 lensCmp = new class_2487();
		if (!stack.method_7960()) {
			lensCmp = stack.method_7953(lensCmp);
		}
		tag.method_10566(TAG_LENS_STACK, lensCmp);

		class_2338 coords = getBurstSourceBlockPos();
		tag.method_10569(TAG_SPREADER_X, coords.method_10263());
		tag.method_10569(TAG_SPREADER_Y, coords.method_10264());
		tag.method_10569(TAG_SPREADER_Z, coords.method_10260());

		tag.method_10549(TAG_LAST_MOTION_X, method_18798().method_10216());
		tag.method_10549(TAG_LAST_MOTION_Y, method_18798().method_10214());
		tag.method_10549(TAG_LAST_MOTION_Z, method_18798().method_10215());

		if (lastCollision != null) {
			tag.method_10569(TAG_LAST_COLLISION_X, coords.method_10263());
			tag.method_10569(TAG_LAST_COLLISION_Y, coords.method_10264());
			tag.method_10569(TAG_LAST_COLLISION_Z, coords.method_10260());
		}

		UUID identity = getShooterUUID();
		boolean hasShooter = identity != null;
		tag.method_10556(TAG_HAS_SHOOTER, hasShooter);
		if (hasShooter) {
			tag.method_25927(TAG_SHOOTER, identity);
		}
		tag.method_10556(TAG_WARPED, warped);
		tag.method_10569(TAG_ORBIT_TIME, orbitTime);
		tag.method_10556(TAG_TRIPPED, tripped);
		if (magnetizePos != null) {
			tag.method_10566(TAG_MAGNETIZE_POS, class_2338.field_25064.encodeStart(class_2509.field_11560, magnetizePos).get().orThrow());
		}
	}

	@Override
	public void method_5749(class_2487 cmp) {
		super.method_5749(cmp);
		setTicksExisted(cmp.method_10550(TAG_TICKS_EXISTED));
		setColor(cmp.method_10550(TAG_COLOR));
		setMana(cmp.method_10550(TAG_MANA));
		setStartingMana(cmp.method_10550(TAG_STARTING_MANA));
		setMinManaLoss(cmp.method_10550(TAG_MIN_MANA_LOSS));
		setManaLossPerTick(cmp.method_10583(TAG_TICK_MANA_LOSS));
		setGravity(cmp.method_10583(TAG_GRAVITY));

		class_2487 lensCmp = cmp.method_10562(TAG_LENS_STACK);
		class_1799 stack = class_1799.method_7915(lensCmp);
		if (!stack.method_7960()) {
			setSourceLens(stack);
		} else {
			setSourceLens(class_1799.field_8037);
		}

		int x = cmp.method_10550(TAG_SPREADER_X);
		int y = cmp.method_10550(TAG_SPREADER_Y);
		int z = cmp.method_10550(TAG_SPREADER_Z);

		setBurstSourceCoords(new class_2338(x, y, z));

		if (cmp.method_10545(TAG_LAST_COLLISION_X)) {
			x = cmp.method_10550(TAG_SPREADER_X);
			y = cmp.method_10550(TAG_SPREADER_Y);
			z = cmp.method_10550(TAG_SPREADER_Z);
			lastCollision = new class_2338(x, y, z);
		}

		double lastMotionX = cmp.method_10574(TAG_LAST_MOTION_X);
		double lastMotionY = cmp.method_10574(TAG_LAST_MOTION_Y);
		double lastMotionZ = cmp.method_10574(TAG_LAST_MOTION_Z);

		setBurstMotion(lastMotionX, lastMotionY, lastMotionZ);

		boolean hasShooter = cmp.method_10577(TAG_HAS_SHOOTER);
		if (hasShooter) {
			UUID serializedUuid = cmp.method_25926(TAG_SHOOTER);
			UUID identity = getShooterUUID();
			if (!serializedUuid.equals(identity)) {
				setShooterUUID(serializedUuid);
			}
		}
		warped = cmp.method_10577(TAG_WARPED);
		orbitTime = cmp.method_10550(TAG_ORBIT_TIME);
		tripped = cmp.method_10577(TAG_TRIPPED);
		if (cmp.method_10545(TAG_MAGNETIZE_POS)) {
			magnetizePos = class_2338.field_25064.parse(class_2509.field_11560, cmp.method_10580(TAG_MAGNETIZE_POS)).get().orThrow();
		} else {
			magnetizePos = null;
		}
	}

	public void particles() {
		if (!method_5805() || !field_6002.field_9236) {
			return;
		}

		ILensEffect lens = getLensInstance();
		if (lens != null && !lens.doParticles(this, getSourceLens())) {
			return;
		}

		int color = getColor();
		float r = (color >> 16 & 0xFF) / 255F;
		float g = (color >> 8 & 0xFF) / 255F;
		float b = (color & 0xFF) / 255F;
		float osize = getParticleSize();
		float size = osize;

		if (fake) {
			if (getMana() == getStartingMana()) {
				size = 2F;
			} else if (fullManaLastTick) {
				size = 4F;
			}

			if (!noParticles && shouldDoFakeParticles()) {
				SparkleParticleData data = SparkleParticleData.fake(0.4F * size, r, g, b, 1);
				Botania.proxy.addParticleForce(field_6002, data, method_23317(), method_23318(), method_23321(), 0, 0, 0);
			}
		} else {
			boolean depth = !Botania.proxy.isClientPlayerWearingMonocle();

			if (ConfigHandler.CLIENT.subtlePowerSystem.getValue()) {
				WispParticleData data = WispParticleData.wisp(0.1F * size, r, g, b, depth);
				Botania.proxy.addParticleForceNear(field_6002, data, method_23317(), method_23318(), method_23321(), (float) (Math.random() - 0.5F) * 0.02F, (float) (Math.random() - 0.5F) * 0.02F, (float) (Math.random() - 0.5F) * 0.01F);
			} else {
				float or = r;
				float og = g;
				float ob = b;

				double luminance = 0.2126 * r + 0.7152 * g + 0.0722 * b; // Standard relative luminance calculation

				double iterX = method_23317();
				double iterY = method_23318();
				double iterZ = method_23321();

				class_243 currentPos = method_19538();
				class_243 oldPos = new class_243(field_6014, field_6036, field_5969);
				class_243 diffVec = oldPos.method_1020(currentPos);
				class_243 diffVecNorm = diffVec.method_1029();

				double distance = 0.095;

				do {
					if (luminance < 0.1) {
						r = or + (float) Math.random() * 0.125F;
						g = og + (float) Math.random() * 0.125F;
						b = ob + (float) Math.random() * 0.125F;
					}
					size = osize + ((float) Math.random() - 0.5F) * 0.065F + (float) Math.sin(new Random(field_6021.getMostSignificantBits()).nextInt(9001)) * 0.4F;
					WispParticleData data = WispParticleData.wisp(0.2F * size, r, g, b, depth);
					Botania.proxy.addParticleForceNear(field_6002, data, iterX, iterY, iterZ,
							(float) -method_18798().method_10216() * 0.01F,
							(float) -method_18798().method_10214() * 0.01F,
							(float) -method_18798().method_10215() * 0.01F);

					iterX += diffVecNorm.field_1352 * distance;
					iterY += diffVecNorm.field_1351 * distance;
					iterZ += diffVecNorm.field_1350 * distance;

					currentPos = new class_243(iterX, iterY, iterZ);
					diffVec = oldPos.method_1020(currentPos);
					if (getOrbitTime() > 0) {
						break;
					}
				} while (Math.abs(diffVec.method_1033()) > distance);

				WispParticleData data = WispParticleData.wisp(0.1F * size, or, og, ob, depth);
				field_6002.method_8406(data, iterX, iterY, iterZ, (float) (Math.random() - 0.5F) * 0.06F, (float) (Math.random() - 0.5F) * 0.06F, (float) (Math.random() - 0.5F) * 0.06F);
			}
		}
	}

	public float getParticleSize() {
		return (float) getMana() / (float) getStartingMana();
	}

	@Override
	protected void method_7488(@Nonnull class_239 rtr) {
		class_2338 pos = null;
		boolean dead = false;

		if (rtr.method_17783() == class_239.class_240.field_1332) {
			pos = ((class_3965) rtr).method_17777();
			if (pos.equals(lastCollision)) {
				return;
			}
			lastCollision = pos.method_10062();
			class_2586 tile = field_6002.method_8321(pos);
			class_2680 state = field_6002.method_8320(pos);
			class_2248 block = state.method_26204();

			if (block instanceof IManaCollisionGhost
					&& ((IManaCollisionGhost) block).isGhost(state, field_6002, pos)
					&& !(block instanceof IManaTrigger)
					|| block instanceof class_2261
					|| block instanceof class_2397) {
				return;
			}

			class_2338 coords = getBurstSourceBlockPos();
			if (tile != null && !tile.method_11016().equals(coords)) {
				collidedTile = tile;
			}

			if (tile == null || !tile.method_11016().equals(coords)) {
				if (!fake && !noParticles && !field_6002.field_9236 && tile instanceof IManaReceiver && ((IManaReceiver) tile).canReceiveManaFromBursts()) {
					onReceiverImpact((IManaReceiver) tile, tile.method_11016());
				}

				if (block instanceof IManaTrigger) {
					((IManaTrigger) block).onBurstCollision(this, field_6002, pos);
				}

				boolean ghost = block instanceof IManaCollisionGhost;
				dead = !ghost;
				if (ghost) {
					return;
				}
			}
		}

		ILensEffect lens = getLensInstance();
		if (lens != null) {
			dead = lens.collideBurst(this, rtr, collidedTile instanceof IManaReceiver
					&& ((IManaReceiver) collidedTile).canReceiveManaFromBursts(), dead, getSourceLens());
		}

		if (pos != null && !hasAlreadyCollidedAt(pos)) {
			alreadyCollidedAt.add(pos);
		}

		if (dead && method_5805()) {
			if (!fake && field_6002.field_9236) {
				int color = getColor();
				float r = (color >> 16 & 0xFF) / 255F;
				float g = (color >> 8 & 0xFF) / 255F;
				float b = (color & 0xFF) / 255F;

				int mana = getMana();
				int maxMana = getStartingMana();
				float size = (float) mana / (float) maxMana;

				if (!ConfigHandler.CLIENT.subtlePowerSystem.getValue()) {
					for (int i = 0; i < 4; i++) {
						WispParticleData data = WispParticleData.wisp(0.15F * size, r, g, b);
						field_6002.method_8406(data, method_23317(), method_23318(), method_23321(), (float) (Math.random() - 0.5F) * 0.04F, (float) (Math.random() - 0.5F) * 0.04F, (float) (Math.random() - 0.5F) * 0.04F);
					}
				}
				SparkleParticleData data = SparkleParticleData.sparkle((float) 4, r, g, b, 2);
				field_6002.method_8406(data, method_23317(), method_23318(), method_23321(), 0, 0, 0);
			}

			method_5650();
		}
	}

	private void onReceiverImpact(IManaReceiver tile, class_2338 pos) {
		if (hasWarped()) {
			return;
		}

		ILensEffect lens = getLensInstance();
		int mana = getMana();

		if (lens != null) {
			class_1799 stack = getSourceLens();
			mana = lens.getManaToTransfer(this, stack, tile);
		}

		if (tile instanceof IManaCollector) {
			mana *= ((IManaCollector) tile).getManaYieldMultiplier(this);
		}

		tile.receiveMana(mana);

		if (tile instanceof IThrottledPacket) {
			((IThrottledPacket) tile).markDispatchable();
		} else {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile.tileEntity());
		}
	}

	@Override
	public void method_5650() {
		super.method_5650();

		if (!fake) {
			class_2586 tile = getShooter();
			if (tile instanceof IManaSpreader) {
				((IManaSpreader) tile).setCanShoot(true);
			}
		} else {
			setDeathTicksForFakeParticle();
		}
	}

	private class_2586 getShooter() {
		return field_6002.method_8321(getBurstSourceBlockPos());
	}

	@Override
	protected float method_7490() {
		return getBurstGravity();
	}

	@Override
	public boolean isFake() {
		return fake;
	}

	@Override
	public void setFake(boolean fake) {
		this.fake = fake;
	}

	public void setScanBeam() {
		scanBeam = true;
	}

	@Override
	public int getColor() {
		return field_6011.method_12789(COLOR);
	}

	@Override
	public void setColor(int color) {
		field_6011.method_12778(COLOR, color);
	}

	@Override
	public int getMana() {
		return field_6011.method_12789(MANA);
	}

	@Override
	public void setMana(int mana) {
		field_6011.method_12778(MANA, mana);
	}

	@Override
	public int getStartingMana() {
		return field_6011.method_12789(START_MANA);
	}

	@Override
	public void setStartingMana(int mana) {
		field_6011.method_12778(START_MANA, mana);
	}

	@Override
	public int getMinManaLoss() {
		return field_6011.method_12789(MIN_MANA_LOSS);
	}

	@Override
	public void setMinManaLoss(int minManaLoss) {
		field_6011.method_12778(MIN_MANA_LOSS, minManaLoss);
	}

	@Override
	public float getManaLossPerTick() {
		return field_6011.method_12789(MANA_LOSS_PER_TICK);
	}

	@Override
	public void setManaLossPerTick(float mana) {
		field_6011.method_12778(MANA_LOSS_PER_TICK, mana);
	}

	@Override
	public float getBurstGravity() {
		return field_6011.method_12789(GRAVITY);
	}

	@Override
	public void setGravity(float gravity) {
		field_6011.method_12778(GRAVITY, gravity);
	}

	@Override
	public class_2338 getBurstSourceBlockPos() {
		return field_6011.method_12789(SOURCE_COORDS);
	}

	@Override
	public void setBurstSourceCoords(class_2338 pos) {
		field_6011.method_12778(SOURCE_COORDS, pos);
	}

	@Override
	public class_1799 getSourceLens() {
		return field_6011.method_12789(SOURCE_LENS);
	}

	@Override
	public void setSourceLens(class_1799 lens) {
		field_6011.method_12778(SOURCE_LENS, lens);
	}

	@Override
	public int getTicksExisted() {
		return _ticksExisted;
	}

	public void setTicksExisted(int ticks) {
		_ticksExisted = ticks;
	}

	private ILensEffect getLensInstance() {
		class_1799 lens = getSourceLens();
		if (!lens.method_7960() && lens.method_7909() instanceof ILensEffect) {
			return (ILensEffect) lens.method_7909();
		}

		return null;
	}

	@Override
	public void setBurstMotion(double x, double y, double z) {
		this.method_18800(x, y, z);
	}

	@Override
	public boolean hasAlreadyCollidedAt(class_2338 pos) {
		return alreadyCollidedAt.contains(pos);
	}

	@Override
	public void setCollidedAt(class_2338 pos) {
		if (!hasAlreadyCollidedAt(pos)) {
			alreadyCollidedAt.add(pos.method_10062());
		}
	}

	@Override
	public void setShooterUUID(UUID uuid) {
		shooterIdentity = uuid;
	}

	@Override
	public UUID getShooterUUID() {
		return shooterIdentity;
	}

	@Override
	public void ping() {
		class_2586 tile = getShooter();
		if (tile instanceof IPingable) {
			((IPingable) tile).pingback(this, getShooterUUID());
		}
	}

	@Override
	public boolean hasWarped() {
		return warped;
	}

	@Override
	public void setWarped(boolean warped) {
		this.warped = warped;
	}

	@Override
	public int getOrbitTime() {
		return orbitTime;
	}

	@Override
	public void setOrbitTime(int time) {
		this.orbitTime = time;
	}

	@Override
	public boolean hasTripped() {
		return tripped;
	}

	@Override
	public void setTripped(boolean tripped) {
		this.tripped = tripped;
	}

	@Nullable
	@Override
	public class_2338 getMagnetizedPos() {
		return magnetizePos;
	}

	@Override
	public void setMagnetizePos(@Nullable class_2338 pos) {
		this.magnetizePos = pos;
	}

	@Nonnull
	@Override
	public class_2596<?> method_18002() {
		return PacketSpawnEntity.make(this);
	}

	protected boolean shouldDoFakeParticles() {
		if (ConfigHandler.CLIENT.staticWandBeam.getValue()) {
			return true;
		}

		class_2586 tile = getShooter();
		return tile instanceof IManaSpreader
				&& (getMana() != getStartingMana() && fullManaLastTick
						|| Math.abs(((IManaSpreader) tile).getBurstParticleTick() - getTicksExisted()) < 4);
	}

	private void incrementFakeParticleTick() {
		class_2586 tile = getShooter();
		if (tile instanceof IManaSpreader) {
			IManaSpreader spreader = (IManaSpreader) tile;
			spreader.setBurstParticleTick(spreader.getBurstParticleTick() + 2);
			if (spreader.getLastBurstDeathTick() != -1 && spreader.getBurstParticleTick() > spreader.getLastBurstDeathTick()) {
				spreader.setBurstParticleTick(0);
			}
		}
	}

	private void setDeathTicksForFakeParticle() {
		class_2338 coords = getBurstSourceBlockPos();
		class_2586 tile = field_6002.method_8321(coords);
		if (tile != null && tile instanceof IManaSpreader) {
			((IManaSpreader) tile).setLastBurstDeathTick(getTicksExisted());
		}
	}

	public static class PositionProperties {

		public final class_2338 coords;
		public final class_2680 state;

		public boolean invalid = false;

		public PositionProperties(class_1297 entity) {
			int x = class_3532.method_15357(entity.method_23317());
			int y = class_3532.method_15357(entity.method_23318());
			int z = class_3532.method_15357(entity.method_23321());
			coords = new class_2338(x, y, z);
			state = entity.field_6002.method_8320(coords);
		}

		public boolean coordsEqual(PositionProperties props) {
			return coords.equals(props.coords);
		}

		public boolean contentsEqual(class_1937 world) {
			if (!world.method_22340(coords)) {
				invalid = true;
				return false;
			}

			return world.method_8320(coords) == state;
		}

		@Override
		public int hashCode() {
			return Objects.hash(coords, state);
		}

		@Override
		public boolean equals(Object o) {
			return o instanceof PositionProperties
					&& ((PositionProperties) o).state == state
					&& ((PositionProperties) o).coords.equals(coords);
		}
	}

}
