/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.network.PacketSpawnEntity;

import javax.annotation.Nonnull;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1496;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1682;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2397;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import java.util.List;
import java.util.function.Predicate;

public class EntityMagicMissile extends class_1682 {
	private static final String TAG_TIME = "time";
	private static final class_2940<Boolean> EVIL = class_2945.method_12791(EntityMagicMissile.class, class_2943.field_13323);
	private static final class_2940<Integer> TARGET = class_2945.method_12791(EntityMagicMissile.class, class_2943.field_13327);

	double lockX, lockY = -1, lockZ;
	int time = 0;

	public EntityMagicMissile(class_1299<EntityMagicMissile> type, class_1937 world) {
		super(type, world);
	}

	public EntityMagicMissile(class_1309 owner, boolean evil) {
		super(ModEntities.MAGIC_MISSILE, owner, owner.field_6002);
		setEvil(evil);
	}

	@Override
	protected void method_5693() {
		field_6011.method_12784(EVIL, false);
		field_6011.method_12784(TARGET, 0);
	}

	@Nonnull
	@Override
	public class_2596<?> method_18002() {
		return PacketSpawnEntity.make(this);
	}

	public void setEvil(boolean evil) {
		field_6011.method_12778(EVIL, evil);
	}

	public boolean isEvil() {
		return field_6011.method_12789(EVIL);
	}

	public void setTarget(class_1309 e) {
		field_6011.method_12778(TARGET, e == null ? -1 : e.method_5628());
	}

	public class_1309 getTargetEntity() {
		int id = field_6011.method_12789(TARGET);
		class_1297 e = field_6002.method_8469(id);
		if (e instanceof class_1309) {
			return (class_1309) e;
		}

		return null;
	}

	@Override
	public void method_5773() {
		double lastTickPosX = this.field_6038;
		double lastTickPosY = this.field_5971;
		double lastTickPosZ = this.field_5989;

		super.method_5773();

		if (!field_6002.field_9236 && (!findTarget() || time > 40)) {
			method_5650();
			return;
		}

		boolean evil = isEvil();
		Vector3 thisVec = Vector3.fromEntityCenter(this);
		Vector3 oldPos = new Vector3(lastTickPosX, lastTickPosY, lastTickPosZ);
		Vector3 diff = thisVec.subtract(oldPos);
		Vector3 step = diff.normalize().multiply(0.05);
		int steps = (int) (diff.mag() / step.mag());
		Vector3 particlePos = oldPos;

		SparkleParticleData data = evil ? SparkleParticleData.corrupt(0.8F, 1F, 0.0F, 1F, 2)
				: SparkleParticleData.sparkle(0.8F, 1F, 0.4F, 1F, 2);
		for (int i = 0; i < steps; i++) {
			field_6002.method_8406(data, particlePos.x, particlePos.y, particlePos.z, 0, 0, 0);

			if (field_6002.field_9229.nextInt(steps) <= 1) {
				field_6002.method_8406(data, particlePos.x + (Math.random() - 0.5) * 0.4, particlePos.y + (Math.random() - 0.5) * 0.4, particlePos.z + (Math.random() - 0.5) * 0.4, 0, 0, 0);
			}

			particlePos = particlePos.add(step);
		}

		class_1309 target = getTargetEntity();
		if (target != null) {
			if (lockY == -1) {
				lockX = target.method_23317();
				lockY = target.method_23318();
				lockZ = target.method_23321();
			}

			Vector3 targetVec = evil ? new Vector3(lockX, lockY, lockZ) : Vector3.fromEntityCenter(target);
			Vector3 diffVec = targetVec.subtract(thisVec);
			Vector3 motionVec = diffVec.normalize().multiply(evil ? 0.5 : 0.6);
			method_18799(motionVec.toVector3d());
			if (time < 10) {
				method_18800(method_18798().method_10216(), Math.abs(method_18798().method_10214()), method_18798().method_10215());
			}

			List<class_1309> targetList = field_6002.method_18467(class_1309.class, new class_238(method_23317() - 0.5, method_23318() - 0.5, method_23321() - 0.5, method_23317() + 0.5, method_23318() + 0.5, method_23321() + 0.5));
			if (targetList.contains(target)) {
				class_1297 owner = method_24921();
				if (owner instanceof class_1309) {
					class_1657 player = owner instanceof class_1657 ? (class_1657) owner : null;
					target.method_5643(player == null ? class_1282.method_5511((class_1309) owner) : class_1282.method_5532(player), evil ? 12 : 7);
				} else {
					target.method_5643(class_1282.field_5869, evil ? 12 : 7);
				}

				method_5650();
			}

			if (evil && diffVec.mag() < 1) {
				method_5650();
			}
		}

		time++;
	}

	@Override
	public void method_5652(class_2487 cmp) {
		super.method_5652(cmp);
		cmp.method_10569(TAG_TIME, time);
	}

	@Override
	public void method_5749(class_2487 cmp) {
		super.method_5749(cmp);
		time = cmp.method_10550(TAG_TIME);
	}

	public boolean findTarget() {
		class_1309 target = getTargetEntity();
		if (target != null) {
			if (target.method_5805()) {
				return true;
			} else {
				target = null;
				setTarget(null);
			}
		}

		double range = 12;
		class_238 bounds = new class_238(method_23317() - range, method_23318() - range, method_23321() - range, method_23317() + range, method_23318() + range, method_23321() + range);
		List<class_1309> entities;
		if (isEvil()) {
			entities = field_6002.method_18467(class_1657.class, bounds);
		} else {
			class_1297 owner = method_24921();
			Predicate<class_1309> pred = class_1301.field_6157.and(targetPredicate(owner));
			entities = field_6002.method_8390(class_1309.class, bounds, pred);
		}

		if (entities.size() > 0) {
			target = entities.get(field_6002.field_9229.nextInt(entities.size()));
			setTarget(target);
		}

		return target != null;
	}

	public static Predicate<class_1309> targetPredicate(class_1297 owner) {
		return target -> shouldTarget(owner, target);
	}

	public static boolean shouldTarget(class_1297 owner, class_1309 e) {
		// always defend yourself
		if (e instanceof class_1308 && isHostile(owner, ((class_1308) e).method_5968())) {
			return true;
		}
		// don't target tamed creatures...
		if (e instanceof class_1321 && ((class_1321) e).method_6181() || e instanceof class_1496 && ((class_1496) e).method_6727()) {
			return false;
		}

		// ...but other mobs die
		return e instanceof class_1569;
	}

	public static boolean isHostile(class_1297 owner, class_1297 attackTarget) {
		// if the owner can attack the target thru PvP...
		if (owner instanceof class_1657 && attackTarget instanceof class_1657 && ((class_1657) owner).method_7256((class_1657) attackTarget)) {
			// ... then only defend self
			return owner == attackTarget;
		}
		// otherwise, kill any player-hostiles
		return attackTarget instanceof class_1657;
	}

	@Override
	protected void method_7488(@Nonnull class_239 pos) {
		switch (pos.method_17783()) {
		case field_1332: {
			class_2248 block = field_6002.method_8320(((class_3965) pos).method_17777()).method_26204();
			if (!(block instanceof class_2261) && !(block instanceof class_2397)) {
				method_5650();
			}
			break;
		}
		case field_1331: {
			if (((class_3966) pos).method_17782() == getTargetEntity()) {
				method_5650();
			}
			break;
		}
		default: {
			method_5650();
			break;
		}
		}
	}

}
