/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.network.PacketSpawnEntity;

import javax.annotation.Nonnull;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import java.util.List;

public class EntityFlameRing extends class_1297 {
	public EntityFlameRing(class_1299<EntityFlameRing> type, class_1937 world) {
		super(type, world);
	}

	@Override
	protected void method_5693() {}

	@Override
	public void method_5670() {
		super.method_5670();

		float radius = 5F;
		float renderRadius = (float) (radius - Math.random());

		for (int i = 0; i < Math.min(90, field_6012); i++) {
			float a = i;
			if (a % 2 == 0) {
				a = 45 + a;
			}

			if (field_6002.field_9229.nextInt(field_6012 < 90 ? 8 : 20) == 0) {
				float rad = (float) (a * 4 * Math.PI / 180F);
				double x = Math.cos(rad) * renderRadius;
				double z = Math.sin(rad) * renderRadius;

				WispParticleData data1 = WispParticleData.wisp(0.65F + (float) Math.random() * 0.45F, 1F, (float) Math.random() * 0.25F, (float) Math.random() * 0.25F);
				field_6002.method_8406(data1, method_23317() + x, method_23318() - 0.2, method_23321() + z, (float) (Math.random() - 0.5F) * 0.15F, 0.055F + (float) Math.random() * 0.025F, (float) (Math.random() - 0.5F) * 0.15F);

				float gs = (float) Math.random() * 0.15F;
				float smokeRadius = (float) (renderRadius - Math.random() * renderRadius * 0.9);
				x = Math.cos(rad) * smokeRadius;
				z = Math.sin(rad) * smokeRadius;
				WispParticleData data = WispParticleData.wisp(0.65F + (float) Math.random() * 0.45F, gs, gs, gs, 1);
				field_6002.method_8406(data, method_23317() + x, method_23318() - 0.2, method_23321() + z, 0, -(-0.155F - (float) Math.random() * 0.025F), 0);
			}
		}

		if (field_6002.field_9229.nextInt(20) == 0) {
			field_6002.method_8486(method_23317(), method_23318(), method_23321(), class_3417.field_14993, class_3419.field_15245, 1F, 1F, false);
		}

		if (field_6002.field_9236) {
			return;
		}

		if (field_6012 >= 300) {
			method_5650();
			return;
		}

		if (field_6012 > 45) {
			class_238 boundingBox = new class_238(method_23317(), method_23318(), method_23321(), method_23317(), method_23318(), method_23321()).method_1009(radius, radius, radius);
			List<class_1309> entities = field_6002.method_18467(class_1309.class, boundingBox);

			if (entities.isEmpty()) {
				return;
			}

			for (class_1309 entity : entities) {
				if (entity == null || MathHelper.pointDistancePlane(method_23317(), method_23318(), entity.method_23317(), entity.method_23318()) > radius) {
					continue;
				}

				entity.method_5639(4);
			}
		}
	}

	@Override
	public boolean method_5643(@Nonnull class_1282 source, float amount) {
		return false;
	}

	@Override
	protected void method_5749(@Nonnull class_2487 var1) {}

	@Override
	protected void method_5652(@Nonnull class_2487 var1) {}

	@Nonnull
	@Override
	public class_2596<?> method_18002() {
		return PacketSpawnEntity.make(this);
	}
}
