/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.util.math.*;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.network.PacketSpawnEntity;

import java.util.List;

public class EntityFallingStar extends EntityThrowableCopy {
	public EntityFallingStar(class_1299<EntityFallingStar> type, class_1937 world) {
		super(type, world);
	}

	public EntityFallingStar(class_1309 e, class_1937 world) {
		super(ModEntities.FALLING_STAR, e, world);
	}

	@Override
	protected void method_5693() {}

	@Override
	public class_2596<?> method_18002() {
		return PacketSpawnEntity.make(this);
	}

	@Override
	public void method_5773() {
		super.method_5773();

		float dist = 1.5F;
		SparkleParticleData data = SparkleParticleData.sparkle(2F, 1F, 0.4F, 1F, 6);
		for (int i = 0; i < 10; i++) {
			float xs = (float) (Math.random() - 0.5) * dist;
			float ys = (float) (Math.random() - 0.5) * dist;
			float zs = (float) (Math.random() - 0.5) * dist;
			field_6002.method_8406(data, method_23317() + xs, method_23318() + ys, method_23321() + zs, 0, 0, 0);
		}

		class_1297 thrower = method_24921();
		if (!field_6002.field_9236 && thrower != null) {
			class_238 axis = new class_238(method_23317(), method_23318(), method_23321(), field_6038, field_5971, field_5989).method_1014(2);
			List<class_1309> entities = field_6002.method_18467(class_1309.class, axis);
			for (class_1309 living : entities) {
				if (living == thrower) {
					continue;
				}

				if (living.field_6235 == 0) {
					method_7488(new class_3966(living));
					return;
				}
			}
		}

		if (field_6012 > 200) {
			method_5650();
		}
	}

	@Override
	protected void method_7488(class_239 pos) {
		if (field_6002.field_9236) {
			return;
		}

		class_1297 thrower = method_24921();
		if (pos.method_17783() == class_239.class_240.field_1331 && thrower != null) {
			class_1297 e = ((class_3966) pos).method_17782();
			if (e != thrower && e.method_5805()) {
				if (thrower instanceof class_1657) {
					e.method_5643(class_1282.method_5532((class_1657) thrower), Math.random() < 0.25 ? 10 : 5);
				} else {
					e.method_5643(class_1282.field_5869, Math.random() < 0.25 ? 10 : 5);
				}
			}
		}

		if (pos.method_17783() == class_239.class_240.field_1332) {
			class_2338 bpos = ((class_3965) pos).method_17777();
			class_2680 state = field_6002.method_8320(bpos);
			if (ConfigHandler.COMMON.blockBreakParticles.getValue() && !state.method_26215()) {
				field_6002.method_20290(2001, bpos, class_2248.method_9507(state));
			}
		}

		method_5650();
	}
}
